#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

#include "io.h"

size_t header_check(void *buffer, size_t size, size_t nmemb, void *data)
{
    char *search;
    int http_status;
    extern CURL *logged;

    /*
     * Ci interessa soltanto l'header iniziale:
     *
     * HTTP/x.x NNN ...
     */

    if (!strncmp(buffer, "HTTP/", 5))
	if ((search = strstr(buffer + 5, " "))) {
	    http_status = atoi(++search);

	    if (http_status == 302) {	/* Non vorrei scrivere su file
					 * dati ad esso estranei, come una 
					 * redirezione. */
                if (logged)
                  error(1, "Download impedito. Problemi con la login?");

	      return -1;
}

	    if (http_status == 404) {
		error(0, "File non trovato sul server in rete (404)");
		return -1;
	    }
	    if (http_status == 416) {
		/*
		 * Si presume che l'errore sia dovuto al fatto che il file
		 *  gi completo.
		 */
		msg("File gi scaricato");
		return size*nmemb;
	    }
	    if (http_status >= 400) {
		error(0, search);
		return -1;
	    }
	}
    return size * nmemb;
}

const char *rep_strerror(CURLcode error)
{
    switch (error) {
    case CURLE_FAILED_INIT:
	return "Inizializzazione fallita";

    case CURLE_URL_MALFORMAT:
	return "URL mancante o in una forma errata";

    case CURLE_COULDNT_RESOLVE_PROXY:
	return "Non  stato possibile connettersi via proxy";

    case CURLE_COULDNT_RESOLVE_HOST:
	return
	    "Non possibile connettersi al server (nome non riconosciuto)";

    case CURLE_COULDNT_CONNECT:
	return "Non possibile connettersi al server";

    case CURLE_WRITE_ERROR:
	return "Problemi in scrittura";

    case CURLE_OPERATION_TIMEOUTED:
    	return "Operazione fuori tempo massimo";

    case CURLE_GOT_NOTHING:
	return "Il server non invia dati di alcun tipo";

    case CURLE_PARTIAL_FILE:
	return "File ricevuto in modo incompleto";
    }

    return curl_easy_strerror(error);
}
