#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include <stdlib.h>
#include <stdarg.h>
#include <curl/curl.h>
#ifdef HAVE_PWD_H
# include <pwd.h>
#endif
#include <string.h>
#include <dirent.h>
#include <errno.h>

#include "malloc.h"
#include "larepubblica.h"

#ifdef WIN32
#define mkdir(a, b) mkdir(a)
#endif

extern int errno;
struct curl_slist *edizioni_disponibili = NULL;

#ifndef WIN32
void msg(const char *fmt, ...)
{
    va_list vl;

    va_start(vl, fmt);
    vprintf(fmt, vl);
    va_end(vl);

    putchar('\n');
}

void error(int mode, const char *fmt, ...)
{
    va_list vl;

    fprintf(stderr, "ERRORE: ");

    va_start(vl, fmt);
    vfprintf(stderr, fmt, vl);
    va_end(vl);

    putc('\n', stderr);

    if (mode)
	exit(mode);
}

void explain_error(int mode, const char *fmt, ...)
{
    va_list vl;

    fprintf(stderr, "ERRORE: ");

    va_start(vl, fmt);
    vfprintf(stderr, fmt, vl);
    va_end(vl);

    fprintf(stderr, " - %s\n", strerror(errno));

    if (mode)
	exit(mode);
}
#endif

off_t file_length(int fd)
{
    struct stat st;

    fstat(fd, &st);
    return st.st_size;
}

int file_exist(const char *name)
{
    return access(name, F_OK) >= 0;
}

char *backup_name(const char *filename)
{
#define SUFFIX "~"
    size_t len = strlen(filename);
    char *newfilename = xmalloc(len + sizeof(SUFFIX));
    strcpy(newfilename, filename);
    strcpy(newfilename + len, SUFFIX);
    return newfilename;
}

int write_file(const char *filename, const char *data)
{
    if (!data)
	return 0;

    size_t len = strlen(data);

    if (!len)
	return 0;

    char *bk_name = backup_name(filename);

    if (!bk_name)
	return 0;

    int fd = open(bk_name, O_WRONLY | O_CREAT | O_TRUNC, S_IRUSR | S_IWUSR);

    if (fd < 0) {
	explain_error(0, "Nell'apertura in scritura del file %s",
		      filename);
	return 0;
    }
    ssize_t res = write(fd, data, len);

    close(fd);

    if (res > 0) {
#ifdef WIN32
	unlink(filename);
#endif
	rename(bk_name, filename);
    }

    return res;
}

char *read_file(const char *filename)
{
    int fd = open(filename, O_RDONLY);

    if (fd < 0)
	return NULL;

    off_t len = file_length(fd);

    if (len == 0) {
	close(fd);
	return NULL;
    }

    ssize_t to_read = (ssize_t) len;

    char *contenuto = (char *) xmalloc(len + 1);

/* PROBLEMA: Andrebbe verificato se len  > del massimo leggibile da read(), visto che len pu essere pi grande di 4096 byte? */

    char *read_ptr = (char *) contenuto;
    do {
	ssize_t nb = read(fd, read_ptr, to_read);
	if (nb <= 0) {
#ifdef EINTR
	    if (nb == -1 && errno == EINTR)
		continue;
#endif
	    error(0, "Errore in lettura per \"%s\": %s", filename,
		  strerror(errno));
	    close(fd);
	    return NULL;
	}
	read_ptr += nb;
	to_read -= nb;
    }
    while (to_read > 0);

    *read_ptr = '\0';

/* Se c' un byte NULL all'interno del file (succede in tutti i file HTML
ricevuti dal server), allora lo eliminiamo. */

    size_t check_len;

    while ((check_len = strlen(contenuto)) && (check_len < len)) {
	memmove(contenuto + check_len, contenuto + check_len + 1,
		len - check_len);
	len--;
    }
    close(fd);
    return contenuto;
}

void create_dirs(char *filename)
{
    char *s = filename;

    while ((s = strchr(s, '/')) != NULL) {
	char *p = xstrndup(filename, s++ - filename);
	if (access(p, F_OK) < 0 && *p) {
	    if (mkdir(p, 0777))
		explain_error(0,
			      "Errore nella creazione della directory %s",
			      p);
	}
	free(p);
    }
    return;
}

char *salta_dir(const char *ind, int n)
{
    for (; (*ind && n); *ind++)
	if (*ind == '/')
	    n--;

    return (char *) ind;
}

size_t
simple_write_data(void *buffer, size_t size, size_t nmemb, FILE * stream)
{
    return fwrite(buffer, size, nmemb, stream);
}

#ifndef WIN32
char *home_dir(void)
{
    char *home = getenv("HOME");

    if (!home) {
	/* If HOME is not defined, try getting it from the password
	   file.  */
	struct passwd *pwd = getpwuid(getuid());
	if (!pwd || !pwd->pw_dir)
	    return NULL;
	home = pwd->pw_dir;
    }
    return home ? xstrdup(home) : NULL;
}
#endif
/*
** wbfcopy.c
** by: Walter Bright via Usenet C newsgroup
**
** modified by: Bob Stout, Ray Gardner, and David Gersic
**
** There is no point in going to asm to get high speed file copies. Since it
** is inherently disk-bound, there is no sense (unless tiny code size is
** the goal). Here's a C version that you'll find is as fast as any asm code
** for files larger than a few bytes (the trick is to use large disk buffers):
*/

typedef enum { Error_ = -1, Success_, False_ = 0, True_ } Boolean_T;

int fdcopy(int fdfrom, int fdto)
{
    int bufsiz, retval = Error_;

    /* Use the largest buffer we can get    */

    for (bufsiz = 0x4000; bufsiz >= 128; bufsiz >>= 1) {
	register char *buffer;

	buffer = (char *) xmalloc(bufsiz);
	if (buffer) {
	    while (1) {
		register int n;

		n = read(fdfrom, buffer, bufsiz);
		if (n == -1)	/* if error             */
		    break;
		if (n == 0) {	/* if end of file       */
		    retval = Success_;
		    break;
		}
		if (n != write(fdto, buffer, (unsigned) n))
		    break;
	    }
	    free(buffer);
	    break;
	}
    }
    return retval;
}

int file_copy(char *from, char *to)
{
    int fdfrom, fdto;

    fdfrom = open(from, O_RDONLY);
    if (fdfrom < 0) {
	return Error_;
    }
    /* Open R/W by owner, R by everyone else        */

    fdto = open(to, O_CREAT | O_TRUNC | O_RDWR, S_IREAD | S_IWRITE);
    if (fdto >= 0) {
	if (Success_ == fdcopy(fdfrom, fdto)) {
	    close(fdto);
	    close(fdfrom);
	    return Success_;
	} else {
	    close(fdto);
	    remove(to);		/* delete any partial file  */
	}
    }
    close(fdfrom);
    return Error_;
}

#ifdef WIN32
void translate_chars_to_vfat(char *p)
{
    while (*p++) {
      if (*p == '\\')
	    *p = '_';
	if (*p == '/')
	    *p = '\\';
	if (*p == '?')
	    *p = '@';
	if (*p == '*')
	    *p = '^';
    }
}
#endif

void file_vuoto(const char *fname)
{
    FILE *f = fopen(fname, "w");
    if (f)
	fclose(f);
    else
	explain_error(0, "Non possibile aprire %s", fname);
}

void stampa_edizioni_disponibili()
{
    extern const char *settimana[];
    struct curl_slist *slist;
    struct tm tm;

    for (slist = edizioni_disponibili; slist; slist = slist->next) {
	time_t t = decomponi_stringa_edizione2(slist->data);
	tm = *(localtime(&t));
	msg("%d %d %d %s", 1900 + tm.tm_year, tm.tm_mon, tm.tm_mday,
	    settimana[tm.tm_wday]);
    }
}

void lista_edizioni_disponibili()
{
// Apre la directory che contiene le directory che hanno per nome
// la data dell'edizione a cui sono legate.
    DIR *dfd = opendir(POS);
    struct dirent *dent;
    char filename[sizeof(POS) + FILENAME_MAX + sizeof(S1) + 2];

    while ((dent = readdir(dfd))) {
	if (!strncmp("Edizione_", dent->d_name, sizeof("Edizione_") - 1)) {
	    sprintf(filename, POS "%s/" S1, dent->d_name);
	    if (file_exist(filename)) {
		//numero_copie_disponibili++;
		//numero_copie_HTML++;
		if (!ctrl_list(dent->d_name, edizioni_disponibili))
		    edizioni_disponibili =
			curl_slist_append(edizioni_disponibili,
					  dent->d_name);
	    }
	}
    }
    closedir(dfd);
}
