/*
 * La Repubblica online downloader
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef HAVE_WINCONFIG_H
# include "MSWin_config.h"
#endif

#include <stdio.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <signal.h>

#include <curl/curl.h>
#include <curl/mprintf.h>

#include "cfg.h"
#include "input.h"

#include <errno.h>

extern int errno;

#define USERAGENT "LaRepDL/"VERSION

Configurazione config;

#include "larepubblica.h"
#include "curl.h"

struct curl_slist *mappe_url_slist = NULL;
struct curl_slist *art_url_slist = NULL;
struct curl_slist *art_url_slist_downloaded = NULL;
struct curl_slist *generic_slist_downloaded = NULL;
struct curl_slist *jpg_slist = NULL;
struct curl_slist *naz_type_page_slist = NULL;

static char *edizione_in_download;
static char *url_edizione_basedir;
static char *filename_edizione_basedir;

static CURL *curl;
CURL *logged = NULL;

char *url_cat (char *base_url, char *url_string);
char *url2path (char *url);
static void aggiusta_nome (char *buffer, int mode);

FILE *
fopen_from_url (char *url, const char *mode)
{
  char *filename = url2path (url);
  FILE *f = fopen (filename, mode);
  free (filename);
  return f;
}

static char *
read_file_from_url (char *url)
{
  char *filename = url2path (url);
  char *resbuf = read_file (filename);
  free (filename);
  return resbuf;
}

void
ck_close (struct curl_slist **l)
{
  if (*l)
    curl_slist_free_all (*l);

  *l = NULL;
}

static int
ctrl_n_list (const char *testo, struct curl_slist *slist, size_t n)
{
  while (slist)
    {
      if (!strncmp (testo, slist->data, n))
	return 1;
      slist = slist->next;
    }
  return 0;
}

int
ctrl_list (const char *testo, struct curl_slist *slist)
{
  while (slist)
    {
      if (!strcmp (testo, slist->data))
	return 1;
      slist = slist->next;
    }
  return 0;
}

/* Carica file con l'elenco dei file già scaricati. */

#define FILEREGISTRO_NOME ".registro"

static void
carica_registro ()
{
  char nomefile[strlen (filename_edizione_basedir) +
		sizeof (FILEREGISTRO_NOME)];

  curl_msprintf (nomefile, "%s" FILEREGISTRO_NOME, filename_edizione_basedir);

  FILE *fileregistro = fopen (nomefile, "rb");

  if (fileregistro)
    {
      char riga[4096];
      while (fgets (riga, 4096, fileregistro))
	{
	  /* Tolgo LF prima di inserire. */
	  riga[strlen (riga) - 1] = '\0';
	  generic_slist_downloaded =
	    curl_slist_append (generic_slist_downloaded, riga);
	}
      fclose (fileregistro);
    }
}

/* Scrive file con l'elenco dei file scaricati.  */
static void
scrivi_registro ()
{
  if (!generic_slist_downloaded)
    return;

  char nomefile[strlen (filename_edizione_basedir) +
		sizeof (FILEREGISTRO_NOME)];

  curl_msprintf (nomefile, "%s" FILEREGISTRO_NOME, filename_edizione_basedir);

  FILE *fileregistro = fopen (nomefile, "wb");

  if (fileregistro)
    {
      struct curl_slist *slist = generic_slist_downloaded;

      while (slist)
	{
	  fputs (slist->data, fileregistro);
	  fputc (10, fileregistro);
	  slist = slist->next;
	}
      fclose (fileregistro);
    }
}

/* La prima e l'ultima mappa contiene URL che puntano ad un file contenuto nella
directory Static_Pages. Per via del suo contenuto costante, questa directory  stata
spostata, dovremmo aggiungere '../' a queste poche URL, altrimenti ci sar nella prima
pagina e l'ultima del quotidiano un grande contrassegno di immagine mancante...  */

static char *
sistema_inezie (char *s, const char *pattern)
{
  char *start = s;
  int n = 0;

  while ((s = strstr (s, pattern)))
    {
      n++;
      *s++;
    }

  if (n > 0)
    {
      start = xrealloc (start, strlen (start) + 4 * n);
      s = start;

      while ((s = strstr (s, pattern)))
	{
	  *s++;
	  memmove (s + 3, s, strlen (s) + 1);
	}
    }
  return start;
}

void
cancella_testo (char *s, const char *da_qui, const char *a_qui)
{
  if (!s)
    return;

  char *e;
  size_t qui_len = strlen (a_qui);

  while ((s = strstr (s, da_qui)))
    {
      e = strstr (s + 1, a_qui);

      if (!e)
	return;

      e += qui_len;
      memmove (s, e, strlen (e) + 1);
    }
}

/* Modifica i file mappa per linkare gli articoli salvati con il nome abbreviato rispetto all'URL */
static void
modifica_mappa (char *buffer, char *filename)
{
  char *ptr = buffer;
  char *prev_ptr = buffer;
  char *start_string;

  char *backupname = backup_name (filename);

  FILE *file = fopen (backupname, "w");

  while ((ptr = strstr (ptr, "\"../../CheckSecurity.chk")))
    {
      fwrite (prev_ptr, 1, ptr - prev_ptr, file);
      start_string = ++ptr;

      fputc ('"', file);

      ptr = strstr (ptr, "\"");

      if (!ptr)
	{
	  error (0, "Il file \"%s\" ha URL incorretta alla posizione %d",
		 filename, start_string - buffer);
	  prev_ptr = start_string - 1;
	  break;
	}

      if (ctrl_n_list
	  (start_string, art_url_slist_downloaded, ptr - start_string))
	{
	  aggiusta_nome (start_string, 0);

	  /* Accorcia l'url togliendo parti inutili */
	  start_string += 3;

	  /* Accorcia l'url togliendo '../' all'inizio */
	  fputs (start_string, file);

	  fputc ('"', file);
	}
      else
	while (start_string <= ptr)
	  fputc (*start_string++, file);

      prev_ptr = ++ptr;
    }

  fwrite (prev_ptr, 1, strlen (prev_ptr), file);
  fclose (file);

#ifdef WIN32
  unlink (filename);
#endif
  rename (backupname, filename);
  free (backupname);
}

static void
modifica_le_mappe ()
{
  if (!art_url_slist_downloaded)
    return;

  if (!mappe_url_slist)
    return;

  msg ("Aggiustamenti alle mappe...");

  struct curl_slist *slist = mappe_url_slist;
  char buffer[strlen (url_edizione_basedir) + strlen (slist->data)];
  char *filemappa;

  for (; slist; slist = slist->next)
    {
      switch (config.formato_edizione)
	{
	case TESTO:
	  filemappa = url2path (slist->data);
	  break;
	default:
	  sprintf (buffer, "%s%s", url_edizione_basedir + 7, slist->data);
	  filemappa = url2path (buffer);
	}

      char *file_html = read_file (filemappa);

      if (file_html)
	{
	  file_html = sistema_inezie (file_html, "\"../Static_Pages");
	  modifica_mappa (file_html, filemappa);
	  free (file_html);
	}
      free (filemappa);
    }
}

/* Bisogna togliere il comando di refresh, aggiustare il path del css e modificare l'url ad eventuali articoli. */

static void
modifica_gli_articoli_html_con_jpg ()
{
  if (!art_url_slist_downloaded)
    return;

  struct curl_slist *slist = art_url_slist_downloaded;

  msg ("Aggiustamenti agli articoli...");

  for (; slist; slist = slist->next)
    {
      char *art = url_cat (url_edizione_basedir, slist->data);
      char *filename_art = url2path (art);
      char *file_html = read_file (filename_art);

      if (file_html)
	{
	  cancella_testo (file_html,
			  "<META http-equiv=\"Refresh\" content=\"", "\">");

/* Potremmo occuparci anche dei commenti? */
//          cancella_testo(file_html, "<!--", "-->");

/* href="CheckSecurity.chk?Action=Refresh&url=XXXX.html&data=20041101&giornale=repubblica" */
/* loadGirata(3,'CheckSecurity.chk?Action=Update&url=XXXX.html&data=20041101&giornale=repubblica' */

	  cancella_testo (file_html, "CheckSecurity.chk?", "&url=");
	  cancella_testo (file_html, "&data=", "giornale=repubblica");

/* "../repubblica/Edizione_01_Novembre_2004/Scorri_pagine.js" */

	  cancella_testo (file_html, "repubblica/Edizione",
			  edizione_in_download);

/* Rattoppiamo il percorso al css da "../html/css/" a "../../../html/css/"  */
	  char *css = strstr (file_html, "\"../html/css/");

	  if (css)
	    {
	      size_t q = css + 1 - file_html;
	      file_html = xrealloc (file_html, strlen (file_html) + 6 + 1);
	      memmove (file_html + q + 6, file_html + q,
		       strlen (file_html + q) + 1);
	      memcpy (file_html + q + 3, "../", 3);
	    }
	  write_file (filename_art, file_html);
	  free (file_html);
	}
      free (art);
      free (filename_art);
    }
}

static void
chiusura_ciclo ()
{
  ck_close (&art_url_slist);

/* Preferibile impedire il Ctrl+C qui sotto.  */

  scrivi_registro ();
  modifica_le_mappe ();

  switch (config.formato_edizione)
    {
    case TESTO:
      break;
    default:
      modifica_gli_articoli_html_con_jpg ();
    }

  ck_close (&art_url_slist_downloaded);
  ck_close (&generic_slist_downloaded);
  ck_close (&jpg_slist);
  ck_close (&mappe_url_slist);
  ck_close (&naz_type_page_slist);
}

static size_t
check_error_logout (void *buffer, size_t size,
		     size_t nmemb, void *data)
{
  return size * nmemb;
}

/* Senza logout, perso il riferimento per l'accesso, bisognerebbe
   attendere dei minuti per poter riaccedere. */

void
perform_logout (int signum)
{
  if (!logged)
    return;

  msg ("Richiesta di scollegamento dal server");

  curl_easy_setopt (logged, CURLOPT_RESUME_FROM, 0);
  curl_easy_setopt (logged, CURLOPT_URL, LAREPUBBLICA_LOGOUT);
// Il metodo HEAD sembra non funziona adesso.
  curl_easy_setopt (logged, CURLOPT_NOBODY, 0);
  curl_easy_setopt (logged, CURLOPT_HEADERFUNCTION, 0);
  curl_easy_setopt (logged, CURLOPT_WRITEFUNCTION, check_error_logout);

  CURLcode res = curl_easy_perform (logged);

  curl_easy_setopt (logged, CURLOPT_NOBODY, 0);

  if (res != 0)
    error (0, "Logout non riuscito (codice: %d)", res);
  else
    {
      msg ("Scollegato.");
      logged = 0;
      return;
    }
}

void
chiusura ()
{
  perform_logout (0);
  chiusura_ciclo ();
  curl_slist_free_all (dl_edizioni_slist);
  dl_edizioni_slist = NULL;
  curl_easy_cleanup (curl);
  unload_config ();
#ifndef WIN32
  exit (0);
#endif
}

/*
 Nella pagina html di risposta la riga "var userl=n" del suo codice
 javascript indica il tipo di errore. n  un numero da 1 a 5.
*/

static size_t
check_error_login_abbonati (void *buffer, size_t size,
			    size_t nmemb, void *data)
{
  char *search;
  const char *err_string = " var userl=";

  search = strstr (buffer, err_string);

  if (search)
    {
      search += strlen (err_string);

      switch (*search)
	{
	case '1':
	  error (1, "Utente non valido");
	  break;
	case '2':
	  error (1,
		 "Utente non registrato al servizio oppure abbonamento scaduto (verificabile sul sito)");
	  break;
	case '3':
	  error (1, "Impossibile verificare autenticazione");
	  break;
	case '4':
	  error (1, "Password non valida");
	  break;
	case '5':
	  error (1, "Utente o password mancante");
	  break;
	case '6':
	  error (1,
		 "L'utente risulta gi connesso. Non credo di poter proseguire");
	  break;
	default:
	  error (1,
		 "Errore sconosciuto nell'autenticazione dell'utente abbonato");
	}
    }
  return size * nmemb;
}

/*
  Nella pagina html di risposta la stringa "<span id="error"><b>testo</b></span>"
  include la frase spiegante l'errore occorso.
*/

static size_t
check_error_login_phonekey (void *buffer, size_t size,
			    size_t nmemb, void *data)
{
  char *search, *end;
  const char *err_string = "<span id=\"error\">";

  search = strstr (buffer, err_string);

  if (search)
    {
      search += strlen (err_string);
      end = strstr (search, "</span>");

      if (*search == '<')
	if (*++search == 'b')
	  if (*++search == '>')
	    {
	      search++;
	      if (end)
		{
		  end -= 4;
		  *end = '\0';
		}
	    }
      error (1, search);
    }
  return size * nmemb;
}

static CURLcode
access_request ()
{
  char *postdata = NULL, *url = ACCESS_ABB_URL;

  switch (config.tipo_accesso)
    {
    case CHIAVE_TELEFONICA:
/*
  FIXME: Scrivi nel log delle chiavi
*/
      postdata =
	(char *) xmalloc (sizeof (TEL_STRING) + strlen (config.key) + 1);
      curl_msprintf (postdata, TEL_STRING "%s", config.key);
      url = ACCESS_TEL_URL;
      curl_easy_setopt (curl, CURLOPT_WRITEFUNCTION,
			check_error_login_phonekey);
      break;
    case ABBONATO:
      postdata =
	(char *) xmalloc (sizeof (ABB_STRING) + strlen (config.username) +
			  strlen (config.password) + 1);
      curl_msprintf (postdata, ABB_STRING, config.username, config.password);
      curl_easy_setopt (curl, CURLOPT_WRITEFUNCTION,
			check_error_login_abbonati);
      break;
    }

  curl_easy_setopt (curl, CURLOPT_HEADERFUNCTION, 0);
  curl_easy_setopt (curl, CURLOPT_COOKIEFILE, "cookie");
  curl_easy_setopt (curl, CURLOPT_RESUME_FROM, 0);
  curl_easy_setopt (curl, CURLOPT_URL, url);
  curl_easy_setopt (curl, CURLOPT_POSTFIELDS, postdata);
  curl_easy_setopt (curl, CURLOPT_WRITEDATA, 0);

  CURLcode res = curl_easy_perform (curl);

  free (postdata);
  curl_easy_setopt (curl, CURLOPT_HTTPGET, 1);

  if (res == 0)
    {
      logged = curl;
      signal (SIGINT, perform_logout);
    }
  else
    error (1, "%s - %s", rep_strerror (res), url);
  return res;
}

/*
 Concatena due parti di un indirizzo web, agendo opportunatamente in
 caso di direttive per il riferimento a parent directory. Presuppone che
 l'intestazione "http://" sia presente gi nella parte iniziale
 dell'indirizzo.
*/

char *
url_cat (char *base_url, char *url_string)
{
  int dir = -1;
  int subdir = 0;
  char *p = base_url + 7;	/* 'http://' = 7 */

  while (*p)
    if (*p++ == '/')
      dir++;

  if (*--p != '/')
    dir++;

  while (!strncmp (url_string, "../", 3))
    {
      url_string += 3;
      subdir++;
    }

  if (subdir > dir)
    {
      error (0, "URL non valida individuata");
      return NULL;
    }

  if (subdir == 0)
    {
      char *newurl = xmalloc (strlen (base_url) + strlen (url_string) + 1);
      sprintf (newurl, "%s%s", base_url, url_string);
      return newurl;
    }
  else
    {
      p = base_url + 7;
      int len = strlen (p);
      char *s = p + --len;

      while (s != p && subdir > 0)
	if (*s-- == '/')
	  subdir--;

      len = s - p;

      char *newurl =
	xmalloc (1 + strlen (base_url) + strlen (url_string) + 10);
      strncpy (newurl, base_url, 7 + len + 2);
      newurl[7 + len + 2] = '\0';
      strcat (newurl, url_string);

      return newurl;
    }
}

/*
 Aggiunge alla lista un url se questo non  gi stato inserito. 'buffer'
  l'indirizzo di partenza, 'len' stabilisce il massimo spostamento da
 'buffer', il quale contiene l'intera pagina html.
*/

static void
url_append (const char *buffer, size_t len, struct curl_slist **slist)
{
  char string[len + 1];

  strncpy (string, buffer, len);
  string[len] = '\0';

  if (!ctrl_list (string, *slist))
    *slist = curl_slist_append (*slist, string);
}

/*
 Prende URL in base ad un pattern (devono essere racchiuse fra
 virgolette)

 Es: get_url(buffer, "href=\"", 6);
*/

static void
get_url (char *buffer, const char *pattern, size_t offset,
	 struct curl_slist **slist)
{
  char *pos = buffer;
  char *str_end;

  while ((pos = strstr (pos, pattern)) != NULL)
    {
      pos += offset;
      str_end = strstr (pos + strlen (pattern), "\"");
      if (str_end)
	url_append (pos, str_end - pos, slist);
    }
}

const char *edizioni[] =
  { "Nazionale", "Bari", "Bologna", "Firenze", "Genova", "Milano",
  "Napoli", "Palermo", "Roma", "Torino"
};

enum
{ NAZIONALE, BARI, BOLOGNA, FIRENZE, GENOVA, MILANO, NAPOLI, PALERMO,
  ROMA, TORINO, FINE
};

const char *sezioni[] = { "Prima Pagina", "Interni", "Esteri", "Economia",
  "Commenti", "Pubblicit&agrave;", "Cronaca", "Sport", "Spettacoli", "Tempo",
  "Varie", "Automotori", 0
};

enum
{ PRIMAPAGINA, INTERNI, ESTERI, ECONOMIA, COMMENTI, PUBBLICITA, CRONACA,
    SPORT, SPETTACOLI, TEMPO, VARIE, AUTOMOTORI };

int numero_pagine[FINE];
#define MAXPAGE 300
int page_type[MAXPAGE];
int page_type_counter;

static void
parse_scorri_file (FILE * file)
{
  const char *numpag_pattern = " var numPagine";
  const char *url_loc_pattern = "pagine";
  const char *url_naz_pattern = "mappe/NZ";
  const char *pag_type_pattern = " pagineSezione[";

  char buffer[4096], strbuf[4096];

//  if (!file)
//    error(1, "Non riesco ad accedere al file");

  page_type_counter = 0;

  while (fgets (buffer, 4096, file))
    {
      int edn;

      for (edn = 0; edn < FINE; edn++)
	{
	  int refer;
	  strbuf[0] = '\0';
	  strcat (strbuf, numpag_pattern);
	  strcat (strbuf, edizioni[edn]);
	  refer = strlen (strbuf);

	  if (!strncmp (strbuf, buffer, refer))
	    {
	      numero_pagine[edn] = atoi (buffer + refer + 1) * 2;
	      break;
	    }
	}

      char *c_refer;

      c_refer = strstr (buffer, url_naz_pattern);
      if (c_refer)
	{
	  *strstr (c_refer, "\"") = '\0';
	  mappe_url_slist = curl_slist_append (mappe_url_slist, c_refer);
	}

      if (config.ediz_local_selection)
	{

	  struct curl_slist *slist;

	  for (slist = config.ediz_local_selection; slist;
	       slist = slist->next)
	    {
	      strbuf[0] = '\0';
	      strcat (strbuf, url_loc_pattern);
	      strcat (strbuf, slist->data);
	      strcat (strbuf, "[");
	      c_refer = strstr (buffer, strbuf);
	      if (c_refer)
		c_refer = strstr (buffer, "= \"");
	      if (c_refer)
		{
		  c_refer += 3;
		  *strstr (c_refer, "\"") = '\0';
		  mappe_url_slist =
		    curl_slist_append (mappe_url_slist, c_refer);
		  break;
		}
	    }
	}

      strbuf[0] = '\0';

      // strcat (strbuf, pag_type_pattern);
      // c_refer = strstr (buffer, strbuf);
      // if (c_refer)
      // {
      // c_refer = strstr (c_refer, "]");
      // c_refer += 3;
      // for (edn = 0; edn < SPET + 1; edn++)
      // {
      // if (!strncmp (c_refer, sezioni[edn], strlen (sezioni[edn])))
      // {
      // if (page_type_counter == MAXPAGE)
      // page_type[page_type_counter++] = edn;
      //
      // break;
      // }
      // }
      // }
    }
}

/*
 Per un pi gestibile nome degli articoli. La funzione modifica il buffer accorciando
 il nome, la parte iniziale dell'URL viene sostituita per indicare una posizione sul
 filesystem diversa da quella originale.
*/

static void
aggiusta_nome (char *buffer, int mode)
{
  char *r = strstr (buffer, "CheckSecurity.chk");

  if (!r)
    {
      r = strstr (buffer, "a.chk");
      if (!r)
	return;
    }
  /* Per togliere le stringhe in eccesso. */

  char *art = strstr (r, "&url=");

  if (!art)
    {
      art = strstr (r, "&selSezione=");
      if (!art)
	return;
      art += (sizeof ("&selSezione=") - 1);
      curl_msprintf (r, "%sarticoli/%s", mode ? edizione_in_download : "",
		     art);
      return;
    }

  char *end = strstr (art, "&data=");

  if (!end)
    return;

  art += (sizeof ("&url=") - 1);

  char nomearticolo[end - art];

  strncpy (nomearticolo, art, end - art);
  nomearticolo[end - art] = '\0';

  curl_msprintf (r, "%sarticoli/%s", mode ? edizione_in_download : "",
		 nomearticolo);
}

static void
Xaggiusta_nome (char *buffer, int mode)
{
  char *r = strstr (buffer, "CheckSecurity.chk");

  if (!r)
    return;

  /* Per togliere le stringhe in eccesso. */

  char *art = strstr (r, "&url=");
  char *end = strstr (art, "&data=");

  if (!(art || end))
    return;

  art += 5;

  char nomearticolo[end - art];

  strncpy (nomearticolo, art, end - art);
  nomearticolo[end - art] = '\0';

  curl_msprintf (r, "%sarticoli/%s", mode ? edizione_in_download : "",
		 nomearticolo);
}

static char *
sostituisci (char *org, const char *r, const char *v)
{
  int rlen = strlen (r);
  int lendiff = rlen - strlen (v);

  if (lendiff < 0)
    return org;

  if (strstr (org, v))
    {
      org = xrealloc (org, strlen (org) + lendiff + 1);

      char *ver = strstr (org, v);
      memmove (ver + lendiff - 1, ver, strlen (ver) + 1);
      memcpy (ver, r, rlen);
    }
  return org;
}

/*
 Partendo da un indirizzo web completo, fornisce un percorso nel file
 system.
*/

char *
url2path (char *url)
{
  if (url == NULL)
    return NULL;

  url = xstrdup (url);

/* Scorri_pagine.js  un caso particolare, non si pu modificare
convenientemente la sua posizione adesso, solo dopo che  stato
esaminato. */

  if (!strstr (url, SCORRI_PAGINE_FILE))
    {
/* Modifichiamo qui, se  il caso, la stringa "Edizione_Giornaliera", con
una non generica, con data precisa. */
      if (edizione_in_download)
	url = sostituisci (url, edizione_in_download, "Edizione_Giornaliera");
    }

  char *pointer = url;

  /* Parti dell'URL da scartare. */
  if (strstr (url, "http://") != NULL)
    url += 7;

  /* Ulteriori preparazioni.  */
  url = salta_dir (url, 1);
  aggiusta_nome (url, 1);

  /*  */

  size_t len = strlen (url);
  char *s = url;

  /* Se termina con un nome di directory */
  if (s[len - 1] == '/')
    {
      create_dirs (url);
      /* pi "index.html" in url */
    }
  else
    {
/* Separa insieme di directory dal nome terminante del file (e crea le directory mancanti) */
      while (len--)
	{
	  if (s[len] == '/')
	    {
	      char *p = (char *) xstrndup (s, len + 1);
	      create_dirs (p);
	      free (p);
	      break;
	    }
	}
    }

  char *return_string = xstrdup (url);
  free (pointer);

#ifdef WIN32
  translate_chars_to_vfat (return_string);
#endif
  return return_string;
}

#ifdef WIN32
extern int THREAD_STOP;
#endif

int
controlla_fine_html (const char *filename, unsigned long offset)
{
  char *m = read_file (filename);
  int flag = 0;

  if (m)
    {
      if (!strstr (m, "</HTML>"))
	flag = 1;
      free (m);
    }

  return flag;
}

int
controlla_fine_file (const char *filename, char *stringa, unsigned long len)
{
  size_t slen = strlen (stringa);
  char buffer[slen + 1];
  FILE *f = fopen (filename, "rb");
  fseek (f, len - slen - 1, SEEK_SET);
  fread (buffer, 1, slen, f);
  fclose (f);
  buffer[slen] = '\0';

  return strncmp (buffer, stringa, slen - 1);
}


CURLcode
download_file (char *full_url, int mode)
{
#ifdef WIN32
  if (THREAD_STOP)
    {
      msg ("*** Interruzione manuale.");
      se_chiudere (1);
    }
#endif

  CURL *handle = curl;
  char *filename = url2path (full_url);
  unsigned long resume_from = 0;
  struct stat stat_for_size;
  int possibile_file_html_incompleto = 0;

if (!mode) {
  if (!stat (filename, &stat_for_size))
    resume_from = stat_for_size.st_size;

  if (resume_from) {
    if (!controlla_fine_file (filename, "</HTML>", resume_from))
      {
	msg ("Il file HTML risulta completo, il download non si verificher");
	free (filename);
	return 0;
      }
    else
      possibile_file_html_incompleto = 1;
  }
}

  FILE *newfile = fopen (filename, resume_from ? "ab" : "wb");

  if (!newfile)
    {
      explain_error (0, "Errore all'apertura del file \"%s\"", filename);
      free (filename);
      return CURLE_WRITE_ERROR;
    }

  curl_easy_setopt (handle, CURLOPT_HEADERFUNCTION, header_check);
  curl_easy_setopt (handle, CURLOPT_RESUME_FROM, resume_from);
  curl_easy_setopt (handle, CURLOPT_URL, full_url);
  curl_easy_setopt (handle, CURLOPT_WRITEDATA, newfile);
  curl_easy_setopt (handle, CURLOPT_WRITEFUNCTION, simple_write_data);

  CURLcode res = curl_easy_perform (handle);

//    if (!file_length(fileno(newfile))){
//       fclose(newfile);
//       remove(filename);
//    } else
  fclose (newfile);

  if (res == CURLE_HTTP_RANGE_ERROR)
    {
// Si presume si abbia a che fare con un articolo e si controlla
// se questo non sia gi completo, se non lo , si apre una nuova istanza di download.
      if (possibile_file_html_incompleto)
	{
	  msg ("Intercettato articolo gi prelevato incompleto...");
	  file_vuoto (filename);
	  if (!download_file (full_url, 0))
	    res = 0;
	}
    }
  else if (res > 0)
    error (0, "%s - %s", rep_strerror (res), full_url);

  free (filename);

  return res;
}

static void
download_loop (char *baseurl, struct curl_slist *slist,
	       struct curl_slist **slist_downloaded)
{
  char *newurl;
  unsigned int download_corretti = 0;
  unsigned int numero_link = 0;

  for (; slist != NULL; slist = (struct curl_slist *) slist->next)
    {

/* Controlla nel registro se il file  gi stato scaricato */
      if (ctrl_list (slist->data, *slist_downloaded))
	continue;

      numero_link++;

      if (baseurl)
	newurl = url_cat (baseurl, slist->data);
      else
	newurl = slist->data;

      if (!download_file (newurl, 0))
	{
	  download_corretti++;
	  *slist_downloaded =
	    curl_slist_append (*slist_downloaded, slist->data);
	}
      if (baseurl)
	free (newurl);
    }
//    msg("Download: %d di %d", download_corretti, numero_link);
}

static int
scan_file_testo (char *full_url)
{
  char *testo = read_file_from_url (full_url);

  if (!testo)
    return 1;

  get_url (testo, "\"a.chk?Action=updateLight&url", 1, &art_url_slist);

  free (testo);
  return 0;
}

static int
scan_file_html_con_jpg (char *full_url)
{
  char *testo = read_file_from_url (full_url);

  if (!testo)
    return 1;

  get_url (testo, "\"../../CheckSecurity", 1, &art_url_slist);
  get_url (testo, "\"../images/", 1, &jpg_slist);

  free (testo);

  return 0;
}

static void
geturl_loop_testo (struct curl_slist *slist)
{
  for (; slist; slist = slist->next)
    {
      if (scan_file_testo (slist->data) > 0)
	error (0, slist->data);
    }
}

static void
geturl_loop_html_con_jpg (char *baseurl, struct curl_slist *slist)
{
  char *newurl;

  for (; slist; slist = slist->next)
    {
      newurl = url_cat (baseurl, slist->data);

      if (scan_file_html_con_jpg (newurl) > 0)
	error (0, newurl);

      free (newurl);
    }
}

static const char *mesi[] =
  { "Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno", "Luglio",
"Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre" };

time_t
decomponi_stringa_edizione2 (const char *stringa)
{

  struct tm tm;
  char *start = xstrdup (stringa + sizeof ("Edizione_") - 1);
  char *s = start;
  tm.tm_mday = atoi (s);
  s += 3;

// stringa pu avere un '/' al termine
  char *a = s + strlen (s) - ((s[strlen (s) - 1] == '/') ? 5 : 4);
  tm.tm_year = atoi (a) - 1900;
  *--a = '\0';

  for (tm.tm_mon = 0; tm.tm_mon < 12; tm.tm_mon++)
    if (!strcmp (mesi[tm.tm_mon], s))
      break;

  free (start);
  tm.tm_wday = 0;
  tm.tm_hour = 0;
  tm.tm_min = 0;
  tm.tm_sec = 0;
  tm.tm_yday = 0;
  tm.tm_isdst = -1;

  return mktime (&tm);;
}

struct minitm
decomponi_stringa_edizione (const char *stringa)
{
  struct minitm minitm;

//    char *s = (char *) stringa + sizeof("Edizione_") - 1;
  char *start = xstrdup (stringa + sizeof ("Edizione_") - 1);
  char *s = start;

  minitm.giorno = atoi (s);
  s += 3;

  char *a = s + strlen (s) - 4;
  minitm.anno = atoi (a);
  *--a = '\0';

  for (minitm.mese = 0; minitm.mese < 12; minitm.mese++)
    if (!strcmp (mesi[minitm.mese], s))
      break;

  free (start);
  minitm.mese++;

  return minitm;
}

char *
componi_stringa_edizione (int giorno, int mese, int anno)
{
  static char buffer[30];

  *buffer = '\0';

  if (mese > 11)
    mese = 11;

  curl_msprintf (buffer, "Edizione_%.2d_%s_%d/", giorno, mesi[mese], anno);
  return buffer;
}

/* Per ricavare la data dell'edizione dall'indirizzo di una mappa */
static char *
ricava_data_da_mappa ()
{
  char *s = xstrndup (mappe_url_slist->data + 12, 7);

  *(s + 6) = '\0';
  int year = atoi (s + 4);
  *(s + 4) = '\0';
  int mon = atoi (s + 2);
  *(s + 2) = '\0';
  int day = atoi (s);

  free (s);
  return componi_stringa_edizione (day, mon - 1, 2000 + year);
}

#include "htmlbase.c"

void
rename_from_url (char *oldurl, const char *newpath, const char *filename)
{
  char *uold = url2path (oldurl);
//char *unew = url2path(newurl);

  char *unew = xmalloc (strlen (newpath) + strlen (filename) + 1);

  sprintf (unew, "%s%s", newpath, filename);

  if (rename (uold, unew))
    explain_error (0, "Impossibile rinominare %s", uold);

  free (uold);
  free (unew);
}

static void
sistema_scorri_pagine (char *url, const char *basedir)
{
  char *p = url2path (url);
  char *contents = read_file (p);
  char *f = xmalloc (sizeof (SCORRI_PAGINE_FILE) + strlen (basedir));

  strcpy (f, basedir);
  strcat (f, SCORRI_PAGINE_FILE);
  cancella_testo (contents, "// --->", "//");
  write_file (f, contents);

  if (strcmp (p, f))
    remove (p);

  free (contents);
  free (f);
}

static void
modo_testo ()
{
  char BUF[10000];
  char *edizione_target;
  struct curl_slist *slist = dl_edizioni_slist;

  for (; slist; slist = slist->next)
    {
      edizione_in_download = NULL;
      msg ("Inizio prelevamento");
      edizione_target = xstrdup (slist->data + PREFISSO_EDIZIONE_LEN);
      edizione_target[strlen (edizione_target) - 1] = '\0';

      url_edizione_basedir = url_cat (BASE_URL, slist->data);
      filename_edizione_basedir = url2path (url_edizione_basedir);
      edizione_in_download = slist->data;
      msg ("*     %s", edizione_in_download);
      carica_registro ();

      int k = 0;
      for (; sezioni[k]; k++)
	{
	  // Prima pagina diventa Prima+Pagina
	  switch (k)
	    {
	    case PRIMAPAGINA:
	      sprintf (BUF,
		       BASE_URL PREFISSO_SOLOHTML TAG_GIORNALE TAG_SEZIONE
		       "LISTANZPrima__%s.htmlPrima+Pagina", edizione_target);
	      mappe_url_slist = curl_slist_append (mappe_url_slist, BUF);
	      break;
	      // La sezione pubblicit nella versione testo non esiste
	    case PUBBLICITA:
	      continue;
	    default:
	      sprintf (BUF,
		       BASE_URL PREFISSO_SOLOHTML TAG_GIORNALE TAG_SEZIONE
		       "LISTANZ%s__%s.html%s", sezioni[k],
		       edizione_target, sezioni[k]);
	      mappe_url_slist = curl_slist_append (mappe_url_slist, BUF);
	    }
	}

      if (mappe_url_slist)
	{
	  if (config.senza_articoli)
	    {
	      error (1,
		     "Impossibile eseguire. L'opzione per evitare il download di articoli  attiva.");
	      return;
	    }
	  if (!logged)
	    {
	      msg ("-     Richiesta d'accesso per gli articoli");
	      access_request ();
	    }
	  msg ("-     Presa delle liste degli articoli dell'edizione...");
	  download_loop (0, mappe_url_slist, &generic_slist_downloaded);
	  geturl_loop_testo (mappe_url_slist);
	}
      else
	error (0, "Prelevamento degli elenchi degli articoli non effettuato");
      if (art_url_slist)
	{
	  msg ("-     Presa degli articoli...");
	  download_loop (BASE_URL, art_url_slist, &art_url_slist_downloaded);
	}
      else
	msg ("Non individuati articoli da prelevare");
      msg ("-     Fine download edizione");
      chiusura_ciclo ();
      free (url_edizione_basedir);
      free (filename_edizione_basedir);
    }
}

static void
modo_html_con_jpg ()
{
  CURLcode res;
  FILE *file;

  struct curl_slist *slist = dl_edizioni_slist;

  for (; slist; slist = slist->next)
    {

      edizione_in_download = NULL;

      url_edizione_basedir = url_cat (BASE_URL, slist->data);

      char *url_edizione_scorripagine =
	url_cat (url_edizione_basedir, SCORRI_PAGINE_FILE);

      msg ("Inizio prelevamento");

      res = download_file (url_edizione_scorripagine, 1);

      if (res)
      	{
	  error (0, "File necessario per proseguire non disponibile");
	  free (url_edizione_basedir);
	  continue;
	}
      else
	{
	  file = fopen_from_url (url_edizione_scorripagine, "r");
	  parse_scorri_file (file);
	  fclose (file);
	}

      edizione_in_download = ricava_data_da_mappa ();

      filename_edizione_basedir = url2path (url_edizione_basedir);

      sistema_scorri_pagine (url_edizione_scorripagine,
			     filename_edizione_basedir);

      free (url_edizione_scorripagine);

      msg ("*     %s", edizione_in_download);

      /* Carica lista di file gi scaricati */
      carica_registro ();

      /* Download mappe */

      if (mappe_url_slist != NULL)
	{
	  msg ("-     Presa delle mappe dell'edizione...");
	  download_loop (url_edizione_basedir, mappe_url_slist,
			 &generic_slist_downloaded);
	  geturl_loop_html_con_jpg (url_edizione_basedir, mappe_url_slist);
	}
      else
	error (0, "Prelevamento delle mappe dell'edizione non effettuato");

      /* Download articoli */
      if (art_url_slist)
	{
	  if (!config.senza_articoli)
	    {
	      if (!logged)
		{
		  msg ("-     Richiesta d'accesso per gli articoli");
		  access_request ();
		}
	      msg ("-     Presa degli articoli...");
	      download_loop (url_edizione_basedir, art_url_slist,
			     &art_url_slist_downloaded);
	    }
	}
      else
	msg ("Non individuati articoli da prelevare");

      /* Download jpg */

      if (jpg_slist != NULL)
	{
	  if (!config.senza_immagini)
	    {
	      msg ("-     Download immagini delle pagine...");
	      download_loop (url_edizione_basedir, jpg_slist,
			     &generic_slist_downloaded);
	    }
	}
      else
	error (0, "Prelevamento delle immagini delle pagine non effettuato");

      msg ("-     Fine download edizione");

      /* Genera 'scelta_web.html', 'top.html', 'memory.html'  */

      genera_html_file (filename_edizione_basedir);
      genera_html_file2 (filename_edizione_basedir);

      create_dirs ("edicola/html/css/repubblica/");
      create_dirs ("edicola/images/repubblica/");
      create_dirs ("edicola/repubblica/Static_Pages/");
      create_dirs ("edicola/repubblica/Edizione_Giornaliera/");

      file_copy (DATA_PATH "main.css",
		 "edicola/html/css/repubblica/main.css");
      file_copy (DATA_PATH "top.css", "edicola/html/css/repubblica/top.css");
      file_copy (DATA_PATH "logo.gif", "edicola/images/repubblica/logo.gif");
      file_copy (DATA_PATH "header.jsp", "edicola/repubblica/header.jsp");

      file_copy (config.
		 dim_frecce ? DATA_PATH "arrow_bck2.gif" : DATA_PATH
		 "arrow_bck.gif",
		 "edicola/repubblica/Static_Pages/arrow_bck.gif");

      file_copy (config.
		 dim_frecce ? DATA_PATH "arrow_fwd2.gif" : DATA_PATH
		 "arrow_fwd.gif",
		 "edicola/repubblica/Static_Pages/arrow_fwd.gif");

      file_copy (DATA_PATH "spacer.gif",
		 "edicola/repubblica/Static_Pages/spacer.gif");
      file_copy (DATA_PATH "White_Page1.html",
		 "edicola/repubblica/Static_Pages/White_Page1.html");
      file_copy (DATA_PATH "whiteImage2.jpg",
		 "edicola/repubblica/Static_Pages/whiteImage2.jpg");

      file_vuoto ("edicola/repubblica/Edizione_Giornaliera/memory.html");

      chiusura_ciclo ();

      free (url_edizione_basedir);
      free (filename_edizione_basedir);
    }
}

int
main (int argc, char **argv)
{
  curl_global_init (CURL_GLOBAL_ALL);

  curl = curl_easy_init ();
  if (!curl)
    error (1, "Errore di inizializzazione accesso web");

  curl_easy_setopt (curl, CURLOPT_VERBOSE, VERBOSE ? 1 : 0);
  curl_easy_setopt (curl, CURLOPT_USERAGENT, USERAGENT);
  curl_easy_setopt (curl, CURLOPT_WRITEFUNCTION, simple_write_data);
  curl_easy_setopt (curl, CURLOPT_FOLLOWLOCATION, 0);

#ifdef WIN32
  // Impedisce l'esecuzione di questo codice in modalit interfaccia Win32
  if (argc)
    {
#endif
      /* Default */
      config.tipo_accesso = ABBONATO;

#ifdef WIN32
    }
#endif

  gnu_getopt (argc, argv);

  msg ("Caricamento configurazione...");
  load_config ();

  switch (config.formato_edizione)
    {
    case TESTO:
      modo_testo ();
      break;
    case PDF:
      break;
    default:
      modo_html_con_jpg ();
    }

  chiusura ();
  return 0;
}
