#include <stdio.h>
#include <stdlib.h>
#define _GNU_SOURCE
#include <string.h>

static void memfatal() __attribute__ ((noreturn));

static void memfatal()
{
    fprintf(stderr, "virtual memory exhausted");
    exit(128);
}

void *xmalloc(size_t size)
{
    register void *value = malloc(size);
    if (value == 0)
	memfatal();

    return value;
}

void *xrealloc(void *ptr, size_t size)
{
    register void *value = realloc(ptr, size);
    if (value == 0)
	memfatal();

    return value;
}

char *xstrdup(const char *s)
{
    char *x = strdup(s);

    if (!x)
	memfatal();

    return x;
}

#ifndef HAVE_STRNDUP
/* strndup -- allocate a string, copy n characters into it and add \0 */
static unsigned char *strndup(const unsigned char *s, size_t n)
{
    unsigned char *t = xmalloc(n + 1);
    strncpy(t, s, n);
    t[n] = '\0';
    return t;
}
#endif

char *xstrndup(const char *s, size_t n)
{
    char *x = strndup(s, n);

    if (!x)
	memfatal();

    return x;
}
