# this tiny script has been created by caminoix, 2006-02-06
#
# version 0.2 (2006-02-06)
#	kdialogs + wrong dir specification proof-checking
#	nr of dirs to merge checking
#	translations (de, es, fr, it, pl, pt)
#
#
# in case you were interested, a couple of nice links here:
# nemerle - a great programming language for mono (.net in windows) - http://nemerle.org/Main_Page
# kate os - sth like an improved slackware - http://www.kateos.org/
# funny pics - http://p2p.info.pl/eng/funnies.php
#
# hope you'll find this menu useful :)


#!/bin/bash

if [ $# -lt 3 ]
	then
	kdialog --msgbox "Merging a directory with itself seems quite pointless."
else
	# ask the target dir
	target=$(kdialog --getexistingdirectory $(expr match $2 '\(.*/\)'))
	if [ -n $target ]
		then
		target=$(expr match $2 '\(.*/\)')/merged
		fi
	mkdir $target

	# copy the files
	for i in $@
		do
		cp -r ${i}/* $target
		done

	# remove the src dirs if needed
	if [ $1 == "move" ]
		then
		for i in $@
			do
				rm -r ${i}/*
				rmdir $i
			done
		fi
	fi
