#!/bin/bash
#
# startscript for Money Manger Ex
#
# written by oc2pus
# adapted by neongen


# activate for debugging
#set -x

# base settings
myName=mmex
longName=moneymanagerex
myShareDir=/usr/share/$longName
myHomeDir=~/.$myName

# creates a local working directory in user-home
function createLocalDir ()
{
 	if [ ! -d $myHomeDir ]; then
		echo "creating local working directory $myHomeDir ..."
		mkdir -p $myHomeDir

		ln -s /usr/bin/mmex    $myHomeDir
		ln -s $myShareDir/help $myHomeDir
		ln -s $myShareDir/en   $myHomeDir
		# databases should be writable by user
		cp $myShareDir/*.db3   $myHomeDir
		cp $myShareDir/*.mmb   $myHomeDir

	fi

	# new dir in 0.8.0.4
 	if [ ! -d $myHomeDir/en ]; then
		ln -s $myShareDir/en $myHomeDir
	fi
	# new file in 0.8.0.6
	cp $myShareDir/*.wav $myHomeDir
	cp $myShareDir/*.ico $myHomeDir
	cp $myShareDir/*.png $myHomeDir
}

echo ""
echo "starting Money Manager Ex ..."

# creates a local working directory in user-home
createLocalDir

cd $myHomeDir
./mmex > /tmp/$myName.log 2>&1

echo ""
echo "Money Manager Ex finished ..."
