/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dion@rcom.zp.ua                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "frmseemeditor.h"
#include "phoneman.h"

#include <qtable.h>
#include <qlistview.h>
#include <qvalidator.h>
#include <qlineedit.h>
#include <qheader.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qcheckbox.h>

frmSeemEditor::frmSeemEditor(QWidget *parent, PhoneMan * ph, const char *name)
		: frmSeemEditor_base(parent, name)
{
	int i;

	phone=ph;
	
	connect(phone, SIGNAL(seemReadComplete()), this, SLOT(onSeemReadComplete()));
	connect(phone, SIGNAL(seemWriteComplete()), this, SLOT(onSeemWriteComplete()));
	
	QRegExp regExp("[0-9a-fA-F]{1,4}");

	txtBackupX1->setValidator(new QRegExpValidator(regExp, this));
	txtBackupY1->setValidator(new QRegExpValidator(regExp, this));
	txtBackupX2->setValidator(new QRegExpValidator(regExp, this));
	txtBackupY2->setValidator(new QRegExpValidator(regExp, this));
	txtX->setValidator(new QRegExpValidator(regExp, this));
	txtY->setValidator(new QRegExpValidator(regExp, this));

	tblHex->insertColumns(0,16);
	for (i=0; i<16; i++)
	{
		tblHex->setColumnWidth(i,30);
		tblHex->horizontalHeader()->setLabel(i,QString("_%1").arg(i,0,16));
	}

	// 	tblHex->insertRows(0,15);
	// 	new QListViewItem(lstFeatures,"THIS IS TEST ITEM WITH FEATURE");
	// 	lstFeatures->setWidth(400);
	tmpLock=0;
	seemSize=0;
	curSeem=(unsigned char *) malloc(65000);
}

frmSeemEditor::~frmSeemEditor()
{}

void frmSeemEditor::doSeemLoad()
{
	QString fn=QFileDialog::getOpenFileName(0,"Seem files (*.seem)");
	if (fn.isNull()) return;
	QRegExp regExp("[0-9a-fA-F]{1,4}_[0-9a-fA-F]{1,4}");

	int pos=regExp.search(fn,0);
	if (pos<0)
	{
		QMessageBox::critical( this, "Error",QString("File %1 is not seem file").arg(fn));
		return;
	}

	QStringList list = regExp.capturedTexts();
	QStringList::Iterator it = list.begin();
	QString xxx=(*it).section('_',0,0);
	QString yyy=(*it).section('_',1,1);

	txtX->setText(xxx);
	txtY->setText(yyy);

	unsigned char * buf;
	int size;
	FILE * fp;
	fp=fopen(fn.latin1(),"r");
	if (fp==NULL)
	{
		QMessageBox::critical( this, "Error",QString("Unable to load seem").arg(fn));
		return;
	}
	fseek(fp, 0L, SEEK_END);
	size=ftell(fp);
	fseek(fp, 0L, SEEK_SET);
	buf=(unsigned char *) malloc(1*size);
	fread(buf,1,size,fp);
	fclose(fp);
	showSeem(buf, size);
	free(buf);
	seemSize=size;
}

void frmSeemEditor::showSeem(unsigned char *buf, int size)
{
	int tmp=size/16;
	if (size % 16!=0) tmp++;
	tblHex->setNumRows(tmp);
	
	QString ss;
	
	for (int i=0; i<tmp; i++)
	{
		ss=QString("%1_").arg(i).rightJustify(4, '0');
		
		tblHex->verticalHeader()->setLabel(i,ss);
		
	}
	
	QString st;
	QTableItem * itm;
	
	for(int i=0; i<16*tmp; i++)
	{
		if (i<size)
		{
		st=QString("%1").arg(buf[i],0,16).rightJustify(2,'0');
// 		tblHex->setText(i/16, i%16, st);
		 tblHex->setItem( i/16, i%16,
                new MyTableItem( tblHex, QTableItem::OnTyping, st ) );
		
		}
		else
		{
 			itm= new QTableItem( tblHex, QTableItem::OnTyping  , "" );
			itm->setEnabled(FALSE);
			tblHex->setItem( i/16, i%16, itm);
		}
	}
	seemSize=size;
}

void frmSeemEditor::doCellChange(int row, int col)
{
	if ((row<0) || (col<0)) return;
	qDebug("%dx%d",row,col);
	int t=tblHex->text(row,col).toInt(0,16);
	tmpLock=1;
	bit0->setChecked(t & 1); t>>=1;
	bit1->setChecked(t & 1); t>>=1;
	bit2->setChecked(t & 1); t>>=1;
	bit3->setChecked(t & 1); t>>=1;
	bit4->setChecked(t & 1); t>>=1;
	bit5->setChecked(t & 1); t>>=1;
	bit6->setChecked(t & 1); t>>=1;
	bit7->setChecked(t & 1); t>>=1;
	tmpLock=0;
}

void frmSeemEditor::doBitChanged()
{
	if (tmpLock) return;
	int tmp=0;
	if(bit7->isChecked()) tmp=tmp | 1; tmp<<=1;
	if(bit6->isChecked()) tmp=tmp | 1; tmp<<=1;
	if(bit5->isChecked()) tmp=tmp | 1; tmp<<=1;
	if(bit4->isChecked()) tmp=tmp | 1; tmp<<=1;
	if(bit3->isChecked()) tmp=tmp | 1; tmp<<=1;
	if(bit2->isChecked()) tmp=tmp | 1; tmp<<=1;
	if(bit1->isChecked()) tmp=tmp | 1; tmp<<=1;
	if(bit0->isChecked()) tmp=tmp | 1;
	
	QString st=QString("%1").arg(tmp,0,16).rightJustify(2,'0');
	tblHex->setText(tblHex->currentRow(), tblHex->currentColumn(), st);
}

void frmSeemEditor::seem2buf(unsigned char *buf, int size)
{
	for (int i=0; i<size; i++)
		buf[i]=tblHex->text(i/16,i%16).toInt(0,16);
}

void frmSeemEditor::doSeemSave()
{
	if (!seemSize) return;
	QString seem=QString("%1_%2.seem").arg(txtX->text()).arg(txtY->text());
	QString fn=QFileDialog::getSaveFileName(seem,"Seem files (*.seem)");
	if (fn.isNull()) return;
	unsigned char *buf;
	buf=(unsigned char *) malloc(seemSize);
	seem2buf(buf, seemSize);
	FILE * fp=fopen(fn.latin1(),"w");
	if (fp==NULL)
	{
		QMessageBox::critical( this, "Error",QString("Unable to save seem").arg(fn));
		return;
	}
	fwrite(buf, 1, seemSize, fp);
	fclose(fp);
}

void frmSeemEditor::doSeemRead()
{
// 	if (!seemSize) free(curSeem);
	seemSize=0;
	tmpSize=65000;
	tblHex->setNumRows(0);
	phone->readSeem(txtX->text().toInt(0,16), txtY->text().toInt(0,16), curSeem, &tmpSize);
}

void frmSeemEditor::doSeemWrite()
{
	if (!seemSize) return;
	seem2buf(curSeem, seemSize);
	phone->writeSeem(txtX->text().toInt(0,16), txtY->text().toInt(0,16), curSeem, seemSize);
}

void frmSeemEditor::onSeemReadComplete()
{
	qDebug("onSeemReadComplete");
	showSeem(curSeem, tmpSize);
	seemSize=tmpSize;
}
void frmSeemEditor::onSeemWriteComplete()
{
	qDebug("onSeemWriteComplete");
}

void frmSeemEditor::doBackup()
{
	QString dir=QFileDialog::getExistingDirectory(".");
	if (dir.isNull()) return;
	phone->backupSeem(txtBackupX1->text().toInt(0,16), txtBackupY1->text().toInt(0,16),
		txtBackupX2->text().toInt(0,16), txtBackupY2->text().toInt(0,16), (unsigned char *)(dir.latin1()));
}

