/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dion@rcom.zp.ua                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qstring.h>
#include <qevent.h>

#include <usb.h>

#include "phoneman.h"
#include "p2kproc.h"
#include "custmsg.h"
// #include "p2k_drv.h"

PhoneMan::PhoneMan(QObject *parent, const char *name)
		: QObject(parent, name)
{
	qDebug("PhoneMan");
	proc=new P2kProc(this);
	proc->start();
	// 	drv_init();
}

PhoneMan::~PhoneMan()
{
	proc->stopThread();
}


void PhoneMan::setATconfig (unsigned int vendor, unsigned int product)
{
	proc->setATconfig(vendor,product);
}

void PhoneMan::setP2kconfig (unsigned int vendor, unsigned int product)
{
	proc->setP2kconfig(vendor,product);
}

void PhoneMan::setDevice(char * cmd)
{
	proc->setDevice(cmd);
}

// Parsing events from phone thread
void PhoneMan::customEvent(QCustomEvent * e)
{
	// 	qDebug("PhoneMan: Custom Event");
	switch (e->type())
	{
		case MSG_P2KLOG:
		{
			msg_P2kLog * msg = (msg_P2kLog *) e;
			emit postMsg(msg->style() , msg->message());
			return;
		}
		case MSG_STATUS_CHANGED:
		{
			msg_StatusChanged * msg = (msg_StatusChanged *) e;
			emit statusChanged(msg->status());
			return;
		}
		case MSG_MODE_CHANGED:
		{
			msg_ModeChanged * msg = (msg_ModeChanged *) e;
			emit modeChanged(msg->mode());
			return;
		}
		case MSG_PARAM_INFO:
		{
			msg_ParamInfo * msg = (msg_ParamInfo *) e;
			switch (msg->param())
			{
				case PARAM_DRIVENAME: emit nfoDriveName(msg->info()); break;
				case PARAM_PHONEMODEL: emit nfoPhoneModel(msg->info()); break;
				case PARAM_FREESPACE: emit nfoFreeSpace(msg->info().toLong()); break;
				case PARAM_FILECOUNT: emit nfoFileCount(msg->info().toInt()); break;
				case PARAM_PROGRESS: emit nfoProgress(msg->info().toInt()); break;
				case PARAM_SEEMREADY:
				if (msg->info().toInt()==1)
					emit seemReadComplete();
				else
					emit seemWriteComplete();
				case PARAM_COMPLETE: emit nfoComplete(msg->info().toInt()); break;
				default: ;
			}
			break;
		}
		case MSG_FILELIST:
		{
			msg_FileList * msg = (msg_FileList *) e;
			emit nfoFileList(msg->getArr(), msg->getCount());
			break;
		}
		default:
		{
			qDebug("Unknown customEvent ignored");
			;
		}
	}
}

void PhoneMan::openPhone()
{
	proc->phConnect();
}

void PhoneMan::closePhone()
{
	proc->phDisconnect();
}

void PhoneMan::rebootPhone()
{
	proc->phReboot();
}

void PhoneMan::suspendPhone()
{
	proc->phSuspend();
}

void PhoneMan::getInfo(int what)
{
	proc->phGetInfo(what);
}

void PhoneMan::getFileList()
{
	proc->phGetFileList();
}

void PhoneMan::downloadFiles(P2kFile * lst, int cnt, const char * dir)
{
	proc->phDownloadFiles(lst, cnt, dir);
}

void PhoneMan::uploadFiles(P2kFile * lst, int cnt, const char * dir1, const char * dir2)
{
	proc->phUploadFiles(lst, cnt, dir1, dir2);
}

void PhoneMan::deleteFiles(P2kFile * lst, int cnt)
{
	proc->phDeleteFiles(lst, cnt);
}

void PhoneMan::changeAttr(P2kFile * lst, int cnt)
{
	proc->phChangeAttr(lst, cnt);
}

void PhoneMan::readSeem(int x, int y, unsigned char * buf, int *size)
{
	proc->phReadSeem(x,y,buf,size);
}

void PhoneMan::writeSeem(int x, int y, unsigned char * buf, int size)
{
	proc->phWriteSeem(x,y,buf,size);
}

void PhoneMan::backupSeem(int x1, int y1, int x2, int y2, unsigned char * dir)
{
	proc->phBackup(x1,y1,x2,y2,dir);
}

void PhoneMan::switchToP2K(char * st)
{
	proc->drv_switchP2K(st);
}

int PhoneMan::getDevList(devInfo * lst, int cnt)
{
	return proc->phGetDevList(lst, cnt);
}

int PhoneMan::getState()
{
	return proc->getState();
}

//-------
