#!/bin/sh 
VERSION="0.9.5"
NAME="mountiso"
FULLNAME="Mount-ISO"
SUDO="sudo"
SU="kdesu"
DE="kde"

SYSTEM="`kde-config --prefix 2>/dev/null`"
LOCAL="`kde-config --localprefix 2>/dev/null`"
DESKTOP="`kde-config --userpath desktop 2>/dev/null`"
# start data extractor prefix
EXTRACT="$HOME/Desktop/$FULLNAME/extracted/usr"
# end data extractor prefix

MENU_HEAD='X-KDE-Submenu=Manage ISO
X-KDE-Submenu[de]=ISO verwalten
X-KDE-Submenu[es]=Gestión ISO
X-KDE-Submenu[it]=Gestione ISO
X-KDE-Submenu[ru]=ISO образ
X-KDE-Submenu[sr]=ISO Менаџер
X-KDE-Submenu[sr@Latn]=ISO Menadžer
X-KDE-Submenu[tr]=ISOları Yönet'

MENU_MOUNT='[Desktop Action MountISOImage]
Icon=cdimage
Name=Mount Image
Name[de]=Image einbinden
Name[es]=Montar imagen
Name[it]=Monta immagine
Name[ru]=Смонтировать образ
Name[sr]=Монтирај ISO
Name[sr@Latn]=Montiraj ISO
Name[tr]=İmajı Bağla'

MENU_UNMOUNT='[Desktop Action UnmountISOImage]
Icon=cdimage
Name=Unmount Image
Name[de]=Image aushängen
Name[es]=Desmontar imagen
Name[it]=Smonta immagine
Name[ru]=Отмонтировать образ
Name[sr]=Демонтирај ISO
Name[sr@Latn]=Demontiraj ISO
Name[tr]=İmajı Ayır'

MENU_CREATEISO='[Desktop Action CreateISOImage]
Icon=cdimage
Name=Create ISO Image
Name[de]=ISO-Image erstellen
Name[es]=Crear imagen ISO
Name[it]=Crea immagine ISO
Name[ru]=Создать ISO-образ
Name[sr]=Направи ISO одраз
Name[sr@Latn]=Napravi ISO odraz
Name[tr]=ISO İmajı Oluştur'

MENU_GRABISO='[Desktop Action GrabISOImage]
Icon=cdimage
Name=Create ISO Image from CD-ROM
Name[de]=ISO-Image von CD-ROM erstellen
Name[es]=Crear imagen ISO desde un CD
Name[it]=Crea immagine ISO dal CDROM
Name[ru]=Создать ISO-образ компакт-диска
Name[sr]=Направи ISO одраз са ЦД-а
Name[sr@Latn]=Napravi ISO odraz sa CD-a
Name[tr]=CD-ROMdan ISO İmajı Oluştur'

MENU_CALC='[Desktop Action CalcMD5Sum]
Icon=cdimage
Name=Calculate MD5 Sum
Name[de]=MD5-Prüfsumme berechnen
Name[es]=Calcular suma MD5
Name[it]=Calcola somma MD5
Name[ru]=Вычислить MD5 сумму
Name[sr]=Израчунај МД5 суму
Name[sr@Latn]=Izračunaj MD5 sumu
Name[tr]=MD5 Özetini Hesapla'

MENU_CONV2ISO='[Desktop Action ConvertCONV2ISO]
Icon=cdimage
Name=Convert to ISO
Name[de]=In ISO umwandeln
Name[es]=Convertir a ISO
Name[it]=Converti in ISO
Name[ru]=Конвертировать в образ ISO
Name[sr]=Конвертуј у ISO
Name[sr@Latn]=Konvertuj u ISO
Name[tr]=ISOya Dönüştür'

MENU_CHECK='[Desktop Action CheckISOType]
Icon=cdimage
Name=Check ISO Type
Name[de]=ISO-Type prüfen
Name[es]=Comprobar tipo de ISO
Name[it]=Controlli il Tipo di ISO
Name[ru]=Проверить тип ISO-образа
Name[sr]=Провери тип ISO одраза
Name[sr@Latn]=Proveri tip ISO odraza
Name[tr]=ISO Türünü Denetle'

DESKTOP_IMG='[Desktop Entry]
Type=MimeType
Patterns=*.img;*.IMG
MimeType=application/x-img
Icon=cdimage
Comment=IMG image file
Comment[az]=IMG əks faylı
Comment[be]=Файл вобразу IMG
Comment[bg]=Файл снимка IMG
Comment[bs]=IMG image datoteka
Comment[ca]=Fitxer d imatge IMG
Comment[cs]=Soubor s IMG obrazem
Comment[cy]=Ffeil delwedd IMG
Comment[da]=IMG billedfil
Comment[de]=IMG-Bilddatei
Comment[el]=Αρχείο εικόνας IMG
Comment[es]=Archivo de imagen IMG
Comment[et]=IMG tõmmisefail
Comment[eu]=IMG irudia fitxategia
Comment[fa]=پرونده‌ی IMG
Comment[fi]=IMG binäärikuva
Comment[fr]=Image IMG
Comment[ga]=Comhad íomhá IMG
Comment[gl]=Ficheiro de imaxe IMG
Comment[he]=קובץ מראה של IMG
Comment[hi]=IMG चित्र फाइल
Comment[hu]=IMG-képmásfájl
Comment[is]=IMG diskmynd
Comment[it]=File immagine IMG
Comment[ja]=IMG イメージ ファイル
Comment[lt]=IMG atvaizdo byla
Comment[mn]=IMG хэв файл
Comment[nb]=IMG bildefil
Comment[nds]=IMG-Bilddatei
Comment[nl]=IMG-beeldbestand
Comment[nn]=IMG-biletfil
Comment[pl]=Plik obrazu systemu plików IMG
Comment[pt]=Ficheiro com imagem IMG
Comment[pt_BR]=Imagem IMG
Comment[ro]=Fişier imagine IMG
Comment[ru]=Файл образа IMG
Comment[se]=IMG-govvafiila
Comment[sk]=Obraz disku IMG
Comment[sl]=Podoba plošče IMG
Comment[sr]=Фајл IMG одраза
Comment[sr@Latn]=Fajl IMG odraza
Comment[sv]=IMG-avbildsfil
Comment[ta]=IMG உருக் கோப்பு
Comment[tg]=Файли тасвири IMG
Comment[tr]=IMG Dosyası
Comment[uk]=Файл образу IMG
Comment[uz]=IMG-тасвир файли
Comment[wa]=Fitchî imådje IMG
Comment[xx]=xxIMG image filexx
Comment[zh_CN]=IMG 映像文件
Comment[zh_TW]=IMG 映像檔案'

# -------------------------------------------------------------------------
function check_env {
# parameters:
# - $1 = Description
# - $2 = Default location
# - $3 = Fallback
# -------------------------------------------------------------------------

  if ( test -d "$2" ) then
    DIR="$2"
  elif ( test -d "$3" ) then
    DIR="$3"
  else
    echo
    while ( test ! -d "$DIR" )
    do
      echo "Couldn't find $1!"
      echo -n "Type the full path here or press \"Ctrl+C\" to abort: "
      read DIR
    done
  fi
  DIR="$DIR"
  echo -e "* $1: \E[33m$DIR\E[m"
  
}

# -------------------------------------------------------------------------
function check_bin {
# parameters:
# - $1 = Binary name
# - $2 = Default location
# -------------------------------------------------------------------------
  
  BIN=""
  WHICH="`type -path -all "$1" | head -1`"
  if ( test -f "$2" ) then
    BIN="$2"
    echo -e " [$1]: \E[32m$BIN\E[m"
  elif ( test -f "$WHICH" ) then
    BIN="$WHICH"
    echo -e " [$1]: \E[32m$BIN\E[m"
  else
    echo -e " [$1]: \E[31m>> not found <<\E[m "
    echo "   ! \"$1\" features will not be included"
  fi

}

# -------------------------------------------------------------------------
function check_dev {
# parameters:
# - $1 = Device name
# - $2 = Default location
# - $3 = Fallback
# -------------------------------------------------------------------------
  
  DEV=""
  if ( test -b "$2" ) then
    DEV="$2"
    echo -e "   + $1: \E[32m$DEV\E[m"
  elif ( test -b "$3" ) then
    DEV="$3"
    echo -e "   + $1: \E[32m$DEV\E[m"
  else
    echo -e "   - $1: \E[31m>> not found <<\E[m"
  fi

}

# -------------------------------------------------------------------------
function find_bin {
# parameters:
# - $1 = Binary name
# - $2 = Default location
# -------------------------------------------------------------------------

  echo
  BIN=""
  if ( test ! -z "$2" ) then
    echo "Type the full path to \"$1\""
    echo -n "or press \"Enter\" to continue [$2]: "
    read BIN
    test -z "$BIN" && BIN="$2"
  fi
  while ( test ! -f "$BIN" )
  do
    echo "Couldn't find \"$1\"!"
    echo -n "Type the full path here or \"C\" to cancel: "
    read BIN
    if ( test "$BIN" = "c" ) || ( test "$BIN" = "C" )  then
      BIN=""
      return 1
    fi
  done
  
}

# -------------------------------------------------------------------------
function find_dev {
# parameters:
# - $1 = Device name
# - $2 = Default location
# -------------------------------------------------------------------------

  echo
  DEV=""
  if ( test ! -z "$2" ) then
    echo "Type the full path to \"$1\""
    echo -n "or press \"Enter\" to continue [$2]: "
    read DEV
    test -z "$DEV" && DEV="$2"
  fi
  while ( test ! -b "$DEV" )
  do
    echo "Couldn't find \"$1\"!"
    echo -n "Type the full path here or \"C\" to cancel: "
    read DEV
    if ( test "$DEV" = "c" ) || ( test "$DEV" = "C" )  then
      DEV=""
      return 1
    fi
  done
  
}

# -------------------------------------------------------------------------
function set_env {
# parameters:
# none
# -------------------------------------------------------------------------

  if ( test "$UID" -ne "0" ) then
    check_env "KDE config folder" "$LOCAL" "$HOME/.kde"
  else
    check_env "KDE install prefix" "$SYSTEM" "/usr"
echo "   ! Be careful when installing globaly"
  fi
  PREFIX="$DIR"

  check_env "Desktop folder" "$DESKTOP" "$HOME/Desktop"
  DESKTOP='$HOME/'"${DIR#$HOME/}"

}

# -------------------------------------------------------------------------
function set_bin {
# parameters:
# none
# -------------------------------------------------------------------------

  echo -n "* Convert CUE/BIN to ISO"
  check_bin "bchunk" "$BCHUNK"
  BCHUNK="$BIN"
  echo -n "* Convert CloneCD to ISO"
  check_bin "ccd2iso" "$CCD2ISO"
  CCD2ISO="$BIN"
  echo -n "* Convert MDF to ISO"
  check_bin "mdf2iso" "$MDF2ISO"
  MDF2ISO="$BIN"
  echo -n "* Mount CUE/BIN"
  check_bin "cdemu" "$CDEMU"
  CDEMU="$BIN"
  echo -n "* Manage XBOX images"
  check_bin "extract-xiso" "$XISO"
  XISO="$BIN"
  
}

# -------------------------------------------------------------------------
function set_dev {
# parameters:
# none
# -------------------------------------------------------------------------

  echo "* CD drives"
  check_dev "CD-ROM" "$CDROM0" "/dev/cdrom"
  CDROM0="$DEV"
  echo "* CDEMU nodes"
  check_dev "Node0" "$CDEMU0" "/dev/cdemu/0"
  CDEMU0="$DEV"


}

# -------------------------------------------------------------------------
function hi {
# parameters:
# - $1 = selected install mode (kdesu or sudo)
# -------------------------------------------------------------------------
  
  clear
  echo
  echo "     - $FULLNAME v$VERSION (using \"$1\") -"
  echo

}

# -------------------------------------------------------------------------
function bye {
# parameters:
# none
# -------------------------------------------------------------------------
  
  echo
  echo "     - Thank you for using $FULLNAME! -"
  echo

}

# -------------------------------------------------------------------------
function byebye {
# parameters:
# none
# -------------------------------------------------------------------------
  
  clear
  echo
  echo "         - Uninstalling $FULLNAME -"
  echo

}

# -------------------------------------------------------------------------
function install_kde {
# parameters:
# - $1 = selected install mode (sudo or kdesu)
# -------------------------------------------------------------------------
  
  hi $1
  install_menu
  install_mime
  install_script $1 kde
  bye

}

# -------------------------------------------------------------------------
#function install-?? {
# parameters:
# - $1 = selected install mode (?? or ??)
# -------------------------------------------------------------------------
#
#  hi $1
#  install_script $1 ??
#  bye
#
#}

# -------------------------------------------------------------------------
function uninstall {
# parameters:
# none
# -------------------------------------------------------------------------
  
  SH="$PREFIX/bin/$NAME.sh"
  CCD="$PREFIX/share/mimelnk/application/x-ccd.desktop"
  CUE="$PREFIX/share/mimelnk/application/x-cue.desktop"
  NRG="$PREFIX/share/mimelnk/application/x-nrg.desktop"
  MDF="$PREFIX/share/mimelnk/application/x-mdf.desktop"
  DSK1="$PREFIX/share/apps/konqueror/servicemenus/$NAME.desktop"
  DSK2="$PREFIX/share/apps/konqueror/servicemenus/$NAME-dir.desktop"
  DSK3="$PREFIX/share/apps/konqueror/servicemenus/$NAME-cue.desktop"
  DSK4="$PREFIX/share/apps/konqueror/servicemenus/$NAME-ccd.desktop"
  DSK5="$PREFIX/share/apps/konqueror/servicemenus/$NAME-grb.desktop"
  DSK6="$PREFIX/share/apps/konqueror/servicemenus/$NAME-nrg.desktop"
  DSK7="$PREFIX/share/apps/konqueror/servicemenus/$NAME-mdf.desktop"
  DSK8="$PREFIX/share/apps/konqueror/servicemenus/$NAME-emu.desktop"
  DSK9="$PREFIX/share/apps/konqueror/servicemenus/$NAME-xbx.desktop"

  echo -n "Removing $NAME.sh:               "
  if ( test -f "$SH" )
  then
    rm "$SH" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  echo -n "Removing $NAME.desktop:          "
  if ( test -f "$DSK1" )
  then
    rm "$DSK1" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  echo -n "Removing $NAME-dir.desktop:      "
  if ( test -f "$DSK2" )
  then
    rm "$DSK2" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  echo -n "Removing $NAME-cue.desktop:      "
  if ( test -f "$DSK3" )
  then
    rm "$DSK3" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  echo -n "Removing $NAME-ccd.desktop:      "
  if ( test -f "$DSK4" )
  then
    rm "$DSK4" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  echo -n "Removing $NAME-grb.desktop:      "
  if ( test -f "$DSK5" )
  then
    rm "$DSK5" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  echo -n "Removing $NAME-nrg.desktop:      "
  if ( test -f "$DSK6" )
  then
    rm "$DSK6" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  echo -n "Removing $NAME-mdf.desktop:      "
  if ( test -f "$DSK7" )
  then
    rm "$DSK7" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  echo -n "Removing $NAME-emu.desktop:      "
  if ( test -f "$DSK8" )
  then
    rm "$DSK8" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  echo -n "Removing $NAME-xbx.desktop:      "
  if ( test -f "$DSK9" )
  then
    rm "$DSK9" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  echo -n "Removing x-nrg.desktop:             "
  if ( test -f "$NRG" )
  then
    rm "$NRG" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  echo -n "Removing x-mdf.desktop:             "
  if ( test -f "$MDF" )
  then
    rm "$MDF" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  echo -n "Removing x-ccd.desktop:             "
  if ( test -f "$CCD" )
  then
    rm "$CCD" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  echo -n "Removing x-cue.desktop:             "
  if ( test -f "$CUE" )
  then
    rm "$CUE" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mNONE\E[m ]"
  fi
  
}

# -------------------------------------------------------------------------
function install_menu {
# parameters:
# none
# -------------------------------------------------------------------------
  
# start data extractor check
if (test $PREFIX = $EXTRACT) then
EXECPREFIX=''
else
EXECPREFIX=$PREFIX'/bin/'
fi
# end data extractor check
  
  echo -n "Creating a folder for servicemenus: "
  if ( test ! -d "$PREFIX/share/apps/konqueror/servicemenus/" )
  then
    mkdir -p "$PREFIX/share/apps/konqueror/servicemenus/" 2>/dev/null
    test -d "$PREFIX/share/apps/konqueror/servicemenus" &&
    echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]" ; exit 1; }
  else
    echo -e "[ \E[33mSKIP\E[m ]"
  fi

  echo -n "Installing $NAME.desktop:        "

  echo -n '[Desktop Entry]
Actions=MountISOImage;UnmountISOImage;CalcMD5Sum;CheckISOType;
Encoding=UTF-8
ServiceTypes=application/x-iso,inode/ISO-image
X-KDE-Priority=TopLevel
'"$MENU_HEAD"'

'"$MENU_MOUNT"'
Exec='$EXECPREFIX''$NAME'.sh "%U" mount

'"$MENU_UNMOUNT"'
Exec='$EXECPREFIX''$NAME'.sh "%U" unmount

'"$MENU_CALC"'
Exec='$EXECPREFIX''$NAME'.sh "%U" calc

'"$MENU_CHECK"'
Exec='$EXECPREFIX''$NAME'.sh "%U" checkiso
' > "$PREFIX/share/apps/konqueror/servicemenus/$NAME.desktop" &&
  echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }

  echo -n "Installing $NAME-dir.desktop:    "

  echo '[Desktop Entry]
Actions=CreateISOImage;CreateUDFImage;
Encoding=UTF-8
ServiceTypes=inode/directory
'"$MENU_HEAD"'

'"$MENU_CREATEISO"'
Exec='$EXECPREFIX''$NAME'.sh "%U" createiso

'"$(echo "$MENU_CREATEISO" | sed "s/ISO/UDF/")"'
Exec='$EXECPREFIX''$NAME'.sh "%U" createudf
' > "$PREFIX/share/apps/konqueror/servicemenus/$NAME-dir.desktop" &&
  echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }

  echo -n "Installing $NAME-cue.desktop:    "
  if ( test ! -z "$BCHUNK" ) then
    echo '[Desktop Entry]
Actions=ConvertCUE/BIN2ISO;
Encoding=UTF-8
ServiceTypes=application/x-cue
X-KDE-Priority=TopLevel
'"$(echo "$MENU_HEAD" | sed "s/ISO/CUE\/BIN/")"'

'"$(echo "$MENU_CONV2ISO" | sed "s/CONV/CUE\/BIN/")"'
Exec='$EXECPREFIX''$NAME'.sh "%U" bin2iso
' > "$PREFIX/share/apps/konqueror/servicemenus/$NAME-cue.desktop" &&
    echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mSKIP\E[m ]"
  fi
  
  echo -n "Installing $NAME-ccd.desktop:    "
  if ( test ! -z "$CCD2ISO" ) then
    echo '[Desktop Entry]
Actions=ConvertCloneCD2ISO;
Encoding=UTF-8
ServiceTypes=application/x-ccd
X-KDE-Priority=TopLevel
'"$MENU_HEAD"'

'"$(echo "$MENU_CONV2ISO" | sed "s/CONV/CloneCD/")"'
Exec='$EXECPREFIX''$NAME'.sh "%U" ccd2iso
' > "$PREFIX/share/apps/konqueror/servicemenus/$NAME-ccd.desktop" &&
    echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mSKIP\E[m ]"
  fi

  echo -n "Installing $NAME-grb.desktop:    "
  if ( test ! -z "$CDROM0" ) then
    echo '[Desktop Entry]
Actions=GrabISOImage;
Encoding=UTF-8
ServiceTypes=inode/directory
'"$MENU_HEAD"'

'"$MENU_GRABISO"'
Exec='$EXECPREFIX''$NAME'.sh "%U" grabiso
' > "$PREFIX/share/apps/konqueror/servicemenus/$NAME-grb.desktop" &&
    echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mSKIP\E[m ]"
  fi
  
  echo -n "Installing $NAME-nrg.desktop:    "

  echo '[Desktop Entry]
Actions=MountNRGImage;UnmountNRGImage;CalcMD5Sum;ConvertNRG2ISO;
Encoding=UTF-8
ServiceTypes=application/x-nrg
X-KDE-Priority=TopLevel
'"$(echo "$MENU_HEAD" | sed "s/ISO/NRG/")"'

'"$(echo "$MENU_MOUNT" | sed "s/ISO/NRG/")"'
Exec='$EXECPREFIX''$NAME'.sh "%U" mount

'"$(echo "$MENU_UNMOUNT" | sed "s/ISO/NRG/")"'
Exec='$EXECPREFIX''$NAME'.sh "%U" unmount

'"$MENU_CALC"'
Exec='$EXECPREFIX''$NAME'.sh "%U" calc

'"$(echo "$MENU_CONV2ISO" | sed "s/CONV/NRG/")"'
Exec='$EXECPREFIX''$NAME'.sh "%U" nrg2iso
' > "$PREFIX/share/apps/konqueror/servicemenus/$NAME-nrg.desktop" &&
  echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }

  echo -n "Installing $NAME-mdf.desktop:    "

  echo '[Desktop Entry]
Actions=MountMDFImage;UnmountMDFImage;CalcMD5Sum;ConvertMDF2ISO;
Encoding=UTF-8
ServiceTypes=application/x-mdf
X-KDE-Priority=TopLevel
'"$(echo "$MENU_HEAD" | sed "s/ISO/MDF/")"'

'"$(echo "$MENU_MOUNT" | sed "s/ISO/MDF/")"'
Exec='$EXECPREFIX''$NAME'.sh "%U" mount

'"$(echo "$MENU_UNMOUNT" | sed "s/ISO/MDF/")"'
Exec='$EXECPREFIX''$NAME'.sh "%U" unmount

'"$MENU_CALC"'
Exec='$EXECPREFIX''$NAME'.sh "%U" calc

'"$(echo "$MENU_CONV2ISO" | sed "s/CONV/MDF/")"'
Exec='$EXECPREFIX''$NAME'.sh "%U" mdf2iso
' > "$PREFIX/share/apps/konqueror/servicemenus/$NAME-mdf.desktop" &&
  echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }

  echo -n "Installing $NAME-emu.desktop:    "
  if ( test ! -z "$CDEMU" ) then
    echo '[Desktop Entry]
Actions=MountCUE/BINImage;UnmountCUE/BINImage;
Encoding=UTF-8
ServiceTypes=application/x-cue
X-KDE-Priority=TopLevel
'"$(echo "$MENU_HEAD" | sed "s/ISO/CUE\/BIN/")"'

'"$(echo "$MENU_MOUNT" | sed "s/ISO/CUE\/BIN/")"'
Exec='$EXECPREFIX''$NAME'.sh "%U" mountcb

'"$(echo "$MENU_UNMOUNT" | sed "s/ISO/CUE\/BIN/")"'
Exec='$EXECPREFIX''$NAME'.sh "%U" unmount
' > "$PREFIX/share/apps/konqueror/servicemenus/$NAME-emu.desktop" &&
    echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mSKIP\E[m ]"
  fi 

  echo -n "Installing $NAME-xbx.desktop:    "
  if ( test ! -z "$XISO" ) then
    echo '[Desktop Entry]
Actions=CreateXDVDFSImage;
Encoding=UTF-8
ServiceTypes=inode/directory
'"$MENU_HEAD"'

'"$(echo "$MENU_CREATEISO" | sed "s/ISO/XDVDFS/")"'
Exec='$EXECPREFIX''$NAME'.sh "%U" createxbx
' > "$PREFIX/share/apps/konqueror/servicemenus/$NAME-xbx.desktop" &&
    echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mSKIP\E[m ]"
  fi 
  
}

# -------------------------------------------------------------------------
function install_script {
# parameters:
# - $1 = selected install mode (kdesu, sudo or ?)
# - $2 = Desktop environment (kde or ?)
# -------------------------------------------------------------------------
  
  
  case $1 in
    sudo)
      MOUNT='sudo mount -t udf,iso9660 -o loop,ro,nodev,noexec,nosuid${MODE} "${1}" "$MOUNTDIR"'
      UNMOUNT='sudo umount "$MOUNTDIR"'
      ;;
    kdesu)
      MOUNT='kdesu -c "mount -t udf,iso9660 -o loop,ro,nodev,noexec,nosuid${MODE} \"${1}\"  \"$MOUNTDIR\""'
      UNMOUNT='kdesu -c "umount \"$MOUNTDIR\""'
      ;;
    *)
      echo 'Not implemented yet!'
      exit 1
      ;;
  esac
  
  case $2 in
    kde)
      DIALOG='kdialog'
      ;;
    *)
      echo 'Not implemented yet!'
      exit 1
      ;;
  esac
  
  echo -n "Installing $NAME.sh:             "
  if ( test -f "$PREFIX/bin/$NAME.sh" )
  then
    rm -f "$PREFIX/bin/$NAME.sh"
  fi
  
if ( test ! -d "$PREFIX/bin" )
  then
    mkdir -p "$PREFIX/bin" 2>/dev/null
  fi
  
  test -d "$PREFIX/bin" &&
  echo '#!/bin/sh
# '$FULLNAME' v'$VERSION'
BSNAME="`basename "$1"`"

if ( `echo "$BSNAME" | grep "Mount-ISO" > /dev/null` ) then
  MOUNTDIR="$1"
else
  MOUNTDIR="'$DESKTOP'Mount-ISO ($BSNAME)"
fi

function dialog {
  '$DIALOG' --title "'$FULLNAME'" --msgbox "$1"
}

function dialog1 {
  '$DIALOG' --title "'$FULLNAME'" --dontagain $BSNAME:nofilemsg --msgbox "$1"
}

function dialog2 {
  '$DIALOG' --title "'$FULLNAME'" --getsavefilename "$HOME" "*.iso |ISO Files"
}

function err {
  case "$1" in
   1)
     ERROR_MESSAGE="\"$2\" is not readable, check file permissions!"
     ;;
   2)
     ERROR_MESSAGE="\"$2\" is already mounted!"
     ;;
   3)
     ERROR_MESSAGE="\"$2\" could not be created!"
     ;;
   4)
     ERROR_MESSAGE="\"$2\" is not mounted!"
     ;;
   5)
     ERROR_MESSAGE="Folder \"$2\" exists but \"$3\" is not mounted!"
     ;;
   6)
     ERROR_MESSAGE="Could not mount \"$2\"! Check your system settings."
     ;;
   7)
     ERROR_MESSAGE="\"$2\" has data error! File might be of wrong type or corrupted."
     ;;
   8)
     ERROR_MESSAGE="\"$2\" is not a directory!"
     ;;
   9)
     ERROR_MESSAGE="Error creating ISO image from directory \"$2\"!"
     ;;
   10)
     ERROR_MESSAGE="\"$2\" is a directory - MD5 sum can not be calculated!"
     ;;
   11)
     ERROR_MESSAGE="\"$2\" file does not exist!"
     ;;
   12)
     ERROR_MESSAGE="ISO creation failed! Check if you have CD in your CDROM and if you have required permissions."
     ;;
   13)
     ERROR_MESSAGE="Unmounting \"$2\" failed! Check if some programs are using it, close them and try again."
     ;;
   14)
     ERROR_MESSAGE="Directory \"$2\" is not writable! Check your permissions."
     ;;
   *)
     return 0
     ;;
  esac
  dialog "ERROR: $ERROR_MESSAGE"
  exit 0
}

function msg {
  case "$1" in
    1)
      INFO_MESSAGE="ISO image \"$2\" successfully created in \"$3\"!"
      ;;
    2)
      INFO_MESSAGE="MD5 checksum of \"$2\" is: \"$3\""
      ;;
    3)
      INFO_MESSAGE="Tracks were saved as \"$2XX.iso\" in \"$3\""
      ;;
    4)
      INFO_MESSAGE="UDF image \"$2\" successfully created in \"$3\"!"
      ;;
    5)
      INFO_MESSAGE="CloneCD image was converted into \"$2\" and saved in \"$3\""
      ;;
    6)
      INFO_MESSAGE="Image file \"$2\" is of type \"$3\""
      ;;
    7)
      INFO_MESSAGE="Nero image was converted into \"$2\" and saved in \"$3\""
      ;;
    8)
      INFO_MESSAGE="XBOX image was converted into \"$2\" and saved in \"$3\""
      ;;
    9)
      INFO_MESSAGE="Alcohol image was converted into \"$2\" and saved in \"$3\""
      ;;
    *)
      return 0
      ;;
  esac
  dialog "$INFO_MESSAGE"
  exit 0
}

function note {
  case "$1" in
    1)
      NOTICE="Image mounted successfuly!"
      ;;
    2)
      NOTICE="Image unmounted successfuly!"
      ;;
    3)
      NOTICE="Image creation canceled!"
      ;;
    *)
      return 0
      ;;
  esac
  dialog1 "$NOTICE"
  exit 0
}

function check_mount {
  DEV="`mount | grep "$1" | cut -f 1 -d " "`"
  if ( test ! -z "$DEV" ) then
    return 0
  else
    return 1
  fi
}

function check_cdemu {
  if ( `'$CDEMU' -s | grep "$1" > /dev/null` ) then
    return 0
  else
    return 1
  fi
}

function check_iso {
  TYPE=`head "$1" | od -Ax -S 8 | head -n 1 | cut -f 1 -d " " `
    case "$TYPE" in
      008008)
        # ISO image
        CHECK="Standard ISO9660 image"
        ;;
      008028)
        # ISO image (by WinISO)
        CHECK="Standard ISO9660 image (by WinISO)"
        ;;
      053008)
        # NRG image
        CHECK="NRG image (by Nero)"
        ;;
      007a69)
        # XDVDFS image
        CHECK="XBOX DVD image"
        ;;  
      *)
        # Anything else
        CHECK="Unknown format"
        ;;
    esac
}

case "$2" in
  mount)
    if (test -d "$MOUNTDIR") then
      check_mount "$MOUNTDIR" &&
      err 2 "$1"
    else
      test -r "$1" ||
      err 1 "$1"
      mkdir -p "$MOUNTDIR"
    fi
    if ( test -d "$MOUNTDIR" )
    then
      TYPE=`head "$1" | od -Ax -S 8 | head -n 1 | cut -f 1 -d " " `
      case "$TYPE" in
        008008)
          # ISO image
          MODE=",defaults"
          ;;
        008028)
          # ISO image (by WinISO)
          MODE=",defaults"
          ;;
        053008)
          # NRG image
          MODE=",offset=307200"
          ;;
        007a69)
          # XDVDFS image
          rmdir "$MOUNTDIR"
          err 7 "$1"
          ;;  
        *)
          # Anything else
          rmdir "$MOUNTDIR"
          err 7 "$1"
          ;;
      esac
      '$MOUNT'
    fi
    if ( check_mount "$MOUNTDIR" ) then
      kfmclient openURL "$MOUNTDIR" && note 1
    else
      rmdir "$MOUNTDIR"
      err 6 "$MOUNTDIR"
    fi
    ;;
  unmount)
    if (test ! -d "$MOUNTDIR") then
      err 4 "$1"
    elif (check_mount "$MOUNTDIR") then
      '$UNMOUNT' &&
      rmdir "$MOUNTDIR" && note 2 ||
      err 13 "$1"
      if ( test "${DEV##/dev/cdemu/}" -ge 0 2>/dev/null ) then
        '$CDEMU' -u ${DEV##/dev/cdemu/}
      fi
    else
      err 5 "$MOUNTDIR" "$1"
    fi
    ;;
  createiso)
    SAVEFILE=`dialog2`
    ISOFILE=`basename "$SAVEFILE"`
    SAVEDIR=`dirname "$SAVEFILE"`
    
    if ( test "$SAVEFILE" = "" ) then
      note 3
    elif ( test ! -w "$SAVEDIR" ) then
      err 14 "$SAVEDIR"
    elif ( test ! -d "$1" ) then
      err 8 "$1"
    fi
    
    mkisofs -joliet -rock -quiet -no-bak -o "$SAVEFILE" "$1" &&
    msg 1 "$ISOFILE" "$SAVEDIR" ||
    rm -f "$SAVEFILE" && err 9 "$1"
    ;;
  createudf)
    SAVEFILE=`dialog2`
    ISOFILE=`basename "$SAVEFILE"`
    SAVEDIR=`dirname "$SAVEFILE"`
    
    if ( test "$SAVEFILE" = "" ) then
      note 3
    elif ( test ! -w "$SAVEDIR" ) then
      err 14 "$SAVEDIR"
    elif ( test ! -d "$1" ) then
      err 8 "$1"
    fi
    
    mkisofs -dvd -quiet -no-bak -o "$SAVEFILE" "$1" &&
    msg 4 "$ISOFILE" "$SAVEDIR" ||
    rm -f "$SAVEFILE" && err 9 "$1"
    ;;
  calc)
    if ( test -d "$1" ) then
      err 10 "$1"
    elif ( test -f "$1" ) then
      SUM=`md5sum "$1" | cut -f 1 -d " "`
      msg 2 "$BSNAME" "$SUM"
    fi
    ;;
  bin2iso)
    SAVEDIR="`dirname "$1"`"
    BASE="${BSNAME%.*}"
    BINFILE="$SAVEDIR/"`head -n 1 "$1" | cut -f 2 -d " " | sed -e "s/^\"//" -e "s/\"$//"`
    
    if ( test ! -w "$SAVEDIR" ) then
      SAVEDIR="'$DESKTOP'"
    fi
    
    if ( test ! -f "$BINFILE" ) then
      err 11 "`basename "$BINFILE"`"
    else
      '$BCHUNK' "$BINFILE" "$1" "$BASE" > /dev/null
      ls -1b "${BASE}"*.iso | while read file; do mv "$file" $SAVEDIR; done
      msg 3 "$BASE" "$SAVEDIR"
    fi
    ;;
  ccd2iso)
    SAVEDIR="`dirname "$1"`"
    BASE="${BSNAME%.*}"
    IMGFILE="$SAVEDIR/$BASE.img"
    
    if ( test ! -w "$SAVEDIR" ) then
      SAVEDIR="'$DESKTOP'"
    fi
    
    if ( test ! -f "$IMGFILE" ) then
      err 11 "$BASE.img"
    else
      '$CCD2ISO' "$IMGFILE" "$SAVEDIR/$BASE.iso" > /dev/null
      msg 5 "$BASE.iso" "$SAVEDIR"
    fi
    ;;

  mdf2iso)
    SAVEDIR="`dirname "$1"`"
    BASE="${BSNAME%.*}"
    IMGFILE="$SAVEDIR/$BASE.img"
    
    if ( test ! -w "$SAVEDIR" ) then
      SAVEDIR="'$DESKTOP'"
    fi
    
    if ( test ! -f "$IMGFILE" ) then
      err 11 "$BASE.img"
    else
      '$MDF2ISO' "$IMGFILE" "$SAVEDIR/$BASE.iso" > /dev/null
      msg 9 "$BASE.iso" "$SAVEDIR"
    fi
    ;;
  grabiso)
    if ( test ! -w "$1" ) then
      IMGFILE="`kdialog --inputbox "This directory is read-only, saving to Desktop! Choose name for ISO-image:" "'$DESKTOP'mount.iso"`" || exit 0
    else
      IMGFILE="`kdialog --inputbox "Choose name for ISO-image:" "$1/mount.iso"`" || exit 0
    fi
    SAVEDIR="`dirname "$IMGFILE"`"
                 
    while ( ( test ! -w "$SAVEDIR" ) || ( test -f "$IMGFILE" ) )
    do
      if ( test -f "$IMGFILE" ) then
        IMGFILE="`kdialog --inputbox "File with this name already exists! Choose another name:" "$IMGFILE"`" ||
        exit 0
      elif ( test ! -w "$SAVEDIR" ) then
        IMGFILE="`kdialog --inputbox "Permission to write here is denied! Choose another name:" "$IMGFILE"`" ||
        exit 0
      fi
      SAVEDIR="`dirname "$IMGFILE"`"
        
    done
    
    if ( test "$SAVEDIR" != "$IMGFILE" ) then
      dd if="'$CDROM0'" of="$IMGFILE" &&
      msg 1 "`basename "$IMGFILE"`" "$SAVEDIR" ||
      err 
    fi
    ;;
  nrg2iso)
    SAVEDIR="`dirname "$1"`"
    BASE="${BSNAME%.*}"
    IMGFILE="$SAVEDIR/$BASE.iso"
    
    if ( test ! -w "$SAVEDIR" ) then
      SAVEDIR="'$DESKTOP'"
    fi
    
    TYPE=`head "$1" | od -Ax -S 8 | head -n 1 | cut -f 1 -d " " `
    case "$TYPE" in
      053008)
        dd if="$1" of="$IMGFILE" bs=512 skip=600 > /dev/null &&
        msg 7 "$BASE.iso" "$SAVEDIR" || 
        err 3 "$IMGFILE"
        ;;
      *)
        err 7 "$1"
        ;;
    esac
    ;;
  mountcb)
    BASE="${BSNAME%.*}"
    BINFILE="$SAVEDIR/"`head -n 1 "$1" | cut -f 2 -d " " | sed -e "s/^\"//" -e "s/\"$//"`
    NODE=$((`'$CDEMU' -s | cut -f 8 -d " " | grep 0 -n -m 1 | cut -c 1`-2))
        
    if (test -d "$MOUNTDIR") then
      check_mount "$MOUNTDIR" &&
      err 2 "$1"
    else
      mkdir -p "$MOUNTDIR"
    fi
    if ( test -d "$MOUNTDIR" )
    then
      '$CDEMU' $NODE "$1" &&
      mount /dev/cdemu/$DEV "$MOUNTDIR" ||
      '$CDEMU' -u $NODE
    fi
    if ( check_mount "$MOUNTDIR" ) then
      kfmclient openURL "$MOUNTDIR"
    else
      rmdir "$MOUNTDIR"
      err 6 "$MOUNTDIR"
    fi
    ;;
  xbx2iso)
    SAVEDIR="`dirname "$1"`"
    BASE="${BSNAME%.*}"
    IMGFILE="$SAVEDIR/$BASE.img"
    
    if ( test ! -w "$SAVEDIR" ) then
      SAVEDIR="'$DESKTOP'"
    fi
    
    if ( test ! -f "$IMGFILE" ) then
      err 11 "$BASE.img"
    else
      '$CCD2ISO' "$IMGFILE" "$SAVEDIR/$BASE.iso" > /dev/null
      msg 8 "$BASE.iso" "$SAVEDIR"
    fi
    ;;
  createxbx)
    SAVEFILE=`dialog2`
    ISOFILE=`basename "$SAVEFILE"`
    SAVEDIR=`dirname "$SAVEFILE"`
    
    if ( test "$SAVEFILE" = "" ) then
      note 3
    elif ( test ! -w "$SAVEDIR" ) then
      err 14 "$SAVEDIR"
    elif ( test ! -d "$1" ) then
      err 8 "$1"
    fi
    
    '$XISO' -c "$1" "$SAVEFILE"  &&
    msg 4 "$ISOFILE" "$SAVEDIR" ||
    err 9 "$1"
    ;;
  checkiso)
    check_iso "$1"
    msg 6 "$BSNAME" "$CHECK"
    ;;
esac
echo "'$FULLNAME' script v'$VERSION'"
echo "For updates, details on have to use and help please go to:"
echo "http://kde-apps.org/content/show.php?content=11577"
' > "$PREFIX/bin/$NAME.sh" &&
  chmod +x "$PREFIX/bin/$NAME.sh" && echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }

}

# -------------------------------------------------------------------------
function install_mime {
# parameters:
# none
# -------------------------------------------------------------------------
  echo -n "Creating a folder for associations: "
  if ( test ! -d "$PREFIX/share/mimelnk/application" )
  then
    mkdir -p "$PREFIX/share/mimelnk/application/" 2>/dev/null
    test -d "$PREFIX/share/mimelnk/application" &&
    echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]" ; exit 1; }
  else
    echo -e "[ \E[33mSKIP\E[m ]"
  fi
  
  echo -n "Installing associations (*.NRG):    "
  
  echo "$DESKTOP_IMG" | sed "s/IMG/NRG/g" | sed "s/img/nrg/g" | sed "s/IMAGE/NRG/g" > \
    "$PREFIX/share/mimelnk/application/x-nrg.desktop" &&
  echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }

  echo -n "Installing associations (*.CCD):    "
  
  if ( test ! -z "$CCD2ISO" ) then
    
    echo "$DESKTOP_IMG" | sed "s/IMG/CCD/g" | sed "s/img/ccd/g" | sed "s/IMAGE/CloneCD/g" > \
      "$PREFIX/share/mimelnk/application/x-ccd.desktop" &&
    echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mSKIP\E[m ]"
  fi

  echo -n "Installing associations (*.MDF):    "
  
  if ( test ! -z "$MDF2ISO" ) then
    
    echo "$DESKTOP_IMG" | sed "s/IMG/MDF/g" | sed "s/img/mdf/g" | sed "s/IMAGE/Alcohol/g" > \
      "$PREFIX/share/mimelnk/application/x-mdf.desktop" &&
    echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mSKIP\E[m ]"
  fi

  echo -n "Installing associations (*.CUE):    "
  
  if ( test ! -z "$CDEMU" ) || ( test ! -z "$BCHUNK" ) then
    
    echo '[Desktop Entry]
Type=MimeType
Patterns=*.cue;*.CUE
MimeType=application/x-cue
Icon=cdimage
Comment=CDRWIN Cue-Sheet
Comment[af]=CDRWIN Cue-Bladsy
Comment[bg]=Документ CDRWIN
Comment[bn]=CDRWIN কিউ-শিট
Comment[bs]=CDRWIN cue-sheet
Comment[ca]=Full de pistes de CDRWIN
Comment[cs]=Obálka CDRWIN
Comment[da]=CDRWIN hjælpeark
Comment[de]=CDRWIN Cue-Datei
Comment[el]=Φύλλο Cue του CDRWIN
Comment[es]=Hoja cue de CDRWIN
Comment[et]=CDRWIN cue-sheet
Comment[eu]=CDRWIN cue-orria
Comment[fi]=CDRWIN kansilehti
Comment[fr]=feuille CDRWIN
Comment[gl]=Folla Cue de CDRWIN 
Comment[hi]=सीडीआरविन क्यू-शीट
Comment[hu]=CDRWIN-es Cue-fájl
Comment[is]=CDRWIN cue-skjal
Comment[it]=Cuesheet di CDRWin
Comment[lb]=CDRWIN-Cue-Datei
Comment[mk]=CDRWIN-табела со ознаки
Comment[ms]=Lembaran CDRWIN Cue
Comment[nb]=CDRWIN cue-ark
Comment[nds]=Cue-Blatt vun CDRWIN
Comment[nl]=CDRWIN-cue-sheet
Comment[nn]=CDRWIN-cue-ark
Comment[pa]=CDRWIN Cue-ਸ਼ੀਟ
Comment[pl]=Arkusz cue CDRWIN
Comment[pt]=Ficheiro de Dados CDRWIN
Comment[pt_BR]=Folha Cue CDRWIN
Comment[ro]=Proiect audio CD CDRWIN
Comment[ru]=Таблица CDRWIN cue
Comment[rw]=Urupapuro-murizo CDRWIN
Comment[se]=CDRWIN-cue-árka
Comment[sk]=CDRWIN cue-sheet
Comment[sl]=CDRWIN cue-sheet
Comment[sr]=CDRWIN cue-sheet
Comment[sr@Latn]=CDRWIN cue-sheet
Comment[sv]=CDRWIN-indexblad
Comment[ta]=CRDWIN முன்னோடித்தாள்
Comment[tg]=Феҳристи CDRWIN
Comment[tt]=CDRWIN Cue-Cäymäse
Comment[uk]=Файл диску CDRWIN
Comment[vi]=Tờ hiệu báo CDRWIN
' > "$PREFIX/share/mimelnk/application/x-cue.desktop" &&
    echo -e "[  \E[32mOK\E[m  ]" || { echo -e "[\E[31mFAILED\E[m]"; exit 1; }
  else
    echo -e "[ \E[33mSKIP\E[m ]"
  fi

  
}

# -------------------------------------------------------------------------
function setup_sudo {
# parameters:
# none
# -------------------------------------------------------------------------
  
  echo
  echo "Only root can edit sudo config - type root password here"
# add 1 line to /etc/sudoers to give users permission to (u)mount loopback devices in their home directory
  su -c 'echo; echo "Making a backup copy of /etc/sudoers in /etc/sudoers.$(date +%Y-%m-%d-%T)"; cp /etc/sudoers /etc/sudoers.$(date +%Y-%m-%d-%T) && echo "%users ALL=NOPASSWD:/bin/mount -t udf\,iso9660 -o loop\,ro\,nodev\,noexec\,nosuid\,* */Mount-ISO*,/bin/umount */Mount-ISO*" >> /etc/sudoers && echo && echo "Success! Press Enter to continue" && read'

}

# -------------------------------------------------------------------------
function reset_sudo {
# parameters:
# none
# -------------------------------------------------------------------------
  
  echo
  echo "Only root can edit sudo config - type root password here"
# copy the content of /etc/sudoers to a buffer first and then
# delete all lines in /etc/sudoers to give users permission to
# (u)mount loopback devices in their home directory
  su -c 'echo; echo "Making a backup copy of /etc/sudoers in /etc/sudoers.$(date +%Y-%m-%d-%T)"; cp /etc/sudoers /etc/sudoers.$(date +%Y-%m-%d-%T) && SUDOERS=$(</etc/sudoers) && echo "$SUDOERS" | sed -e "/[mM]ount-[iI][sS][oO]/d" > /etc/sudoers && echo && echo "Success! Press Enter to continue" && read'

}

# start data extract function
function set_exp {
# parameters:
# none
# -------------------------------------------------------------------------

  PREFIX=$EXTRACT

clear
echo
echo -e "   - \E[7m $FULLNAME Data Extractor Menu \E[m -"
echo
echo "--------------------------------------------"
echo
echo -e "$FULLNAME data will be extracted to: \E[33m$PREFIX\E[m"
echo
echo -e "\E[7mSelect action:\E[m"
echo -e " \E[35m1\E[m - Extract $FULLNAME with \E[34m$SUDO\E[m"
echo -e " \E[35m2\E[m - Extract $FULLNAME with \E[34m$SU\E[m"
echo -e " \E[35m3\E[m - Return to Main Menu"
echo -e " \E[35m0\E[m - Quit the Extractor"
echo
echo -e -n "Select options \E[35m1\E[m - \E[35m3\E[m or \E[35m0\E[m to quit:\E[35m "
read extr
echo -e "\E[m"
  case "$extr" in
    1)
      install_$DE $SUDO
      exit 0
      ;;
    2)
      install_$DE $SU
      exit 0
      ;;
    3)
      continue
      ;;
    0)
      bye
      exit 0
      ;;
  esac
}
# end data extract function

# -------------------------------------------------------------------------
#
# MAIN
#
# -------------------------------------------------------------------------

# clear the screen
clear

# show main menu
while :
do
# clear the screen
  clear  
  # initialize and detect environment variables
  echo -e "          - \E[7m $FULLNAME v$VERSION \E[m -"
  echo
  echo "--------------------------------------------"
  echo -e "\E[7mEnvironment:\E[m"
  set_env
  echo -e "\E[7mDevices:\E[m"
  set_dev
  echo -e "\E[7mUtilities:\E[m"
  set_bin
  echo "--------------------------------------------"
  echo -e "\E[7mSelect action:\E[m"
  echo -e " \E[35m1\E[m - Install $FULLNAME using \E[34m$SUDO\E[m"
  echo -e " \E[35m2\E[m - Install $FULLNAME using \E[34m$SU\E[m"
  echo -e " \E[35m3\E[m - Specify CDROM device name"
  echo -e " \E[35m4\E[m - Specify utilities' locations"
  echo -e " \E[35m5\E[m - Setup sudo config [*]"
  echo -e " \E[35m6\E[m - Reset sudo config [*]"
  echo -e " \E[35m7\E[m - Extract $FULLNAME data"
  echo -e " \E[35m8\E[m - Uninstall $FULLNAME"
  echo -e " \E[35m0\E[m - Quit the installer"
  echo "--------------------------------------------"
  echo "[*] - requires root privileges"
  echo "--------------------------------------------"
  echo -e -n "Select options \E[35m1\E[m - \E[35m8\E[m or \E[35m0\E[m to quit:\E[35m "
  read line
  echo -e "\E[m"
# act accordingly
  case "$line" in
    1)
      install_$DE $SUDO
      exit 0
      ;;
    2) 
      install_$DE $SU
      exit 0
      ;;
    3)
      find_dev "CD-ROM" "$CDROM0"
      CDROM0="$DEV"
      find_dev "CDEMU" "$CDEMU0"
      CDEMU0="$DEV"
      continue
      ;;
    4)
      find_bin "bchunk" "$BCHUNK"
      BCHUNK="$BIN"
      find_bin "ccd2iso" "$CCD2ISO"
      CCD2ISO="$BIN"
      find_bin "cdemu" "$CDEMU"
      CDEMU="$BIN"
      find_bin "extract-xiso" "$XISO"
      XISO="$BIN"
      find_bin "mdf2iso" "$MDF2ISO"
      MDF2ISO="$BIN"
      continue
      ;;
    5)
      setup_sudo
      continue
      ;;
    6)
      reset_sudo
      continue
      ;;
    7)
      set_exp
      exit 0
      ;;
    8)
      byebye
      uninstall
      bye
      exit 0
      ;;
    0)
      bye
      exit 0
      ;;
    *)
      echo
      ;;
  esac
  
done
