/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		created 2006,2007 by Harald Foerster			   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef __berkeley_h__

#ifdef CONFIG_BERKELEY_DB

#include <sys/types.h>
#include <glib.h>

typedef struct
{
	void	*data;	/* data */
	size_t	 size;	/* data length */

} DBT;

typedef struct
{
	void	*userdata;
	int	error;

} DBnscache;

typedef void* (*CacheEntryReadFunc)(DBT *key, DBT *data, DBnscache *nsc);

int berkeley_check(const char *dbname, const DBT *key);
GSList *berkeley_read(char **dbname, CacheEntryReadFunc func, void *userdata);

#ifndef CACHE_READONLY
int berkeley_delete(const char *dbname, const char *filename, const DBT *key);
#endif

#endif /* CONFIG_BERKELEY_DB */

#endif /* __berkeley_h__ */
