/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		created and modified 2005,2006,2007 by Harald Foerster	   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef BSWAP32_H
#define BSWAP32_H

#include <glib.h>

typedef guint32 (*ByteSwap32Func)(guint32 val);

extern guint32 bswap32_be_le(guint32 val);
extern guint32 bswap32_be_pdp(guint32 val);
extern guint32 bswap32_le_pdp(guint32 val);

#define BSWAP32_BE_LE_FUNC		((ByteSwap32Func) bswap32_be_le)
#define BSWAP32_BE_PDP_FUNC		((ByteSwap32Func) bswap32_be_pdp)
#define BSWAP32_LE_PDP_FUNC		((ByteSwap32Func) bswap32_le_pdp)

#define BSWAP32_BE_LE(val)		bswap32_be_le(val)
#define BSWAP32_BE_PDP(val)		bswap32_be_pdp(val)
#define BSWAP32_LE_PDP(val)		bswap32_le_pdp(val)

#define BYTESWAP_UINT16(val)		GUINT16_SWAP_LE_BE(val)

#if G_BYTE_ORDER == G_BIG_ENDIAN

#define UINT32_IS_BIG_ENDIAN		1

#define UINT32_FROM_BIG_ENDIAN(val)	((guint32) val)
#define UINT32_TO_BIG_ENDIAN(val)	((guint32) val)
#define UINT32_FROM_LITTLE_ENDIAN(val)	BSWAP32_BE_LE(val)
#define UINT32_TO_LITTLE_ENDIAN(val)	BSWAP32_BE_LE(val)

#define BSWAP32_BIG_ENDIAN_FUNC		((ByteSwap32Func) NULL)
#define BSWAP32_LITTLE_ENDIAN_FUNC	BSWAP32_BE_LE_FUNC
#define BSWAP32_PDP_ENDIAN_FUNC		BSWAP32_BE_PDP_FUNC

#elif G_BYTE_ORDER == G_LITTLE_ENDIAN

#define UINT32_IS_LITTLE_ENDIAN		1

#define UINT32_FROM_BIG_ENDIAN(val)	BSWAP32_BE_LE(val)
#define UINT32_TO_BIG_ENDIAN(val)	BSWAP32_BE_LE(val)
#define UINT32_FROM_LITTLE_ENDIAN(val)	((guint32) val)
#define UINT32_TO_LITTLE_ENDIAN(val)	((guint32) val)

#define BSWAP32_BIG_ENDIAN_FUNC		BSWAP32_BE_LE_FUNC
#define BSWAP32_LITTLE_ENDIAN_FUNC	((ByteSwap32Func) NULL)
#define BSWAP32_PDP_ENDIAN_FUNC		BSWAP32_LE_PDP_FUNC

#elif G_BYTE_ORDER == G_PDP_ENDIAN

#define UINT32_IS_PDP_ENDIAN		1

#ifndef CONFIG_PDP_ENDIAN
#define CONFIG_PDP_ENDIAN		1
#endif

#define UINT32_FROM_BIG_ENDIAN(val)	BSWAP32_BE_PDP(val)
#define UINT32_TO_BIG_ENDIAN(val)	BSWAP32_BE_PDP(val)
#define UINT32_FROM_LITTLE_ENDIAN(val)	BSWAP32_LE_PDP(val)
#define UINT32_TO_LITTLE_ENDIAN(val)	BSWAP32_LE_PDP(val)

#define BSWAP32_BIG_ENDIAN_FUNC		BSWAP32_BE_PDP_FUNC
#define BSWAP32_LITTLE_ENDIAN_FUNC	BSWAP32_LE_PDP_FUNC
#define BSWAP32_PDP_ENDIAN_FUNC		((ByteSwap32Func) NULL)

#else

#error Endian not recognized!

#endif

#define UINT32_FROM_LITTLE_ENDIAN_PTR(ptr) \
		UINT32_FROM_LITTLE_ENDIAN(*((guint32 *) ptr))

#endif /* BSWAP32_H */
