/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		created and modified 2007,2008 by Harald Foerster	   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <string.h>

#include "charconv.h"

/*
#include <glib.h>
#include "nls.h"
*/

#if GLIB_MAJOR_VERSION == 1

#include <iconv.h>
#include <stdlib.h>

#if defined(HAVE_CYGWIN) && defined(HAVE_LOCALE)
#ifndef HAVE_GETTEXT
#include <locale.h>
#endif
#endif

#ifdef HAVE_LANGINFO
#include <langinfo.h>
#endif

#ifdef HAVE_UNICODE
#include <unicode.h>
#endif

#define CHARCONV_T iconv_t

#define CHARCONV_OPEN(to, from) \
		iconv_open((to), (from))
#define CHARCONV_RUN(cd, instr, inlen, outstr, outlen) \
		iconv((cd), (instr), (inlen), (outstr), (outlen))
#define CHARCONV_CLOSE(cd) \
		iconv_close(cd)

#else /* GLIB_MAJOR_VERSION > 1 */

#define CHARCONV_T GIConv

#define CHARCONV_OPEN(to, from) \
		g_iconv_open((to), (from))
#define CHARCONV_RUN(cd, instr, inlen, outstr, outlen) \
		g_iconv((cd), (instr), (inlen), (outstr), (outlen))
#define CHARCONV_CLOSE(cd) \
		g_iconv_close(cd)

#endif /* #if GLIB_MAJOR_VERSION == 1 .. #else */


#ifndef ICONV_CONST
#define ICONV_CONST
#endif


const gchar charconv_iso8859_1_str[]	= "ISO-8859-1";
const gchar charconv_utf8_str[]		= "UTF-8";
const gchar *charconv_locale_str;


gchar *charconv(const gchar *str, const gchar *to, const gchar *from, gint *tflen)
{
	CHARCONV_T cd;

	if (to == NULL)
	{
		to = charconv_iso8859_1_str;
	}

	if (from == NULL)
	{
		from = charconv_iso8859_1_str;
	}

	if (to == from || g_strcasecmp(to, from) == 0)
	{
		if (tflen && *tflen < 0)
		{
			*tflen = strlen(str);
		}

		return (gchar *) str;
	}

	cd = CHARCONV_OPEN(to, from);

	if (cd != (CHARCONV_T) -1)
	{
		ICONV_CONST gchar *buf_in;
		gchar	*buf_out, *retv;
		gint	result;
		size_t	sz_in, sz_out;

		sz_in = (tflen == NULL || *tflen < 0) ? strlen(str) : *tflen;
		buf_in = (gchar *) str;
		sz_out = 1023;
		retv = g_malloc(sz_out + 1);
		buf_out = retv;

		result = CHARCONV_RUN(cd, &buf_in, &sz_in, &buf_out, &sz_out);
		CHARCONV_CLOSE(cd);

		if (result >= 0)
		{
			result = 1023 - sz_out;
			retv[result] = '\0';

			if (tflen)
			{
				*tflen = result;
			}

			return g_realloc(retv, result + 1);
		}

		g_free(retv);
	}

	return NULL;
}

#if GLIB_MAJOR_VERSION == 1

void charconv_init(void)
{
	/*
		'nl_langinfo' under Cygwin
		or 'unicode_get_charset'
		seems always returning an
		'ASCII-US' character set
	*/

#ifdef HAVE_LANGINFO

	gchar *charset;
#endif

#ifdef HAVE_UNICODE

	unicode_init();
#endif

#ifdef HAVE_LANGINFO

#ifdef HAVE_CYGWIN
#ifdef HAVE_LOCALE

	charset = setlocale(LC_CTYPE, "de_DE");

	if (charset)
	{
		setlocale(LC_CTYPE, "");
		charset = nl_langinfo(CODESET);
	}
#else
	charset = NULL;
#endif

#else
	charset = nl_langinfo(CODESET);
#endif
	if (charset)
	{
		if (g_strcasecmp(charset, charconv_iso8859_1_str) == 0)
		{
			charconv_locale_str = charconv_iso8859_1_str;
		}

		else
		{
			charconv_locale_str = g_strdup(charset);
		}
	}
	else

#endif /* HAVE_LANGINFO */

	charconv_locale_str = "";
}

#else /* GLIB_MAJOR_VERSION > 1 */

void charconv_init(void)
{
	g_get_charset(&charconv_locale_str);

	if (strcmp(charconv_locale_str, charconv_iso8859_1_str) == 0)
	{
		charconv_locale_str = charconv_iso8859_1_str;
	}

	else
	{
		charconv_locale_str = g_strdup(charconv_locale_str);
	}
}

gchar *charconv_utf8_from_locale(const gchar *str)
{
	if (str && g_utf8_validate(str, -1, NULL) == FALSE)
	{
		return g_locale_to_utf8(str, -1, NULL, NULL, NULL);
	}

	return (gchar *) str;
}

gchar *charconv_utf8_from_locale_dup(const gchar *str)
{
	gchar *utf = charconv_utf8_from_locale(str);

	if (utf == str)
	{
		return g_strdup(utf);
	}

	return utf;
}

gchar *charconv_utf8_to_locale(const gchar *str)
{
	if (str && g_utf8_validate(str, -1, NULL))
	{
		return g_locale_from_utf8(str, -1, NULL, NULL, NULL);
	}

	return (gchar *) str;
}

gchar *charconv_utf8_to_locale_dup(const gchar *str)
{
	gchar *utf = charconv_utf8_to_locale(str);

	if (utf == str)
	{
		return g_strdup(utf);
	}

	return utf;
}

gchar *charconv_utf8_gettext(const gchar *str)
{
	if (str)
	{
		gchar *utf, *nls;

		nls = gettext(str);
		utf = charconv_utf8_from_locale(nls);

		if (utf == nls)
		{
			return g_strdup(utf);
		}

		if (utf != NULL)
		{
			return utf;
		}
	}

	return (gchar *) str;
}

#endif /* #if GLIB_MAJOR_VERSION == 1 .. #else */

/* EOF */
