/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		created and modified 2007,2008 by Harald Foerster	   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef CHARCONV_H
#define CHARCONV_H

#include <glib.h>

#ifndef X_LOCALE
#include "nls.h"
#endif

#ifdef HAVE_ICONV

extern const gchar charconv_iso8859_1_str[];
extern const gchar charconv_utf8_str[];
extern const gchar *charconv_locale_str;

extern gchar *charconv(const gchar *str, const gchar *to, const gchar *from, gint *tflen);
extern void   charconv_init(void);

#else /* ! HAVE_ICONV */

#define charconv_iso8859_1_str	"ISO-8859-1"
#define charconv_init()

#endif /* #ifdef HAVE_ICONV .. #else */

#if GLIB_MAJOR_VERSION == 1

#define CHARCONV_UTF8_FROM_FILENAME(str, len)	\
	((gchar *) (((len) == NULL) ? (str) : (*(gint *) (len) = strlen(str), (str))))
#define CHARCONV_UTF8_TO_FILENAME(str)		((gchar *) (str))

#define CHARCONV_UTF8_DESTROY(str)
#define CHARCONV_UTF8_FREE(utf, str)

#define CHARCONV_UTF8_FROM_LOCALE(str)		((gchar *) (str))
#define CHARCONV_UTF8_FROM_LOCALE_DUP(str)	g_strdup(str)
#define CHARCONV_UTF8_TO_LOCALE(str)		((gchar *) (str))
#define CHARCONV_UTF8_TO_LOCALE_DUP(str)	g_strdup(str)
#define CHARCONV_UTF8_GETTEXT(str)		gettext(str)

#else /* GLIB_MAJOR_VERSION > 1 */

#define CHARCONV_UTF8_FROM_FILENAME(str, len)	\
	(((str) == NULL) ? ((gchar *) (str)) : \
		g_filename_to_utf8((str), -1, NULL, (len), NULL))
#define CHARCONV_UTF8_TO_FILENAME(str) \
	(((str) == NULL) ? ((gchar *) (str)) : \
		g_filename_from_utf8((str), -1, NULL, NULL, NULL))

/* frees 'str' */
#define CHARCONV_UTF8_DESTROY(str)		g_free(str)
/* frees if 'str' differs from 'orig' */
#define CHARCONV_UTF8_FREE(str, orig)		if ((str) != (orig)) {g_free(str);}

#define CHARCONV_UTF8_FROM_LOCALE(str) \
			charconv_utf8_from_locale(str)
#define CHARCONV_UTF8_FROM_LOCALE_DUP(str) \
			charconv_utf8_from_locale_dup(str)
#define CHARCONV_UTF8_TO_LOCALE(str) \
			charconv_utf8_to_locale(str)
#define CHARCONV_UTF8_TO_LOCALE_DUP(str) \
			charconv_utf8_to_locale_dup(str)
#define CHARCONV_UTF8_GETTEXT(str) \
			charconv_utf8_gettext(str)

extern gchar *charconv_utf8_from_locale(const gchar *str);
extern gchar *charconv_utf8_from_locale_dup(const gchar *str);
extern gchar *charconv_utf8_to_locale(const gchar *str);
extern gchar *charconv_utf8_to_locale_dup(const gchar *str);
extern gchar *charconv_utf8_gettext(const gchar *str);

#endif /* GLIB_MAJOR_VERSION */

#endif /* CHARCONV_H */
