/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		created and modified 2005 ... 2008 by Harald Foerster	   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef FILE_H
#define FILE_H

#include <sys/types.h>
#include <sys/stat.h>

#include "nscache.h"


enum
{
	ERR_FILE_OPEN_SRC	= -1,
	ERR_FILE_OPEN_DST	= -2,
	ERR_FILE_WRITE		= -3,
	ERR_FILE_LINK		= -4,
	ERR_FILE_DIR_CREATE	= -5
};

enum
{
	FILE_ACCESS_READ	= (1 << 0),
	FILE_ACCESS_WRITE	= (1 << 1),
	FILE_ACCESS_REMOVE	= (1 << 2)
};

enum
{
	FILE_PERM_USER = 0644,
	FILE_PERM_TEMP = 0600,
	DIR_PERMISSION = 0755
};

enum
{
	URL_CONVERT_NONE,
	URL_CONVERT_ALL_DOMAIN_REFERENCE,
	URL_CONVERT_ONLY_FILE_REFERENCE
};

typedef struct
{
	int   folders;
	int   files;
	int   converted;
	int   errors;
	int   errnr;
	char *fname;

} SaveDirResult;


extern const char	index_html_str[12];
extern unsigned int	decode;
extern unsigned int	single_folder;
extern unsigned int	url_to_local_selector;

#ifdef HAVE_LINK
extern unsigned int	hardlink;
#endif

int  file_access_index(void);
int  file_access(const nscache_record_t* rec);
int  file_chmod(const nscache_record_t* rec, mode_t mode);
int  file_status(const nscache_record_t* rec, struct stat* statbuf);

void *file_read(const nscache_record_t* rec, size_t* length);
int  file_copy(const nscache_record_t* rec, char* dst, mode_t file_perm);
int  file_save(const nscache_record_t* rec, char* dst);
int  folder_save(const char* dst, const nscache_record_t** rec_array,
							int depth, SaveDirResult* sdr);

/* filename without path */
int  file_open(const char* filename, int flags);

#ifndef CACHE_READONLY
int  file_remove(const char* filename);
#endif

#endif /* FILE_H */
