/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		modified 2005 ... 2008 by Harald Foerster		   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _gaccel_h_
#define _gaccel_h_

#include <gtk/gtk.h>
#include <stdio.h>


enum
{
	kGAccelKeyNone	= -1,
	kGAccelFileOpen,
	kGAccelFileProp,
	kGAccelFileSaveRC,
	kGAccelFileQuit,
	kGAccelColumnURL,
	kGAccelColumnFile,
	kGAccelColumnType,
	kGAccelColumnSize,
	kGAccelColumnEncoding,
	kGAccelColumnCharset,
	kGAccelColumnMod,
	kGAccelColumnAcc,
	kGAccelColumnExp,
	kGAccelViewEntryInfo,
	kGAccelViewFind,
	kGAccelEditSave,
#ifndef CACHE_READONLY
	kGAccelEditDelete,
#endif
	kGAccelEditClipboard,
	kGAccelEditShowInfo,
	kGAccelEditReadOnly,
	kGAccelEditReadWrite,
	kGAccelOptViewers,
	kGAccelOptAccel,
	kGAccelOptCase,
#ifndef CACHE_READONLY
	kGAccelOptRdOnly,
#endif
	kGAccelOptDecode,
#ifdef HAVE_ICONV
	kGAccelOpt_WM_UTF8,
#endif
	kGAccelOptSave,
	kGAccelHelpAbout,
	kGAccelKeyTotal
};

typedef struct
{
	const gchar	*name;
	const gchar	*label;
	GtkWidget	*widget;
	guint		keyval;
	guint		key;
	GdkModifierType	modifier;

} gaccel_t;


void	gaccel_bind_widget(gint accel_id, const gchar *label, GtkWidget *widget, GtkWidget *parent);
void	gaccel_dialog_open(void);
gint	gaccel_parse_str(gchar *str);
void	gaccel_save_data(FILE *fd, const gchar *id);

#endif /* _gaccel_h_ */

