/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		modified 2005 ... 2008 by Harald Foerster		   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _gprop_h_
#define _gprop_h_

#include <stdio.h>

enum
{
	kPropStrItemFirst,

	kPropStrFindPattern = kPropStrItemFirst,
	kPropStrFindMimeType,
	kPropStrSavePath,

	kPropStrItemsTotal,
	kPropStrItemLast = kPropStrItemsTotal - 1
};

enum
{
	kPropIntItemFirst,

	kPropIntMainWinWidth = kPropIntItemFirst,
	kPropIntMainWinHeight,

	kPropIntSortType,

	kPropIntTreeColWidthUrl,
	kPropIntTreeColWidthFile,
	kPropIntTreeColWidthType,
	kPropIntTreeColWidthSize,
	kPropIntTreeColWidthEnc,
	kPropIntTreeColWidthCharset,
	kPropIntTreeColWidthMdtm,
	kPropIntTreeColWidthAtm,
	kPropIntTreeColWidthExp,

	kPropIntListColWidthUrl,
	kPropIntListColWidthFile,
	kPropIntListColWidthType,
	kPropIntListColWidthSize,
	kPropIntListColWidthEnc,
	kPropIntListColWidthCharset,
	kPropIntListColWidthMdtm,
	kPropIntListColWidthAtm,
	kPropIntListColWidthExp,

	kPropIntColNumUrl,
	kPropIntColNumFile,
	kPropIntColNumType,
	kPropIntColNumSize,
	kPropIntColNumEnc,
	kPropIntColNumCharset,
	kPropIntColNumMdtm,
	kPropIntColNumAtm,
	kPropIntColNumExp,

	kPropIntFindWinWidth,
	kPropIntFindWinHeight,
	kPropIntFindColWidthUrl,
	kPropIntFindColWidthFound,
	kPropIntFindColWidthFile,
	kPropIntFindColWidthLine,

	kPropIntInfoWinWidth,
	kPropIntInfoWinHeight,

	kPropIntSaveUrlToLocal,

	kPropIntItemsTotal,
	kPropIntItemLast = kPropIntItemsTotal - 1
};

enum
{
	kPropBoolItemFirst,

	kPropBoolShowColUrl = kPropBoolItemFirst,
	kPropBoolShowColFile,
	kPropBoolShowColType,
	kPropBoolShowColSize,
	kPropBoolShowColEnc,
	kPropBoolShowColCharset,
	kPropBoolShowColMdtm,
	kPropBoolShowColAtm,
	kPropBoolShowColExp,

	kPropBoolOptFnameToLower,
#ifndef CACHE_READONLY
	kPropBoolOptReadOnly,
#endif
	kPropBoolOptDecode,
#ifdef HAVE_ICONV
	kPropBoolOpt_WM_UTF8,
#endif
	kPropBoolOptSaveConfig,

	kPropBoolFindCaseSensitive,
	kPropBoolFindFullMatch,
#ifdef HAVE_REGEX
	kPropBoolFindWithRegex,
#endif
#ifdef HAVE_LINK
	kPropBoolSaveHardlink,
#endif
	kPropBoolSaveSingleFolder,

	kPropBoolItemsTotal,
	kPropBoolItemLast = kPropBoolItemsTotal - 1
};

void gprop_set_str(int item, const char *sval);
void gprop_set_int(int item, int ival);
void gprop_set_bool(int item, int bval);
int  gprop_get_str(int item, char **svalp);
int  gprop_get_int(int item, int *ivalp);
int  gprop_get_bool(int item, int *bvalp);
int  gprop_parse_str(char *str);
void gprop_save_data(FILE *fd, const char *id);

#endif /* _gprop_h_ */
