/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		created and modified 2006,2007 by Harald Foerster 	   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _gui_gtk_h_
#define _gui_gtk_h_

#include <gtk/gtk.h>

#if GTK_MAJOR_VERSION == 1
#ifndef CONFIG_GTKCLIST_GTKCTREE
#define CONFIG_GTKCLIST_GTKCTREE	1
#endif
#endif

#define GUI_LIST_ROW_HEIGHT_MIN		16

typedef struct
{
#ifdef CONFIG_GTKCLIST_GTKCTREE
	GtkCList		*clist;
	gint			row;
#else
	GtkListStore		*slist;
	GtkTreeView		*view;
	GtkTreeSelection	*selection;
	GtkTreeIter		iter;
	gint			data_column;
#endif

} GuiListStore;

typedef struct
{
#ifdef CONFIG_GTKCLIST_GTKCTREE
	GtkCTree		*ctree;
	GtkCTreeNode		*node;
#else
	GtkTreeStore		*stree;
	GtkTreeView		*view;
	GtkTreeSelection	*selection;
	GtkTreeIter		iter;
	gint			data_column;
#endif

} GuiTreeStore;


/*
	*
	* ---------------
	*  Signal Macros
	* ---------------
	*
*/

#if GTK_MAJOR_VERSION == 1

#define GuiSignalFunc	GtkSignalFunc

#define GuiSignalConnect(object, name, func, data) \
	gtk_signal_connect(GTK_OBJECT(object), (name), GTK_SIGNAL_FUNC(func), (data))
#define GuiSignalConnectAfter(object, name, func, data) \
	gtk_signal_connect_after(GTK_OBJECT(object), (name), GTK_SIGNAL_FUNC(func), (data))
#define GuiSignalConnectSwapped(object, name, func, swap_obj) \
	gtk_signal_connect_object(GTK_OBJECT(object), (name), \
					GTK_SIGNAL_FUNC(func), GTK_OBJECT(swap_obj))
#define GuiSignalEmitStopByName(object, name) \
	gtk_signal_emit_stop_by_name(GTK_OBJECT(object), (name))
#define GuiSignalHandlerBlock(object, id) \
	gtk_signal_handler_block(GTK_OBJECT(object), (id))
#define GuiSignalHandlerUnblock(object, id) \
	gtk_signal_handler_unblock(GTK_OBJECT(object), (id))

#else /*  GTK_MAJOR_VERSION > 1 */

#define GuiSignalFunc	GCallback

#define GuiSignalConnect(instance, name, func, data) \
	g_signal_connect((gpointer) (instance), (name), G_CALLBACK(func), (data))
#define GuiSignalConnectAfter(instance, name, func, data) \
	g_signal_connect_after((gpointer) (instance), (name), G_CALLBACK(func), (data))
#define GuiSignalConnectSwapped(instance, name, func, swap_obj) \
	g_signal_connect_swapped((gpointer) (instance), (name), \
					G_CALLBACK(func), G_OBJECT(swap_obj))
#define GuiSignalEmitStopByName(instance, name) \
	g_signal_stop_emission_by_name((gpointer) (instance), (name))
#define GuiSignalHandlerBlock(instance, id) \
	g_signal_handler_block((gpointer) (instance), (id))
#define GuiSignalHandlerUnblock(instance, id) \
	g_signal_handler_unblock((gpointer) (instance), (id))

#endif /* #if GTK_MAJOR_VERSION == 1 .. #else */


/*
	*
	* -----------------------------
	*  Common List and Tree Macros
	* -----------------------------
	*
*/

#ifndef CONFIG_GTKCLIST_GTKCTREE
#define GuiRendererSetProperties(renderer, ht, align) \
	g_object_set((renderer), "height", (ht), \
				"xalign", (align), "ypad", 0, NULL); \

#define GuiRendererTextNew(renderer, height, align) \
{ \
	(renderer) = gtk_cell_renderer_text_new(); \
	GuiRendererSetProperties((renderer), (height), (align)); \
}

#define GuiStoreColumnAppend(view, column, colnr, renderer, expand) \
{ \
	gtk_tree_view_column_pack_start((column), (renderer), (expand)); \
	gtk_tree_view_column_add_attribute((column), (renderer), "text", (colnr)); \
	gtk_tree_view_append_column((view), (column)); \
}

#define GuiStoreColumnPixbufNew(height, pixcol, column, renderer) \
{ \
	(column) = gtk_tree_view_column_new(); \
	(renderer) = gtk_cell_renderer_pixbuf_new(); \
	GuiRendererSetProperties((renderer), (height), 0.0); \
	gtk_tree_view_column_pack_start((column), (renderer), FALSE); \
	gtk_tree_view_column_add_attribute((column), (renderer), "pixbuf", (pixcol)); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreColumnSort(clist, colnr, func) \
{ \
	gtk_clist_set_sort_column((clist), (colnr)); \
	gtk_clist_set_compare_func((clist), \
			(GtkCListCompareFunc) (func)); \
}
#else
#define GuiStoreColumnSort(store, colnr, func, data) \
{ \
	gtk_tree_sortable_set_sort_func(GTK_TREE_SORTABLE(store), \
				(colnr), (GtkTreeIterCompareFunc) (func), \
						(gpointer) (data), NULL); \
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(store), \
						(colnr), GTK_SORT_ASCENDING); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreColumnTextNew(clist, colnr, height, justify) {;}
#else
#define GuiStoreColumnTextNew(view, colnr, height, justify) \
{ \
	GtkCellRenderer   *renderer; \
	GtkTreeViewColumn *column; \
	gfloat align; \
	gboolean expand; \
	column = gtk_tree_view_column_new(); \
	if ((justify) == GTK_JUSTIFY_RIGHT) \
	{ \
		align = 1.0; \
		expand = TRUE; \
	} \
	else \
	{ \
		align = 0.0; \
		expand = FALSE; \
	} \
	GuiRendererTextNew(renderer, (height), align); \
	GuiStoreColumnAppend((view), column, (colnr), renderer, expand); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreColumnTitleActive(clist, colnr, active) \
{ \
	if (active) \
		gtk_clist_column_title_active((clist), (colnr)); \
	else \
		gtk_clist_column_title_passive((clist), (colnr)); \
}
#else
#define GuiStoreColumnTitleActive(view, colnr, active) \
{ \
	GtkTreeViewColumn *column; \
	column = gtk_tree_view_get_column((view), (colnr)); \
	gtk_tree_view_column_set_clickable(column, (active)); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreColumnTitlesPassive(clist) \
	gtk_clist_column_titles_passive(clist)
#else
#define GuiStoreColumnTitlesPassive(view) \
	g_object_set((view), "headers-clickable", FALSE, NULL)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreColumnTitlesShow(clist) \
	gtk_clist_column_titles_show(clist)
#else
#define GuiStoreColumnTitlesShow(view) \
	g_object_set((view), "headers-visible", TRUE, NULL)
#endif

#define GuiStoreContainerAdd(container, widget) \
	gtk_container_add(GTK_CONTAINER(container), GTK_WIDGET(widget))

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreFreeze(clist) \
	gtk_clist_freeze(clist)
#else
#define GuiStoreFreeze(store, view) \
{ \
	g_object_ref(G_OBJECT(store)); \
	gtk_tree_view_set_model((view), NULL); \
}
#endif

#ifndef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreInit(store, view, selection, data_column, colnr) \
{ \
	(view) = (GtkTreeView *) \
		gtk_tree_view_new_with_model(GTK_TREE_MODEL(store)); \
	(selection) = gtk_tree_view_get_selection(view); \
	(data_column) = (colnr); \
	g_object_unref(G_OBJECT(store)); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreSelectFirstRow(clist) \
	gtk_clist_select_row((clist), 0, 0)
#else
#define GuiStoreSelectFirstRow(store, selection) \
{ \
	GtkTreeIter iter; \
	if (gtk_tree_model_get_iter_first(GTK_TREE_MODEL(store), &iter)) \
	{ \
		gtk_tree_selection_select_iter((selection), &iter); \
	} \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreSetColumnAlignment(clist, colnr, alignment) {;}
#else
#define GuiStoreSetColumnAlignment(view, colnr, alignment) \
{ \
	GtkTreeViewColumn *column; \
	column = gtk_tree_view_get_column((view), (colnr)); \
	gtk_tree_view_column_set_alignment(column, (alignment)); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreSetColumnAutoResize(clist, colnr, autoresize) \
	gtk_clist_set_column_auto_resize((clist), (colnr), (autoresize))
#else
#define GuiStoreSetColumnAutoResize(view, colnr, autoresize) \
{ \
	GtkTreeViewColumn* column; \
	column = gtk_tree_view_get_column((view), (colnr)); \
	gtk_tree_view_column_set_sizing(column, ((autoresize) ? \
				GTK_TREE_VIEW_COLUMN_AUTOSIZE : \
				GTK_TREE_VIEW_COLUMN_FIXED)); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreSetColumnResizable(clist, colnr, resizable) \
	gtk_clist_set_column_resizeable((clist), (colnr), (resizable))
#else
#define GuiStoreSetColumnResizable(view, colnr, resizable) \
{ \
	GtkTreeViewColumn* column; \
	column = gtk_tree_view_get_column((view), (colnr)); \
	gtk_tree_view_column_set_resizable(column, (resizable)); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreSetColumnVisiblility(clist, colnr, visible) \
	gtk_clist_set_column_visibility((clist), (colnr), (visible))
#else
#define GuiStoreSetColumnVisiblility(view, colnr, visible) \
{ \
	GtkTreeViewColumn* column; \
	column = gtk_tree_view_get_column((view), (colnr)); \
	gtk_tree_view_column_set_visible(column, (visible)); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreSetColumnWidget(clist, colnr, widget) \
	gtk_clist_set_column_widget((clist), (colnr), (widget))
#else
#define GuiStoreSetColumnWidget(view, colnr, widget) \
{ \
	GtkTreeViewColumn* column; \
	column = gtk_tree_view_get_column((view), (colnr)); \
	gtk_tree_view_column_set_widget(column, (widget)); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreSetColumnWidth(clist, colnr, width) \
	gtk_clist_set_column_width((clist), (colnr), (width))
#else
#define GuiStoreSetColumnWidth(view, colnr, width) \
{ \
	GtkTreeViewColumn* column; \
	column = gtk_tree_view_get_column((view), (colnr)); \
	gtk_tree_view_column_set_fixed_width(column, (width)); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreSetSelectionMode(clist, mode) \
	gtk_clist_set_selection_mode((clist), (mode))
#else
#define GuiStoreSetSelectionMode(selection, mode) \
	gtk_tree_selection_set_mode((selection), (mode))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreSignalConnectResizeColumn(object, func, data) \
	GuiSignalConnect((object), "resize-column", (func), (data))
#else
#define GuiStoreSignalConnectResizeColumn(view, colnr, func, data) \
{ \
	GtkTreeViewColumn *column; \
	column = gtk_tree_view_get_column((view), (colnr)); \
	GuiSignalConnect(column, "notify::width", (func), (data)); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiStoreThaw(clist) \
	gtk_clist_thaw(clist)
#else
#define GuiStoreThaw(store, view) \
{ \
	gtk_tree_view_set_model((view), GTK_TREE_MODEL(store)); \
	g_object_unref(G_OBJECT(store)); \
}
#endif


/*
	*
	* -------------
	*  List Macros
	* -------------
	*
*/

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListClear(list) \
	gtk_clist_clear((list)->clist)
#else
#define GuiListClear(list) \
	gtk_list_store_clear((list)->slist)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListColumnPixtextNew(list, textcol, height, pixcol) {;}
#else
#define GuiListColumnPixtextNew(list, textcol, height, pixcol) \
{ \
	GtkCellRenderer   *renderer; \
	GtkTreeViewColumn *column; \
	GuiStoreColumnPixbufNew((height), (pixcol), column, renderer); \
	GuiRendererTextNew(renderer, (height), 0.0); \
	GuiStoreColumnAppend((list)->view, (column), (textcol), renderer, FALSE); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListColumnSort(list, colnr, func, data) \
{ \
	GuiStoreColumnSort((list)->clist, (colnr), (func)); \
	gtk_clist_sort((list)->clist); \
}
#else
#define GuiListColumnSort(list, colnr, func, data) \
	GuiStoreColumnSort((list)->slist, (colnr), (func), (data))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListColumnTextNew(list, colnr, height, justify) {;}
#else
#define GuiListColumnTextNew(list, colnr, height, justify) \
	GuiStoreColumnTextNew((list)->view, (colnr), (height), (justify))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListColumnTitleActive(list, colnr, active) \
	GuiStoreColumnTitleActive((list)->clist, (colnr), (active))
#else
#define GuiListColumnTitleActive(list, colnr, active) \
	GuiStoreColumnTitleActive((list)->view, (colnr), (active))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListColumnTitlesPassive(list) \
	GuiStoreColumnTitlesPassive((list)->clist)
#else
#define GuiListColumnTitlesPassive(list) \
	GuiStoreColumnTitlesPassive((list)->view)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListColumnTitlesShow(list) \
	GuiStoreColumnTitlesShow((list)->clist)
#else
#define GuiListColumnTitlesShow(list) \
	GuiStoreColumnTitlesShow((list)->view)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListContainerAdd(list, widget) \
	GuiStoreContainerAdd((widget), (list)->clist)
#else
#define GuiListContainerAdd(list, widget) \
	GuiStoreContainerAdd((widget), (list)->view)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListFreeze(list) \
	GuiStoreFreeze((list)->clist)
#else
#define GuiListFreeze(list) \
	GuiStoreFreeze((list)->slist, (list)->view)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListGetRowData(list, data) \
	(data) = gtk_clist_get_row_data((list)->clist, (list)->row)
#else
#define GuiListGetRowData(list, data) \
	gtk_tree_model_get(GTK_TREE_MODEL((list)->slist), &((list)->iter), \
				(list)->data_column, &(data), -1)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListGetRows(list) \
	((list)->clist)->rows
#else
#define GuiListGetRows(list) \
	gtk_tree_model_iter_n_children(GTK_TREE_MODEL((list)->slist), NULL)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListInit(list, columns) \
{ \
	(list)->row = -1; \
	(list)->clist = (GtkCList *) gtk_clist_new(columns); \
}
#else
#define GuiListInit(list, colnr) \
	GuiStoreInit((list)->slist, (list)->view, \
			(list)->selection, (list)->data_column, (colnr))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListRemove(list) \
	gtk_clist_remove((list)->clist, (list)->row)
#else
#define GuiListRemove(list) \
	gtk_list_store_remove((list)->slist, &((list)->iter))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSelectFirstRow(list) \
	GuiStoreSelectFirstRow((list)->clist)
#else
#define GuiListSelectFirstRow(list) \
	GuiStoreSelectFirstRow((list)->slist, (list)->selection)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSetColumnAlignment(clist, colnr, alignment) {;}
#else
#define GuiListSetColumnAlignment(list, colnr, alignment) \
	GuiStoreSetColumnAlignment((list)->view, (colnr), (alignment))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSetColumnAutoResize(list, colnr, autoresize) \
	GuiStoreSetColumnAutoResize((list)->clist, (colnr), (autoresize))
#else
#define GuiListSetColumnAutoResize(list, colnr, autoresize) \
	GuiStoreSetColumnAutoResize((list)->view, (colnr), (autoresize))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSetColumnResizable(list, colnr, resizable) \
	GuiStoreSetColumnResizable((list)->clist, (colnr), (resizable))
#else
#define GuiListSetColumnResizable(list, colnr, resizable) \
	GuiStoreSetColumnResizable((list)->view, (colnr), (resizable))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSetColumnTitle(list, colnr, title) \
	gtk_clist_set_column_title((list)->clist, (colnr), (title))
#else
#define GuiListSetColumnTitle(list, colnr, title) \
{ \
	GtkTreeViewColumn* column; \
	column = gtk_tree_view_get_column((list)->view, (colnr)); \
	gtk_tree_view_column_set_title(column, (title)); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSetColumnVisiblility(list, colnr, visible) \
	GuiStoreSetColumnVisiblility((list)->clist, (colnr), (visible))
#else
#define GuiListSetColumnVisiblility(list, colnr, visible) \
	GuiStoreSetColumnVisiblility((list)->view, (colnr), (visible))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSetColumnWidget(list, colnr, widget) \
	GuiStoreSetColumnWidget((list)->clist, (colnr), (widget))
#else
#define GuiListSetColumnWidget(list, colnr, widget) \
	GuiStoreSetColumnWidget((list)->view, (colnr), (widget))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSetColumnWidth(list, colnr, width) \
	GuiStoreSetColumnWidth((list)->clist, (colnr), (width))
#else
#define GuiListSetColumnWidth(list, colnr, width) \
	GuiStoreSetColumnWidth((list)->view, (colnr), (width))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSetReorderable(list) \
	gtk_clist_set_reorderable((list)->clist, TRUE)
#else
#define GuiListSetReorderable(list) \
	g_object_set((list)->view, "reorderable", TRUE, NULL)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSetRowData(list, data) \
	gtk_clist_set_row_data((list)->clist, (list)->row, (data))
#else
#define GuiListSetRowData(list, data) \
	gtk_list_store_set((list)->slist, &((list)->iter), \
				(list)->data_column, (data), -1)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSetRowHeight(list, height) \
	gtk_clist_set_row_height((list)->clist, (height))
#else
#define GuiListSetRowHeight(list, height) {;}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSetSelectionMode(list, mode) \
	GuiStoreSetSelectionMode((list)->clist, (mode))
#else
#define GuiListSetSelectionMode(list, mode) \
	GuiStoreSetSelectionMode((list)->selection, (mode))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSetText(list, colnr, str) \
	gtk_clist_set_text((list)->clist, (list)->row, (colnr), (str))
#else
#define GuiListSetText(list, colnr, str) \
	gtk_list_store_set((list)->slist, &((list)->iter), (colnr), (str), -1)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListUnselectRow(list) \
	gtk_clist_unselect_row((list)->clist, (list)->row, -1)
#else
#define GuiListUnselectRow(list) \
	gtk_tree_selection_unselect_iter((list)->selection, &((list)->iter))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSignalConnect(list, name, func, data) \
	GuiSignalConnect((list)->clist, (name), (func), (data))
#else
#define GuiListSignalConnect(list, name, func, data) \
	GuiSignalConnect((list)->view, (name), (func), (data))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSignalConnectResizeColumn(list, func, data) \
	GuiStoreSignalConnectResizeColumn((list)->clist, (func), (data))
#else
#define GuiListSignalConnectResizeColumn(list, colnr, func, data) \
	GuiStoreSignalConnectResizeColumn((list)->view, (colnr), (func), (data))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSignalConnectSelectedRow(list, func, data) \
	GuiListSignalConnect((list), "select-row", (func), (data))
#else
#define GuiListSignalConnectSelectedRow(list, func, data) \
	GuiSignalConnect((list)->selection, "changed", (func), (data))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListSignalConnectUnselectedRow(list, func, data) \
	GuiListSignalConnect((list), "unselect-row", (func), (data))
#else
#define GuiListSignalConnectUnselectedRow(list, func, data) {;}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiListThaw(list) \
	GuiStoreThaw((list)->clist)
#else
#define GuiListThaw(list) \
	GuiStoreThaw((list)->slist, (list)->view)
#endif


/*
	*
	* -------------
	*  Tree Macros
	* -------------
	*
*/

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeCollapseRecursive(tree) \
	gtk_ctree_collapse_recursive((tree)->ctree, (tree)->node);
#else
#define GuiTreeCollapseRecursive(tree) \
{ \
	GtkTreePath *path; \
	GtkTreeModel *model = GTK_TREE_MODEL((tree)->stree); \
	path = gtk_tree_model_get_path(model, &(tree)->iter); \
	gtk_tree_view_collapse_row((tree)->view,  path); \
	gtk_tree_path_free(path); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeClear(tree) \
	gtk_clist_clear(GTK_CLIST((tree)->ctree))
#else
#define GuiTreeClear(tree) \
	gtk_tree_store_clear((tree)->stree)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeColumnPixtextNew(tree, textcol, height, pixcol, pixclose, pixopen) {;}
#else
#define GuiTreeColumnPixtextNew(tree, textcol, height, pixcol, pixclose, pixopen) \
{ \
	GtkCellRenderer   *renderer; \
	GtkTreeViewColumn *column; \
	GuiStoreColumnPixbufNew((height), (pixcol), column, renderer); \
	gtk_tree_view_column_add_attribute(column, renderer, \
				"pixbuf-expander-closed", (pixclose)); \
	gtk_tree_view_column_add_attribute(column, renderer, \
				"pixbuf-expander-open", (pixopen)); \
	GuiRendererTextNew(renderer, (height), 0.0); \
	GuiStoreColumnAppend((tree)->view, (column), (textcol), renderer, FALSE); \
	gtk_tree_view_set_expander_column((tree)->view, column); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeColumnSort(tree, colnr, func, data) \
{ \
	GuiStoreColumnSort(GTK_CLIST((tree)->ctree), (colnr), (func)); \
	gtk_ctree_sort_recursive((tree)->ctree, NULL); \
}
#else
#define GuiTreeColumnSort(tree, colnr, func, data) \
	GuiStoreColumnSort((tree)->stree, (colnr), (func), (data))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeColumnTextNew(tree, colnr, height, justify) {;}
#else
#define GuiTreeColumnTextNew(tree, colnr, height, justify) \
	GuiStoreColumnTextNew((tree)->view, (colnr), (height), (justify))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeColumnTitleActive(tree, colnr, active) \
	GuiStoreColumnTitleActive(GTK_CLIST((tree)->ctree), (colnr), (active))
#else
#define GuiTreeColumnTitleActive(tree, colnr, active) \
	GuiStoreColumnTitleActive((tree)->view, (colnr), (active))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeColumnTitlesPassive(tree) \
	GuiStoreColumnTitlesPassive(GTK_CLIST((tree)->ctree))
#else
#define GuiTreeColumnTitlesPassive(tree) \
	GuiStoreColumnTitlesPassive((tree)->view)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeColumnTitlesShow(tree) \
	GuiStoreColumnTitlesShow(GTK_CLIST((tree)->ctree))
#else
#define GuiTreeColumnTitlesShow(tree) \
	GuiStoreColumnTitlesShow((tree)->view)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeContainerAdd(tree, widget) \
	GuiStoreContainerAdd((widget), (tree)->ctree)
#else
#define GuiTreeContainerAdd(tree, widget) \
	GuiStoreContainerAdd((widget), (tree)->view)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeExpandRecursive(tree) \
	gtk_ctree_expand_recursive((tree)->ctree, (tree)->node);
#else
#define GuiTreeExpandRecursive(tree) \
{ \
	GtkTreePath *path; \
	GtkTreeModel *model = GTK_TREE_MODEL((tree)->stree); \
	path = gtk_tree_model_get_path(model, &(tree)->iter); \
	gtk_tree_view_expand_row((tree)->view,  path,  TRUE); \
	gtk_tree_path_free(path); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeGetExpanded(tree, is_expanded) \
	(is_expanded) = GTK_CTREE_ROW((tree)->node)->expanded;
#else
#define GuiTreeGetExpanded(tree, is_expanded) \
{ \
	GtkTreePath *path; \
	GtkTreeModel *model = GTK_TREE_MODEL((tree)->stree); \
	path = gtk_tree_model_get_path(model, &(tree)->iter); \
	(is_expanded) = gtk_tree_view_row_expanded((tree)->view, path); \
	gtk_tree_path_free(path); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeFreeze(tree) \
	GuiStoreFreeze(GTK_CLIST((tree)->ctree))
#else
#define GuiTreeFreeze(tree) \
	GuiStoreFreeze((tree)->stree, (tree)->view)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeGetLevel(tree) \
	(GTK_CTREE_ROW((tree)->node)->level)
#else
#define GuiTreeGetLevel(tree) \
	gtk_tree_store_iter_depth((tree)->stree, &(tree)->iter)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeGetParent(tree, parent, child) \
	(parent) = (GTK_CTREE_ROW(child)->parent)
#else
#define GuiTreeGetParent(tree, parent, child) \
	gtk_tree_model_iter_parent((tree)->stree, &(parent), &(child))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeGetRowData(tree, data) \
	(data) = gtk_ctree_node_get_row_data((tree)->ctree, (tree)->node)
#else
#define GuiTreeGetRowData(tree, data) \
	gtk_tree_model_get(GTK_TREE_MODEL((tree)->stree), &((tree)->iter), \
				(tree)->data_column, &(data), -1)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeInit(tree, columns, icon_colnr) \
{ \
	(tree)->node = NULL; \
	(tree)->ctree = (GtkCTree *) gtk_ctree_new((columns), (icon_colnr)); \
}
#else
#define GuiTreeInit(tree, colnr, icon_colnr) \
	GuiStoreInit((tree)->stree, (tree)->view, \
			(tree)->selection, (tree)->data_column, (colnr))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSelectFirstRow(tree) \
	GuiStoreSelectFirstRow(GTK_CLIST((tree)->ctree))
#else
#define GuiTreeSelectFirstRow(tree) \
	GuiStoreSelectFirstRow((tree)->stree, (tree)->selection)
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSetColumnAlignment(clist, colnr, alignment) {;}
#else
#define GuiTreeSetColumnAlignment(tree, colnr, alignment) \
	GuiStoreSetColumnAlignment((tree)->view, (colnr), (alignment))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSetColumnAutoResize(tree, colnr, autoresize) \
	GuiStoreSetColumnAutoResize(GTK_CLIST((tree)->ctree), (colnr), (autoresize))
#else
#define GuiTreeSetColumnAutoResize(tree, colnr, autoresize) \
	GuiStoreSetColumnAutoResize((tree)->view, (colnr), (autoresize))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSetColumnResizable(tree, colnr, resizable) \
	GuiStoreSetColumnResizable(GTK_CLIST((tree)->ctree), (colnr), (resizable))
#else
#define GuiTreeSetColumnResizable(tree, colnr, resizable) \
	GuiStoreSetColumnResizable((tree)->view, (colnr), (resizable))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSetColumnTitle(tree, colnr, title) \
	gtk_clist_set_column_title(GTK_CLIST((tree)->ctree), (colnr), (title))
#else
#define GuiTreeSetColumnTitle(tree, colnr, title) \
{ \
	GtkTreeViewColumn* column; \
	column = gtk_tree_view_get_column((tree)->view, (colnr)); \
	gtk_tree_view_column_set_title(column, (title)); \
}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSetColumnVisiblility(tree, colnr, visible) \
	GuiStoreSetColumnVisiblility(GTK_CLIST((tree)->ctree), (colnr), (visible))
#else
#define GuiTreeSetColumnVisiblility(tree, colnr, visible) \
	GuiStoreSetColumnVisiblility((tree)->view, (colnr), (visible))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSetColumnWidget(tree, colnr, widget) \
	GuiStoreSetColumnWidget(GTK_CLIST((tree)->ctree), (colnr), (widget))
#else
#define GuiTreeSetColumnWidget(tree, colnr, widget) \
	GuiStoreSetColumnWidget((tree)->view, (colnr), (widget))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSetColumnWidth(tree, colnr, width) \
	GuiStoreSetColumnWidth(GTK_CLIST((tree)->ctree), (colnr), (width))
#else
#define GuiTreeSetColumnWidth(tree, colnr, width) \
	GuiStoreSetColumnWidth((tree)->view, (colnr), (width))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSetRowHeight(tree, height) \
	gtk_clist_set_row_height(GTK_CLIST((tree)->ctree), (height))
#else
#define GuiTreeSetRowHeight(tree, height) {;}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSetSelectionMode(tree, mode) \
	GuiStoreSetSelectionMode(GTK_CLIST((tree)->ctree), (mode))
#else
#define GuiTreeSetSelectionMode(tree, mode) \
	GuiStoreSetSelectionMode((tree)->selection, (mode))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSignalConnect(tree, name, func, data) \
	GuiSignalConnect((tree)->ctree, (name), (func), (data))
#else
#define GuiTreeSignalConnect(tree, name, func, data) \
	GuiSignalConnect((tree)->view, (name), (func), (data))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSignalConnectAfter(tree, name, func, data) \
	GuiSignalConnectAfter((tree)->ctree, (name), (func), (data))
#else
#define GuiTreeSignalConnectAfter(tree, name, func, data) \
	GuiSignalConnectAfter((tree)->view, (name), (func), (data))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSignalConnectCollapse(tree, func, data) \
	GuiTreeSignalConnect((tree), "tree-collapse", (func), (data))
#else
#define GuiTreeSignalConnectCollapse(tree, func, data) \
	GuiTreeSignalConnect((tree), "row-collapsed", (func), (data))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSignalConnectAfterCollapse(tree, func, data) \
	GuiTreeSignalConnectAfter((tree), "tree-collapse", (func), (data))
#else
#define GuiTreeSignalConnectAfterCollapse(tree, func, data) \
	GuiTreeSignalConnectAfter((tree), "row-collapsed", (func), (data))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSignalConnectExpand(tree, func, data) \
	GuiTreeSignalConnect((tree), "tree-expand", (func), (data))
#else
#define GuiTreeSignalConnectExpand(tree, func, data) \
	GuiTreeSignalConnect((tree), "row-expanded", (func), (data))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSignalConnectAfterExpand(tree, func, data) \
	GuiTreeSignalConnectAfter((tree), "tree-expand", (func), (data))
#else
#define GuiTreeSignalConnectAfterExpand(tree, func, data) \
	GuiTreeSignalConnectAfter((tree), "row-expanded", (func), (data))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSignalConnectResizeColumn(tree, func, data) \
	GuiStoreSignalConnectResizeColumn(GTK_CLIST((tree)->ctree), (func), (data))
#else
#define GuiTreeSignalConnectResizeColumn(tree, colnr, func, data) \
	GuiStoreSignalConnectResizeColumn((tree)->view, (colnr), (func), (data))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSignalConnectSelectedRow(tree, func, data) \
	GuiTreeSignalConnect((tree), "tree-select-row", (func), (data))
#else
#define GuiTreeSignalConnectSelectedRow(tree, func, data) \
	GuiSignalConnect((tree)->selection, "changed", (func), (data))
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeSignalConnectUnselectedRow(tree, func, data) \
	GuiTreeSignalConnect((tree), "tree-unselect-row", (func), (data))
#else
#define GuiTreeSignalConnectUnselectedRow(tree, func, data) {;}
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
#define GuiTreeThaw(tree) \
	GuiStoreThaw(GTK_CLIST((tree)->ctree))
#else
#define GuiTreeThaw(tree) \
	GuiStoreThaw((tree)->stree, (tree)->view)
#endif


/*
	*
	* ---------------
	*  Miscellaneous
	* ---------------
	*
*/

#if GTK_MAJOR_VERSION == 1
#define GuiButtonBoxSetSpacing(widget, spacing) \
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(widget), (spacing))
#else
#define GuiButtonBoxSetSpacing(widget, spacing) \
	gtk_box_set_spacing(GTK_BOX(widget), (spacing))
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiEditableGetSelectionStart(editable, start) \
	(*(start) = (editable)->selection_start_pos, (editable)->has_selection)
#else
#define GuiEditableGetSelectionStart(editable, start) \
	gtk_editable_get_selection_bounds((editable), (start), NULL)
#endif

#if GTK_MAJOR_VERSION == 1
#define GUI_PRIORITY_REDRAW	GTK_PRIORITY_REDRAW
#define GuiIdleAddPriority(priority, func, data) \
	gtk_idle_add_priority((priority), (GtkFunction)(func), (data))
#else
#define GUI_PRIORITY_REDRAW     (G_PRIORITY_HIGH_IDLE + 20)
#define GuiIdleAddPriority(priority, func, data) \
	g_idle_add_full((priority), (GSourceFunc)(func), (data), NULL)
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiIdleRemove(handler_id) \
	gtk_idle_remove(handler_id)
#else
#define GuiIdleRemove(handler_id) \
	g_source_remove(handler_id)
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiMenuAppend(menu, child) \
	gtk_menu_append(GTK_MENU(menu), (child))
#else
#define GuiMenuAppend(menu, child) \
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), (child))
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiMenuBarAppend(menu, child) \
	gtk_menu_bar_append(GTK_MENU_BAR(menu), (child))
#else
#define GuiMenuBarAppend(menu, child) \
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), (child))
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiMenuBarDisableShadow(menu) \
	gtk_menu_bar_set_shadow_type(GTK_MENU_BAR(menu), GTK_SHADOW_NONE)
#else
#define GuiMenuBarDisableShadow(menu) \
{ \
	gtk_rc_parse_string( \
		"style \"mozcache-menubar-style\" {GtkMenuBar::shadow-type = none}" \
		"class \"GtkMenuBar\" style : highest \"mozcache-menubar-style\" "); \
	gtk_widget_set_name((menu), "mozcache-menubar-style"); \
}
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiMenuItemSetRightJustified(menu_item, right_justified) \
	gtk_menu_item_right_justify(menu_item)
#else
#define GuiMenuItemSetRightJustified(menu_item, right_justified) \
	gtk_menu_item_set_right_justified((menu_item), (right_justified))
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiObjectGetUserData(object) \
	gtk_object_get_user_data(GTK_OBJECT(object))
#else
#define GuiObjectGetUserData(object) \
	g_object_get_data(G_OBJECT(object), "user_data")
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiObjectSetUserData(object, data) \
	gtk_object_set_user_data(GTK_OBJECT(object), (gpointer) (data))
#else
#define GuiObjectSetUserData(object, data) \
	g_object_set_data(G_OBJECT(object), "user_data", (gpointer) (data))
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiOptionMenuGetIndex(menu) \
	(gint) GuiObjectGetUserData(GTK_OPTION_MENU(menu)->menu_item)
#else
#define GuiOptionMenuGetIndex(menu) \
	gtk_option_menu_get_history(GTK_OPTION_MENU(menu))
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiOptionMenuSetIndex(menu, index) \
	GuiObjectSetUserData((menu), (index))
#else
#define GuiOptionMenuSetIndex(menu, index) {;}
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiProgressBarSetValue(bar, val) \
	gtk_progress_bar_update((bar), (gfloat) (val))
#else
#define GuiProgressBarSetValue(bar, val) \
	gtk_progress_bar_set_fraction((bar), (gdouble) (val))
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiRadioButtonGetGroup(radio_button) \
	gtk_radio_button_group(radio_button)
#else
#define GuiRadioButtonGetGroup(radio_button) \
	gtk_radio_button_get_group(radio_button)
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiTimeoutAdd(interval, func, data) \
	gtk_timeout_add((interval), (GtkFunction)(func), (data))
#else
#define GuiTimeoutAdd(interval, func, data) \
	g_timeout_add((interval), (GSourceFunc)(func), (data))
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiTimeoutRemove(handler_id) \
	gtk_timeout_remove(handler_id)
#else
#define GuiTimeoutRemove(handler_id) \
	g_source_remove(handler_id)
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiWidgetSetSizeRequest(widget, width, height) \
	gtk_widget_set_usize((widget), (width), (height))
#else
#define GuiWidgetSetSizeRequest(widget, width, height) \
	gtk_widget_set_size_request((widget), (width), (height))
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiWindowMove(wnd, x, y) \
	gtk_window_reposition((wnd), (x), (y))
#else
#define GuiWindowMove(wnd, x, y) \
	gtk_window_move((wnd), (x), (y))
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiWindowPresent(wnd) \
{ \
	if (GTK_WIDGET_VISIBLE(wnd)) \
	{ \
		gdk_window_show(wnd->window); \
	} \
	else \
	{ \
		gtk_widget_show(wnd); \
	} \
}
#else
#define GuiWindowPresent(wnd) \
	gtk_window_present(GTK_WINDOW(wnd))
#endif

#if GTK_MAJOR_VERSION == 1
#define GuiWindowSetResizable(wnd, resizable) \
	gtk_window_set_policy((wnd), FALSE, (resizable), !(resizable))
#else
#define GuiWindowSetResizable(wnd, resizable) \
	gtk_window_set_resizable((wnd), (resizable))
#endif

#endif /* _gui_gtk_h_ */
