/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		modified 2005 ... 2008 by Harald Foerster		   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifdef HAVE_FNMATCH
#include <fnmatch.h>
#else
#include "fnmatch.h"
#endif

#include <stdio.h>
#include <string.h>

#include "charconv.h"
#include "gui.h"
#include "gprop.h"

/*
#include <gtk/gtk.h>
#include "gui-gtk.h"
#include "nls.h"
#include "nscache.h"
*/


#ifdef CONFIG_BERKELEY_DB
#include "pixmaps/ns.xpm"
#include "pixmaps/ns6.xpm"
#endif

#include "pixmaps/mozilla.xpm"

#ifdef HAVE_MSIE
#include "pixmaps/ie.xpm"
#endif

#ifdef CONFIG_COLUMN_BUTTONS
#include "pixmaps/stock_collapse.xpm"
#include "pixmaps/stock_expand.xpm"
#endif

#include "pixmaps/nscache_logo.xpm"
#include "pixmaps/folder.xpm"
#include "pixmaps/folder_open.xpm"

#include "icons/audio.xpm"
#include "icons/binary.xpm"
#include "icons/html.xpm"
#include "icons/image.xpm"
#include "icons/text.xpm"
#include "icons/unknown.xpm"
#include "icons/video.xpm"


#if GTK_MAJOR_VERSION == 1

#include "pixmaps/stock_append.xpm"
#include "pixmaps/stock_close.xpm"
#include "pixmaps/stock_delete.xpm"
#include "pixmaps/stock_modify.xpm"
#include "pixmaps/stock_ok.xpm"
#include "pixmaps/stock_open.xpm"
#include "pixmaps/stock_search.xpm"
#include "pixmaps/stock_stop.xpm"

#include "pixmaps/stock_dialog_error.xpm"
#include "pixmaps/stock_dialog_info.xpm"
#include "pixmaps/stock_dialog_warning.xpm"

#else /* GTK_MAJOR_VERSION > 1 */

#include "pixmaps/stock_append.xpm"

#define stock_close_xpm		NULL
#define stock_delete_xpm	NULL
#define stock_modify_xpm	NULL
#define stock_ok_xpm		NULL
#define stock_open_xpm		NULL
#define stock_search_xpm	NULL
#define stock_stop_xpm		NULL

#define stock_dialog_error_xpm	NULL
#define stock_dialog_info_xpm	NULL

static gchar* button_stock_id[] =
{
	NULL,			/* stock_append.xpm */
	GTK_STOCK_CLOSE,	/* stock_close.xpm */
	GTK_STOCK_DELETE,	/* stock_delete.xpm */
	GTK_STOCK_CONVERT,	/* stock_modify.xpm */
	GTK_STOCK_OK,		/* stock_ok.xpm */
	GTK_STOCK_OPEN,		/* stock_open.xpm */
	GTK_STOCK_FIND,		/* stock_search.xpm */
	GTK_STOCK_STOP,		/* stock_stop.xpm */
	GTK_STOCK_CANCEL	/* stock_close.xpm */
};

static gchar* const dialog_stock_id[] =
{
	NULL,			/* nscache_logo.xpm */
	GTK_STOCK_DIALOG_ERROR,	/* stock_dialog_error.xpm */
	GTK_STOCK_DIALOG_INFO,	/* stock_dialog_info.xpm */
	GTK_STOCK_DIALOG_WARNING /* stock_dialog_warning.xpm */
};

#endif /* #if GTK_MAJOR_VERSION == 1 .. #else */

#ifdef CONFIG_GTKCLIST_GTKCTREE

typedef struct
{
	GuiTreeStoreRecursiveFunc	func;
	gpointer			userdata;
	GuiTreeStore			tree;

} RecursiveCallbackData;

#else /* ! CONFIG_GTKCLIST_GTKCTREE */

typedef struct
{
	GCompareFunc	func;
	gconstpointer	userdata;
	gpointer	rowdata;
	gint		column;

} CompareRowDataCallbackData;

typedef struct
{
	GuiListStoreForeachFunc	func;
	gpointer		userdata;
	GuiListStore		list;

} ForeachCallbackData;

typedef struct
{
	GFunc		func;
	gpointer	userdata;
	gint		column;

} ForeachRowDataCallbackData;

typedef struct
{
	GtkTreeIter	*iter;
	gconstpointer	userdata;
	gint		column;

} IterByRowDataCallbackData;

#endif /* #ifdef CONFIG_GTKCLIST_GTKCTREE .. #else */

static char **browser_xpm[] =
{
#ifdef CONFIG_BERKELEY_DB
	ns_xpm,
	ns6_xpm,
#endif
	mozilla_xpm,

#ifdef HAVE_MSIE
	ie_xpm,
#endif
};

static char **dialog_xpm[] =
{
	nscache_logo_xpm,

#if GTK_MAJOR_VERSION == 1
	stock_dialog_error_xpm,
	stock_dialog_info_xpm,
	stock_dialog_warning_xpm,
#endif
};

static char **folders_xpm[] =
{
	folder_xpm,
	folder_open_xpm
};

static char **button_xpm[] =
{
	stock_append_xpm,
	stock_close_xpm,
	stock_delete_xpm,
	stock_modify_xpm,
	stock_ok_xpm,
	stock_open_xpm,
	stock_search_xpm,
	stock_stop_xpm,

#ifdef CONFIG_COLUMN_BUTTONS
	stock_collapse_xpm,
	stock_expand_xpm,
#endif

	NULL
};

static const gchar* const button_stock_str[] =
{
	gettext_nop("Append"),
	gettext_nop("Close"),
	gettext_nop("Delete"),
	gettext_nop("Modify"),
	gettext_nop("Ok"),
	gettext_nop("Browse ..."),
	gettext_nop("Search"),
	gettext_nop("Stop"),

#ifdef CONFIG_COLUMN_BUTTONS
	NULL,
	NULL,
#endif

	gettext_nop("Cancel")
};

static char **mime_xpm[] =
{
	html_xpm,
	text_xpm,
	image_xpm,
	audio_xpm,
	video_xpm,
	binary_xpm,
	unknown_xpm
};

static const gchar* const mime_stock_str[] =
{
	"text/html",
	"text/*",
	"image/*",
	"audio/*",
	"video/*",
	"*/*"
};

#if GTK_MAJOR_VERSION == 1
static PixmapData button_icon[kNumberOfIconButton];
static PixmapData browser_icon[NSCACHE_RT_LAST + 1];
static PixmapData dialog_icon[kNumberOfIconDialog];
#else
static PixbufData browser_icon[NSCACHE_RT_LAST + 1];
static PixbufData dialog_icon[kNumberOfIconDialog];
#endif

static PixbufIcon mime_icon[kNumberOfIconMime];

PixbufIcon folder_icon[kNumberOfIconFolder];

/* list of windows and dialogs */
static GSList *guitl_window_toplevel_slist = NULL;


#ifdef HAVE_ICONV
gchar *guitl_convert_window_title_if_enabled(const gchar *title)
{
	gint active;

	if (gprop_get_bool(kPropBoolOpt_WM_UTF8, &active) == FALSE || active)
	{
		gchar *str;

		str = charconv(title, charconv_utf8_str,
					charconv_locale_str, NULL);
		if (str)
		{
			return str;
		}
	}

	return (gchar *) title;
}
#endif

void guitl_window_set_title_gettext(GtkWidget *window, const gchar *title)
{
	gchar* str;

	title = gettext(title);
	str = guitl_convert_window_title_if_enabled(title);
	gtk_window_set_title(GTK_WINDOW(window), str);

	if (str != title)
	{
		g_free(str);
	}
}

void guitl_window_toplevel_destroy_all(void)
{
	GSList *slist = guitl_window_toplevel_slist;
	guitl_window_toplevel_slist  = NULL;
	g_slist_foreach(slist, (GFunc) gtk_widget_destroy, NULL);
	/* g_slist_free(slist); */
}

static void guitl_window_toplevel_remove(GtkWidget *window, GSList **slist_wtoplevel)
{
	*slist_wtoplevel = g_slist_remove(*slist_wtoplevel, window);
}

static GtkWidget *guitl_window_toplevel_add(GtkWidget *window)
{
	GuiSignalConnect(window, "destroy",
		guitl_window_toplevel_remove, &guitl_window_toplevel_slist);

	guitl_window_toplevel_slist =
		g_slist_prepend(guitl_window_toplevel_slist, window);

	return window;
}

GtkWidget *guitl_window_new_gettext(const gchar *title, GtkWidget *child, gint border)
{
	GtkWidget *window;

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	guitl_window_set_title_gettext(window, title);
	gtk_container_add(GTK_CONTAINER(window), child);

	if (border > 0)
	{
		gtk_container_set_border_width(GTK_CONTAINER(child), border);
	}

	return guitl_window_toplevel_add(window);
}

GtkWidget *guitl_dialog_new_gettext(const gchar *title, GtkWidget *child, gint border)
{
	GtkWidget *dialog;

	dialog = gtk_dialog_new();
	guitl_window_set_title_gettext(dialog, title);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), child);

	if (border > 0)
	{
		gtk_container_set_border_width(GTK_CONTAINER(child), border);
	}

	return guitl_window_toplevel_add(dialog);
}

GtkWidget *guitl_file_selection_new_gettext(const gchar *title)
{
	gchar		*str;
	GtkFileSelection *fs;
	GtkWidget	*widget;

	title = gettext(title);
	str = guitl_convert_window_title_if_enabled(title);
	widget = gtk_file_selection_new(str);

	if(str != title)
	{
		g_free(str);
	}

	fs = GTK_FILE_SELECTION(widget);
	gtk_file_selection_hide_fileop_buttons(fs);
	GuiSignalConnectSwapped(fs->cancel_button, "clicked", gtk_widget_destroy, fs);

	return guitl_window_toplevel_add(widget);
}

static void guitl_dialog_modal_destroy(GtkWidget *w, GtkWidget **menu)
{
	if (*menu)
	{
		gtk_widget_set_state(*menu, GTK_STATE_NORMAL);
	}
}

void guitl_dialog_set_modal(GtkWidget *dialog, GtkWidget **menu)
{
	gtk_widget_set_state(*menu, GTK_STATE_PRELIGHT);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);

	GuiSignalConnect(dialog, "destroy", guitl_dialog_modal_destroy, menu);
}

GtkWidget *guitl_frame_new_add_child_gettext(const gchar *title, GtkWidget *child)
{
	gchar		*str;
	GtkWidget	*frame;

	str = CHARCONV_UTF8_GETTEXT(title);
	frame = gtk_frame_new(str);
	CHARCONV_UTF8_DESTROY(str);

	gtk_container_add(GTK_CONTAINER(frame), child);

	return frame;
}

GtkWidget *guitl_check_button_new_gettext(const gchar *label)
{
	gchar		*str;
	GtkWidget	*button;

	str = CHARCONV_UTF8_GETTEXT(label);
	button = gtk_check_button_new_with_label(str);
	CHARCONV_UTF8_DESTROY(str);

	return button;
}

GtkWidget *guitl_check_menu_item_new_gettext(const gchar *label)
{
	gchar		*str;
	GtkWidget	*mi;

	str = CHARCONV_UTF8_GETTEXT(label);
	mi = gtk_check_menu_item_new_with_label(str);
	CHARCONV_UTF8_DESTROY(str);

	return mi;
}

GtkWidget *guitl_label_new_gettext(const gchar *str)
{
	gchar		*s;
	GtkWidget	*label;

	s = CHARCONV_UTF8_GETTEXT(str);
	label = gtk_label_new(s);
	CHARCONV_UTF8_DESTROY(s);

	return label;
}

GtkWidget *guitl_menu_item_new_gettext(const gchar *label)
{
	gchar		*str;
	GtkWidget	*mi;

	str = CHARCONV_UTF8_GETTEXT(label);
	mi = gtk_menu_item_new_with_label(str);
	CHARCONV_UTF8_DESTROY(str);

	return mi;
}

GtkStyle *guitl_rc_get_style(GtkWidget *widget)
{
	GtkStyle *style;

	style = gtk_rc_get_style(widget);

	if (style)
	{
		return style;
	}

	return gtk_widget_get_default_style();
}

static GtkWidget *guitl_tab_add_widget(GtkTable *table, GtkWidget *widget, gchar *str, guint col, guint row)
{
	GtkWidget *label;

	label = guitl_label_new_gettext(str);

	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_table_attach(table, label, col, col + 1, row, row + 1,
					GTK_FILL | GTK_SHRINK, GTK_FILL, 4, 4);
	gtk_table_attach(table, widget, col + 1, col + 2, row, row + 1,
					GTK_FILL | GTK_EXPAND, GTK_FILL, 4, 4);
	return widget;

} /* static GtkWidget *guitl_tab_add_widget(GtkTable*, GtkWidget*, gchar*, guint, guint) */

GtkEntry *guitl_tab_add_entry(GtkTable *table, gchar *str, guint col, guint row)
{
	GtkWidget *entry;

	entry = gtk_entry_new();
	entry = guitl_tab_add_widget(table, entry, str, col, row);

	return GTK_ENTRY(entry);

} /* GtkEntry *guitl_tab_add_entry(GtkTable*, gchar*, guint, guint) */

GtkCombo *guitl_tab_add_combo(GtkTable *table, gchar *str,
					GList *entries, guint col, guint row)
{
	GtkWidget *combo;

	combo = gtk_combo_new();
	gtk_combo_set_popdown_strings(GTK_COMBO(combo), entries);
	combo = guitl_tab_add_widget(table, combo, str, col, row);

	return GTK_COMBO(combo);

} /* GtkCombo *guitl_tab_add_combo(GtkTable*, gchar*, GList*, guint, guint) */

#if GTK_MAJOR_VERSION == 1

void guitl_create_icons(GtkWidget *widget)
{
	int		idx;
	GdkWindow	*wnd;

	wnd = GTK_WIDGET(widget)->window;

	/* browser icons */

	idx = NSCACHE_RT_LAST;

	do
	{
		browser_icon[idx].pixmap =
			gdk_pixmap_create_from_xpm_d(wnd,
				&browser_icon[idx].mask, NULL,
						browser_xpm[idx]);
	}
	while (--idx >= NSCACHE_RT_FIRST);

	/* button icons */

#ifdef CONFIG_COLUMN_BUTTONS
	idx = kIconButtonExpand;
#else
	idx = kIconButtonStop;
#endif

	do
	{
		button_icon[idx].pixmap =
			gdk_pixmap_create_from_xpm_d(wnd,
				&button_icon[idx].mask, NULL, button_xpm[idx]);
	}
	while (--idx >= 0);

	button_icon[kIconButtonCancel] = button_icon[kIconButtonClose];

	/* mime icons */

	idx = kNumberOfIconMime - 1;

	do
	{
		mime_icon[idx].pixmap =
			gdk_pixmap_create_from_xpm_d(wnd,
				&mime_icon[idx].mask, NULL, mime_xpm[idx]);
	}
	while (--idx >= 0);

	/* misc icons */

	idx = kNumberOfIconDialog - 1;

	do
	{
		dialog_icon[idx].pixmap =
			gdk_pixmap_create_from_xpm_d(wnd,
				&dialog_icon[idx].mask, NULL, dialog_xpm[idx]);
	}
	while (--idx >= 0);

	/* folder icons */

	idx = kNumberOfIconFolder - 1;

	do
	{
		folder_icon[idx].pixmap =
			gdk_pixmap_create_from_xpm_d(wnd,
				&folder_icon[idx].mask, NULL, folders_xpm[idx]);
	}
	while (--idx >= 0);

} /* void guitl_create_icons(GtkWidget *widget) */

#else /* GTK_MAJOR_VERSION > 1 */

static void guitl_create_button_icons(GtkWidget *widget)
{
	static GtkStockItem item[kNumberOfIconButton] = { {0} };

	int		idx;
	GtkIconFactory	*factory;
	GtkStyle	*style;

	style   = gtk_widget_get_style(widget);
	factory = gtk_icon_factory_new();
	idx     = 0;

	do
	{
		gchar		*str;
		GtkIconSet	*icon_set;

		str = (gchar *) button_stock_id[idx];

		if (str)
		{
			icon_set = gtk_style_lookup_icon_set(style, str);
		}

		else
		{
			GdkPixbuf *pixbuf;

			pixbuf = gdk_pixbuf_new_from_xpm_data((const char **) button_xpm[idx]);
			icon_set = gtk_icon_set_new_from_pixbuf(pixbuf);
			g_object_unref(pixbuf);
		}

		str = g_strconcat("mozcache", str, NULL);
		item[idx].stock_id   = str;
		button_stock_id[idx] = str;
		gtk_icon_factory_add(factory, str, icon_set);

		item[idx].label = CHARCONV_UTF8_GETTEXT(button_stock_str[idx]);
	}
	while (++idx < kNumberOfIconButton);

	gtk_icon_factory_add_default(factory);
	gtk_stock_add_static(item, kNumberOfIconButton);

} /* static void guitl_create_button_icons(GtkWidget *widget) */

void guitl_create_icons(GtkWidget *widget)
{
	int idx;

	/* button icons */

	guitl_create_button_icons(widget);

	/* browser icons */

	idx = NSCACHE_RT_LAST;

	do
	{
		browser_icon[idx].pixbuf =
			gdk_pixbuf_new_from_xpm_data((const char **) browser_xpm[idx]);
	}
	while (--idx >= NSCACHE_RT_FIRST);

	/* mime icons */

	idx = kNumberOfIconMime - 1;

	do
	{
#ifdef CONFIG_GTKCLIST_GTKCTREE
		mime_icon[idx].pixmap =
			gdk_pixmap_create_from_xpm_d(GTK_WIDGET(widget)->window,
				&mime_icon[idx].mask, NULL, mime_xpm[idx]);
#else
		mime_icon[idx].pixbuf =
			gdk_pixbuf_new_from_xpm_data((const char **) mime_xpm[idx]);
#endif
	}
	while (--idx >= 0);

	/* misc icons */

	idx = kNumberOfIconDialog - 1;

	do
	{
		dialog_icon[idx].pixbuf =
			gdk_pixbuf_new_from_xpm_data((const char **) dialog_xpm[idx]);
	}
	while (--idx >= 0);

	/* folder icons */

	idx = kNumberOfIconFolder - 1;

	do
	{
#ifdef CONFIG_GTKCLIST_GTKCTREE
		folder_icon[idx].pixmap =
			gdk_pixmap_create_from_xpm_d(GTK_WIDGET(widget)->window,
				&folder_icon[idx].mask, NULL, folders_xpm[idx]);
#else
		folder_icon[idx].pixbuf =
			gdk_pixbuf_new_from_xpm_data((const char **) folders_xpm[idx]);
#endif
	}
	while (--idx >= 0);

} /* void guitl_create_icons_pixbuf(GtkWidget *widget) */

#endif /* #if GTK_MAJOR_VERSION == 1 .. #else */

#if GTK_MAJOR_VERSION == 1

GtkWidget *guitl_get_icon_button(gint index)
{
	GtkWidget *btn;

	gchar *str = (gchar*) button_stock_str[index];

	if(str)
	{
		str = gettext(str);
	}

	if (button_icon[index].pixmap)
	{
		GtkWidget *pixmap;
		GtkWidget *box;
		GtkWidget *label;

		btn = gtk_button_new();

		pixmap = gtk_pixmap_new(button_icon[index].pixmap,
						button_icon[index].mask);

		box = gtk_hbox_new(FALSE, 1);
		gtk_container_add(GTK_CONTAINER(btn), box);

		gtk_container_add(GTK_CONTAINER(box), pixmap);
		gtk_misc_set_alignment(GTK_MISC(pixmap), 1.0, 0.5);

		label = gtk_label_new(str);
		gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
		gtk_container_add(GTK_CONTAINER(box), label);
	}

	else
	{
		btn = gtk_button_new_with_label(str);
	}

	return btn;

} /* GtkWidget *guitl_get_icon_button(gint index) */

#else /* GTK_MAJOR_VERSION > 1 */

GtkWidget *guitl_get_icon_button(gint index)
{
	return gtk_button_new_from_stock(button_stock_id[index]);
}

#endif /* #if GTK_MAJOR_VERSION == 1 .. #else */

PixbufIcon *guitl_get_icon_mime(const char *mimetype)
{
	if (mimetype)
	{
		int index = 0;

		do
		{
			if (fnmatch(mime_stock_str[index], mimetype, 0) == 0)
			{
				return &mime_icon[index];
			}
		}
		while (++index < kIconMimeUnknown);
	}

	return &mime_icon[kIconMimeUnknown];

} /* PixbufIcon *guitl_get_icon_mime(const char *mimetype) */

GtkWidget *guitl_get_icon_menu(gint index)
{
	GtkWidget *mi, *pbox, *label, *image;

	mi = gtk_menu_item_new();

	pbox = gtk_hbox_new(FALSE, 1);
	gtk_container_add(GTK_CONTAINER(mi), pbox);

#if GTK_MAJOR_VERSION == 1
	image = gtk_pixmap_new(browser_icon[index].pixmap,
					browser_icon[index].mask);
#else
	image = gtk_image_new_from_pixbuf(browser_icon[index].pixbuf);
#endif

	gtk_box_pack_start(GTK_BOX(pbox), image, FALSE, FALSE, 2);

	label = guitl_label_new_gettext(NSC_GET_BROWSER_NAME(index));
	gtk_box_pack_start(GTK_BOX(pbox), label, FALSE, FALSE, 2);

	gtk_widget_show_all(mi);

	return mi;

} /* GtkWidget *guitl_get_icon_menu(gint index) */

GtkWidget *guitl_get_icon_dialog(gint index)
{
#if GTK_MAJOR_VERSION == 1
	return gtk_pixmap_new(dialog_icon[index].pixmap,
					dialog_icon[index].mask);
#else
	if (dialog_stock_id[index] == NULL)
	{
		return gtk_image_new_from_pixbuf(dialog_icon[index]. pixbuf);
	}

	return gtk_image_new_from_stock(dialog_stock_id[index], GTK_ICON_SIZE_DIALOG);
#endif

} /* GtkWidget *guitl_get_icon_dialog(gint index) */

GtkWidget *guitl_hbutton_box_new(GtkWidget *parent, gint spacing, GtkButtonBoxStyle layout)
{
	GtkWidget *hbutton_box;

#if GTK_MAJOR_VERSION > 1

	if (GTK_IS_HBUTTON_BOX(parent))
	{
		hbutton_box = parent;
	}
	else
#endif
	{
		hbutton_box = gtk_hbutton_box_new();

		if (GTK_IS_VBOX(parent))
		{
			gtk_box_pack_start(GTK_BOX(parent), hbutton_box, FALSE, FALSE, 0);
		}

		else
		{
			gtk_container_add(GTK_CONTAINER(parent), hbutton_box);
		}
	}

	GuiButtonBoxSetSpacing(hbutton_box, spacing);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbutton_box), layout);

	return hbutton_box;
}

GtkWidget *guitl_button_box_add_icon_button(GtkWidget *button_box, gint icon_index)
{
	GtkWidget *button;

	button = guitl_get_icon_button(icon_index);
	gtk_container_add(GTK_CONTAINER(button_box), button);
	gtk_container_set_border_width(GTK_CONTAINER(button), 2);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

	return button;
}

#ifdef CONFIG_GTKCLIST_GTKCTREE

static void guitl_ctree_recursive_callback(GtkCTree *ctree,
					GtkCTreeNode *node, gpointer userdata)
{
	gpointer rowdata;

	RecursiveCallbackData *data = userdata;

	data->tree.node = node;
	rowdata = gtk_ctree_node_get_row_data(ctree, node);

	(*data->func)(&(data->tree), rowdata, data->userdata);

} /* static void guitl_tree_recursive_callback(GtkCTree*, GtkCTreeNode*, gpointer) */

#else /* ! CONFIG_GTKCLIST_GTKCTREE */

static gboolean guitl_foreach_callback(GtkTreeModel *model,
				GtkTreePath *path, GtkTreeIter *iter, gpointer userdata)
{
	ForeachCallbackData *data = userdata;

	data->list.iter = *iter;

	(*(data->func))(&(data->list), data->userdata);

	return FALSE;

} /* static gboolean guitl_foreach_callback(GtkTreeModel*,
					GtkTreePath*, GtkTreeIter*, gpointer) */

static gboolean guitl_foreach_row_data_callback(GtkTreeModel *model,
				GtkTreePath *path, GtkTreeIter *iter, gpointer userdata)
{
	gpointer rowdata;

	ForeachRowDataCallbackData *data = userdata;

	gtk_tree_model_get(model, iter, data->column, &rowdata, -1);

	(*(data->func))(rowdata, data->userdata);

	return FALSE;

} /* static gboolean guitl_foreach_row_data_callback(GtkTreeModel*,
					GtkTreePath*, GtkTreeIter*, gpointer) */

static gboolean guitl_compare_row_data_callback(GtkTreeModel *model,
				GtkTreePath *path, GtkTreeIter *iter, gpointer userdata)
{
	gpointer rowdata;

	CompareRowDataCallbackData *data = userdata;

	gtk_tree_model_get(model, iter, data->column, &rowdata, -1);

	if ((*(data->func))(rowdata, data->userdata) == 0)
	{
		data->rowdata = rowdata;
		return TRUE;
	}

	return FALSE;

} /* static gboolean guitl_compare_row_data_callback(GtkTreeModel*,
					GtkTreePath*, GtkTreeIter*, gpointer) */

static gboolean guitl_iter_by_row_data_callback(GtkTreeModel *model,
				GtkTreePath *path, GtkTreeIter *iter, gpointer userdata)
{
	gpointer rowdata;

	IterByRowDataCallbackData *data = userdata;

	gtk_tree_model_get(model, iter, data->column, &rowdata, -1);

	if (rowdata == data->userdata)
	{
		 data->iter = g_memdup(iter, sizeof(GtkTreeIter));
		return TRUE;
	}

	return FALSE;

} /* static gboolean guitl_iter_by_row_data_callback(GtkTreeModel*,
					GtkTreePath*, GtkTreeIter*, gpointer) */

#endif /* #ifdef CONFIG_GTKCLIST_GTKCTREE .. #else */

void guitl_list_foreach(GuiListStore *list,
				GuiListStoreForeachFunc func, gpointer userdata)
{
#ifdef CONFIG_GTKCLIST_GTKCTREE

	GtkCList	*clist;
	GuiListStore	tmp_list;

	clist		= list->clist;
	tmp_list.clist	= clist;
	tmp_list.row  	= -1;

	while (++(tmp_list.row) < clist->rows)
	{
		(*func)(&tmp_list, userdata);
	}

#else /* ! CONFIG_GTKCLIST_GTKCTREE */

	ForeachCallbackData data;

	data.func	= func;
	data.userdata	= userdata;
	data.list	= *list;

	gtk_tree_model_foreach(GTK_TREE_MODEL(list->slist),
					guitl_foreach_callback, &data);

#endif /* #ifdef CONFIG_GTKCLIST_GTKCTREE .. #else */

} /* void guitl_list_foreach(GuiListStore*, GuiListStoreForeachFunc, gpointer) */

void guitl_list_foreach_row_data(GuiListStore *list, GFunc func, gpointer userdata)
{
#ifdef CONFIG_GTKCLIST_GTKCTREE

	gint     row;
	GtkCList *clist;

	row   = -1;
	clist = list->clist;

	while (++row < clist->rows)
	{
		gpointer rowdata = gtk_clist_get_row_data(clist, row);

		(*func)(rowdata, userdata);
	}

#else /* ! CONFIG_GTKCLIST_GTKCTREE */

	ForeachRowDataCallbackData data;

	data.func	= func;
	data.userdata	= userdata;
	data.column	= list->data_column;

	gtk_tree_model_foreach(GTK_TREE_MODEL(list->slist),
				guitl_foreach_row_data_callback, &data);

#endif /* #ifdef CONFIG_GTKCLIST_GTKCTREE .. #else */

} /* void guitl_list_foreach_row_data(GuiListStore*, GFunc, gpointer) */

gpointer guitl_list_compare_row_data(GuiListStore *list,
					GCompareFunc func, gconstpointer userdata)
{
#ifdef CONFIG_GTKCLIST_GTKCTREE

	gint     row;
	GtkCList *clist;

	row   = -1;
	clist = list->clist;

	while (++row < clist->rows)
	{
		gpointer rowdata = gtk_clist_get_row_data(clist, row);

		if ((*func)(rowdata, userdata) == 0)
		{
			return rowdata;
		}
	}

	return NULL;

#else /* ! CONFIG_GTKCLIST_GTKCTREE */

	CompareRowDataCallbackData data;

	data.func	= func;
	data.userdata	= userdata;
	data.rowdata	= NULL;
	data.column	= list->data_column;

	gtk_tree_model_foreach(GTK_TREE_MODEL(list->slist),
					guitl_compare_row_data_callback, &data);
	return data.rowdata;

#endif /* #ifdef CONFIG_GTKCLIST_GTKCTREE .. #else */

} /* gpointer guitl_list_compare_row_data(GuiListStore*, GCompareFunc, gconstpointer) */

#ifndef CONFIG_GTKCLIST_GTKCTREE

GtkTreeIter *guitl_iter_find_by_row_data(GtkTreeModel *model,
						gint colnr, gconstpointer userdata)
{
	IterByRowDataCallbackData data;

	data.iter	= NULL;
	data.userdata	= userdata;
	data.column	= colnr;

	gtk_tree_model_foreach(model, guitl_iter_by_row_data_callback, &data);

	return data.iter;

} /* GtkTreeIter *guitl_iter_find_by_row_data(GtkTreeModel*, gint, gconstpointer) */

#endif /* #ifndef CONFIG_GTKCLIST_GTKCTREE */

void guitl_tree_recursive(GuiTreeStore *tree, gboolean selected,
				GuiTreeStoreRecursiveFunc func, gpointer userdata)
{
#ifdef CONFIG_GTKCLIST_GTKCTREE

	RecursiveCallbackData data;

	data.func	= func;
	data.userdata	= userdata;
	data.tree.ctree	= tree->ctree;

	gtk_ctree_pre_recursive(tree->ctree, (selected == FALSE ? NULL : tree->node),
				GTK_CTREE_FUNC(guitl_ctree_recursive_callback), &data);

#else /* ! CONFIG_GTKCLIST_GTKCTREE */

	gint		index;
	GtkTreeModel	*model;
	GtkTreeIter	*parent;
	GuiTreeStore	tmp_tree;

	tmp_tree = *tree;
	model    = GTK_TREE_MODEL(tmp_tree.stree);
	index    = -1;

	if (selected == FALSE)
	{
		parent = NULL;
	}

	else
	{
		parent = &(tree->iter);
		goto get_rowdata;
	}

	while (gtk_tree_model_iter_nth_child(model, &(tmp_tree.iter), parent, ++index))
	{
		gpointer rowdata;

		if (gtk_tree_model_iter_has_child(model, &(tmp_tree.iter)))
		{
			guitl_tree_recursive(&tmp_tree, TRUE, func, userdata);
		}

		else
		{
get_rowdata:
			gtk_tree_model_get(model, &(tmp_tree.iter),
					tree->data_column, &rowdata, -1);

			(*func)(&tmp_tree, rowdata, userdata);
		}
	}

#endif /* #ifdef CONFIG_GTKCLIST_GTKCTREE .. #else */

} /* void guitl_tree_recursive(GuiTreeStore*, gboolean, GuiTreeStoreRecursiveFunc, gpointer) */

gint guitl_store_calculate_row_height(GtkWidget *list)
{
	gint		height;
	GtkStyle	*style;

	style = guitl_rc_get_style(list);

#if GTK_MAJOR_VERSION == 1

	if (style->font == NULL)
	{
		return GUI_LIST_ROW_HEIGHT_MIN;
	}

	height = (style->font)->ascent + (style->font)->descent + 2;
#else
	if (style->font_desc == NULL)
	{
		return GUI_LIST_ROW_HEIGHT_MIN;
	}

	else
	{
		PangoContext		*context;
		PangoFontMetrics	*metrics;

		context = gtk_widget_get_pango_context(list);
		metrics = pango_context_get_metrics(context, style->font_desc,
						pango_language_from_string("C"));

 		height  = pango_font_metrics_get_ascent(metrics);
		height += pango_font_metrics_get_descent(metrics);
		height  = PANGO_PIXELS(height) + 2;

		pango_font_metrics_unref(metrics);
	}
#endif
	return (height < GUI_LIST_ROW_HEIGHT_MIN) ? GUI_LIST_ROW_HEIGHT_MIN : height;

} /* gint guitl_store_calculate_row_height(GtkWidget *list) */


#ifdef CONFIG_SWAP_COLUMNS
#ifdef CONFIG_GTKCLIST_GTKCTREE

static void guitl_clist_swap_col_widgets(GtkCList *clist, gint colnr1, gint colnr2)
{
	GtkWidget *parent1, *parent2;
	GtkWidget *widget1, *widget2;
	GtkWidget *tmp;

	widget1 = gtk_clist_get_column_widget(clist, colnr1);
	widget2 = gtk_clist_get_column_widget(clist, colnr2);

	parent1 = widget1->parent;
	parent2 = widget2->parent;

	tmp = gtk_button_new();

	gtk_widget_reparent(widget1, tmp);
	gtk_widget_reparent(widget2, parent1);
	gtk_widget_reparent(widget1, parent2);

	gtk_widget_destroy(tmp);

} /* static void guitl_clist_swap_col_widgets(GtkCList *clist, gint colnr1, gint colnr2) */

void guitl_clist_swap_cols(GtkCList *clist, gint colnr1, gint colnr2)
{
	gint i;

	if (clist->columns <= colnr1 || clist->columns <= colnr2)
	{
		return;
	}

	guitl_clist_swap_col_widgets(clist, colnr1, colnr2);

	i = clist->rows;

	while (--i >= 0)
	{
		gchar *str1, *str2;

		str1 = (gtk_clist_get_text(clist, i, colnr1, &str1) ? g_strdup(str1) : NULL);

		if (gtk_clist_get_text(clist, i, colnr2, &str2) == FALSE)
		{
			str2 = NULL;
		}

		gtk_clist_set_text(clist, i, colnr1, str2);
		gtk_clist_set_text(clist, i, colnr2, str1);

		g_free(str1);
	}

} /* void guitl_clist_swap_cols(GtkCList *clist, gint colnr1, gint colnr2) */

static void guitl_ctree_swap_row_cols(GtkCTree *ctree, GtkCTreeNode *node, gint *cols)
{
	if(GTK_CTREE_ROW(node)->children == NULL)
	{
		gchar *str[2];

		str[0] = (gtk_ctree_node_get_text(ctree, node, cols[0], &str[0]) ?
								g_strdup(str[0]) : NULL);

		if (gtk_ctree_node_get_text(ctree, node, cols[1], &str[1]) == FALSE)
		{
			str[1] = NULL;
		}

		gtk_ctree_node_set_text(ctree, node, cols[0], str[1]);
		gtk_ctree_node_set_text(ctree, node, cols[1], str[0]);

		g_free(str[0]);
	}

} /* static void guitl_ctree_swap_row_cols(GtkCTree *ctree, GtkCTreeNode *node, gint *cols) */

void guitl_ctree_swap_cols(GtkCTree *ctree, gint colnr1, gint colnr2)
{
	gint cols[2];

	cols[0] = colnr1;
	cols[1] = colnr2;

	guitl_clist_swap_col_widgets(GTK_CLIST(ctree), colnr1, colnr2);

	gtk_ctree_post_recursive(ctree, NULL,
		GTK_CTREE_FUNC(guitl_ctree_swap_row_cols), cols);

} /* void guitl_ctree_swap_cols(GtkCTree *ctree, gint colnr1, gint colnr2) */

#else /* ! CONFIG_GTKCLIST_GTKCTREE */

void guitl_view_swap_cols(GtkTreeView *view, gint colnr1, gint colnr2)
{
	GtkTreeViewColumn *col_left, *col_right, *gap_left;

	gint pos_left  = colnr1;
	gint pos_right = colnr2;

	if (pos_left > pos_right)
	{
		gint temp;
		temp      = pos_left;
		pos_left  = pos_right;
		pos_right = temp;
	}

	col_left  = gtk_tree_view_get_column(view, pos_left);
	col_right = gtk_tree_view_get_column(view, pos_right);

	gap_left  = (pos_right - pos_left > 1) ?
			gtk_tree_view_get_column(view, pos_left - 1) : NULL;

	gtk_tree_view_move_column_after(view, col_left, col_right);

	if (gap_left)
	{
		gtk_tree_view_move_column_after(view, col_right, gap_left);
	}

} /* void guitl_view_swap_cols(GtkTreeView *view, gint colnr1, gint colnr2) */

#endif /* #ifdef CONFIG_GTKCLIST_GTKCTREE .. #else */
#endif /* CONFIG_SWAP_COLUMNS */

/* EOF */
