/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		modified 2005 ... 2008 by Harald Foerster		   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _gui_h_
#define _gui_h_

#include "gui-gtk.h"
#include "nscache.h"


#ifdef CONFIG_SWAP_COLUMNS

/*
	Buttons inside the column headers
	do not work with GTK+-2.0, so this
	is disabled there. Instead a popup
	menu will be displayed.
*/

#if GTK_MAJOR_VERSION == 1

#ifndef CONFIG_COLUMN_BUTTONS
#define CONFIG_COLUMN_BUTTONS	1
#endif

#else /* GTK_MAJOR_VERSION > 1 */

#ifndef CONFIG_COLUMN_POPUP
#define CONFIG_COLUMN_POPUP	1
#endif

#endif

#endif /* CONFIG_SWAP_COLUMNS */


/*
	gui.c
*/

enum
{
#if CONFIG_GTKCLIST_GTKCTREE
	kTreeLevelService = 1,
#else
	kTreeLevelService = 0,
#endif

	kTreeLevelDomain,
	kTreeLevelFolder
};

enum
{
	kTreeList,
	kSortedList,
	kNotebookPages
};

typedef struct
{
	gint			type;
	gchar			*name;
	nscache_record_t	*nscrec;

	union
	{
		GuiListStore	list;
		GuiTreeStore	tree;

	} store;

} ListSelection;

extern ListSelection	notebook_list[kNotebookPages];

/* TreeList or SortedList */
extern ListSelection	*mainlist;

/* all clists and one ctree */
extern GSList		*list_selection_slist;

/* mime in apassign and search dialog */
extern GSList *combo_mime_slist;

/* popup */
extern GtkWidget	*gui_popup_menu;

extern GtkWidget *gui_window_new(const gchar *title, GtkWidget *child, gint border, gint prop);

#ifdef CONFIG_GTKCLIST_GTKCTREE
extern void gui_list_row_selected(GtkCList*, gint, gint, GdkEventButton*, ListSelection*);
extern void gui_list_row_unselected(GtkCList*, gint, gint, GdkEventButton*, ListSelection*);
#else
extern void gui_tree_row_selected(GtkTreeSelection *selection, ListSelection *list);
#define gui_list_row_selected	gui_tree_row_selected
extern void gui_list_resize_column(GObject *column, GParamSpec *param, gpointer prop);
#endif

extern gboolean	gui_mouse_button_pressed(GtkWidget *treelist, GdkEvent *e, GtkWidget *popup_menu);

#if GTK_MAJOR_VERSION == 1
extern gboolean gui_sf10_show_popup_menu (GtkWidget *window, GdkEventKey *e, GtkWidget *popup_menu);
#else
extern gboolean gui_sf10_show_popup_menu (GtkWidget *window, GtkWidget *popup_menu);
#endif

extern void gui_err(const gchar *errmsg);
extern void gui_errfmt(const gchar *format, ...);
extern void gui_strerror(const gchar *errmsg);


/*
	gui-tools.c
*/

enum
{
	kIconButtonAppend,
	kIconButtonClose,
	kIconButtonDelete,
	kIconButtonModify,
	kIconButtonOkay,
	kIconButtonOpen,
	kIconButtonSearch,
	kIconButtonStop,

#ifdef CONFIG_COLUMN_BUTTONS
	kIconButtonCollapse,
	kIconButtonExpand,
#endif

	kIconButtonCancel,
	kNumberOfIconButton
};

enum
{
	kIconMimeHtml,
	kIconMimeText,
	kIconMimeImage,
	kIconMimeAudio,
	kIconMimeVideo,
	kIconMimeBinary,
	kIconMimeUnknown,
	kNumberOfIconMime
};

enum
{
	kIconDialogNsCacheLogo,

#if GTK_MAJOR_VERSION == 1
	kIconDialogError,
	kIconDialogInfo,
	kIconDialogWarning,
#endif
	kNumberOfIconDialog,

#if GTK_MAJOR_VERSION > 1
	kIconDialogError = kNumberOfIconDialog,
	kIconDialogInfo,
	kIconDialogWarning,
#endif
};

enum
{
	kIconFolder,
	kIconFolderOpen,
	kNumberOfIconFolder
};


typedef struct
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;

} PixmapData;

#if GTK_MAJOR_VERSION > 1
typedef struct
{
	GdkPixbuf *pixbuf;

} PixbufData;
#endif

#ifdef CONFIG_GTKCLIST_GTKCTREE
typedef PixmapData PixbufIcon;
#else
typedef PixbufData PixbufIcon;
#endif

extern PixbufIcon folder_icon[kNumberOfIconFolder];

typedef void (*GuiListStoreForeachFunc)(GuiListStore *list, gpointer userdata);
typedef void (*GuiTreeStoreRecursiveFunc)(GuiTreeStore *tree, gpointer rowdata, gpointer userdata);

extern void
guitl_list_foreach(GuiListStore *list, GuiListStoreForeachFunc func, gpointer userdata);

extern void
guitl_list_foreach_row_data(GuiListStore *list, GFunc func, gpointer userdata);

extern gpointer
guitl_list_compare_row_data(GuiListStore *list, GCompareFunc func, gconstpointer userdata);

extern void
guitl_tree_recursive(GuiTreeStore *tree, gboolean selected, GuiTreeStoreRecursiveFunc func, gpointer userdata);

extern gint guitl_store_calculate_row_height(GtkWidget *list);


#ifdef CONFIG_GTKCLIST_GTKCTREE

#define guitl_list_find_by_row_data(list, userdata) \
	gtk_clist_find_row_from_data((list)->clist, userdata)

#define guitl_tree_find_by_row_data(tree, userdata) \
	gtk_ctree_find_by_row_data((tree)->ctree, NULL, userdata)

#define guitl_list_calculate_row_height(list) \
	guitl_store_calculate_row_height(GTK_WIDGET((list)->clist))

#define guitl_tree_calculate_row_height(tree) \
	guitl_store_calculate_row_height(GTK_WIDGET((tree)->ctree))

#else /* ! CONFIG_GTKCLIST_GTKCTREE */

/* return value has to be freed with 'g_free' */
extern GtkTreeIter*
guitl_iter_find_by_row_data(GtkTreeModel *model, gint colnr, gconstpointer userdata);

#define guitl_list_find_by_row_data(list, userdata) \
	guitl_iter_find_by_row_data(GTK_TREE_MODEL((list)->slist), (list)->data_column, userdata)

#define guitl_tree_find_by_row_data(tree, userdata) \
	guitl_iter_find_by_row_data(GTK_TREE_MODEL((tree)->stree), (tree)->data_column, userdata)

#define guitl_list_calculate_row_height(list) \
	guitl_store_calculate_row_height(GTK_WIDGET((list)->view))

#define guitl_tree_calculate_row_height(tree) \
	guitl_store_calculate_row_height(GTK_WIDGET((tree)->view))

#endif /* #ifdef CONFIG_GTKCLIST_GTKCTREE .. #else */

#ifdef HAVE_ICONV
extern gchar *guitl_convert_window_title_if_enabled(const gchar *title);
#else
#define guitl_convert_window_title_if_enabled(title)	((gchar *) title)
#endif

extern void       guitl_window_set_title_gettext(GtkWidget *window, const gchar *title);
extern void       guitl_window_toplevel_destroy_all(void);
extern GtkWidget *guitl_window_new_gettext(const gchar *title, GtkWidget *child, gint border);
extern GtkWidget *guitl_dialog_new_gettext(const gchar *title, GtkWidget *child, gint border);
extern GtkWidget *guitl_file_selection_new_gettext(const gchar *title);
extern void       guitl_dialog_set_modal(GtkWidget *dialog, GtkWidget **menu);
extern GtkWidget *guitl_frame_new_add_child_gettext(const gchar *title, GtkWidget *child);
extern GtkWidget *guitl_check_button_new_gettext(const gchar *label);
extern GtkWidget *guitl_check_menu_item_new_gettext(const gchar *label);
extern GtkWidget *guitl_label_new_gettext(const gchar *str);
extern GtkWidget *guitl_menu_item_new_gettext(const gchar *label);
extern GtkStyle  *guitl_rc_get_style(GtkWidget *widget);
extern GtkEntry  *guitl_tab_add_entry(GtkTable *, gchar *, guint, guint);
extern GtkCombo  *guitl_tab_add_combo(GtkTable *, gchar *, GList *, guint, guint);

extern void        guitl_create_icons(GtkWidget *widget);
extern GtkWidget  *guitl_get_icon_button(gint index);
extern GtkWidget  *guitl_get_icon_menu(gint index);
extern GtkWidget  *guitl_get_icon_dialog(gint index);
extern PixbufIcon *guitl_get_icon_mime(const char *mimetype);

extern GtkWidget *guitl_hbutton_box_new(GtkWidget *parent, gint spacing, GtkButtonBoxStyle layout);
extern GtkWidget *guitl_button_box_add_icon_button(GtkWidget *button_box, gint icon_index);


#ifdef CONFIG_SWAP_COLUMNS
#ifdef CONFIG_GTKCLIST_GTKCTREE
extern void guitl_clist_swap_cols(GtkCList *clist, gint colnr1, gint colnr2);
extern void guitl_ctree_swap_cols(GtkCTree *clist, gint colnr1, gint colnr2);
#else
extern void guitl_view_swap_cols(GtkTreeView *view, gint colnr1, gint colnr2);
#endif
#endif


/*
	search.c
*/

extern GSList *search_dialog_slist;

extern void search_dialog_open(void);
extern void search_disable_entries(gpointer, gpointer);
extern gint search_update_window_title(gpointer, gpointer);

#endif /* _gui_h_ */
