/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		modified 2005 ... 2008 by Harald Foerster		   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _nls_H_
#define _nls_H_

extern const char *nscache_package_str;

#define CATALOG_NAME	nscache_package_str

#ifdef HAVE_GETTEXT

#include <locale.h>
#include <libintl.h>

#define NLS_TEXTDOMAIN(locale)			\
{						\
	setlocale(LC_CTYPE, locale);		\
	bindtextdomain(CATALOG_NAME, NLS_DIR);	\
	textdomain(CATALOG_NAME);		\
}

#ifdef LC_MESSAGES

#define NLS_INIT_LOCALE() \
	NLS_TEXTDOMAIN(setlocale(LC_MESSAGES, ""))

#else

#define NLS_INIT_LOCALE()	NLS_TEXTDOMAIN("")

#endif /* LC_MESSAGES */

#else

#ifdef HAVE_LOCALE
#include <locale.h>
#define NLS_INIT_LOCALE()	setlocale(LC_CTYPE, "")
#else
#define NLS_INIT_LOCALE()
#endif

#define gettext(str)		((char *) str)

#endif /* HAVE_GETTEXT */

#define gettext_nop(str)	(str)

#endif /* _nls_H_ */
