/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		modified 2005,2006,2007 by Harald Foerster		   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifdef CONFIG_BERKELEY_DB

#include <sys/types.h>
#include <string.h>

#include "ns.h"
#include "berkeley.h"
#include "bswap32.h"
#include "file.h"
#include "nls.h"

/*
#include "nscache.h"
#include <gtk/gtk.h>
#include <time.h>
*/

typedef unsigned char	bool;

static GSList*	ns_read_db(char **dbname);
static int	ns_cache_check(const char *dbname);

#ifndef CACHE_READONLY
static int	ns_record_delete(nscache_record_t *);
#endif

NSC_BROWSER ns_browser =
{
	ns_read_db,

#ifndef CACHE_READONLY
	ns_record_delete,
#endif
	ns_cache_check,

	gettext_nop("Netscape 4.x")
};

static void *ns_dbt_to_record(DBT *key, DBT *data, DBnscache *nsc)
{
	ns_record_t	*ret;
	char		*tmp, *end;
	gint32		size, version;

	if (data->size < 85)
	{
		return NULL;
	}

	tmp = data->data;

	/* size */
	size = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);

	if (data->size != size)
	{
		return NULL;
	}

	end  = &tmp[size];
	tmp += sizeof(guint32);

	/* initialize to '\0' */
	ret = g_malloc0(sizeof(ns_record_t));

	/* version */
	version = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
	tmp += sizeof(guint32);

	/* last_modified */
	ret->record.last_modified = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
	tmp += sizeof(guint32);

	/* last_accessed */
	ret->record.last_accessed = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
	tmp += sizeof(guint32);

	/* expiration_time */
	ret->record.expires = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
	tmp += sizeof(guint32);

	/* content_length */
	ret->record.content_length =
			UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
	tmp += sizeof(guint32);
#if 0
	ret->record.content_offset = 0;
#endif
	tmp += sizeof(bool) +		/* is_netsite */
		sizeof(time_t); 	/* lock_date */
	do
	{
		/* filename_len */
		guint32 slen = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
		tmp += sizeof(guint32);

		if (&tmp[slen] <= tmp || &tmp[slen] > end ||
			tmp == NULL || tmp[0] == '\0' || tmp[slen - 1] != '\0')
		{
			break;
		}

		ret->record.filename = g_strdup(tmp);

		tmp += slen +				/* filename */
			sizeof(guint32) +		/* filename_len ( twice ??? )*/
				sizeof(bool) +		/* is_relative_path */
					sizeof(guint32);/* security_on */
		if (tmp >= end)
		{
			break;
		}

		/* sec_info_len */
		slen  = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
		tmp  += sizeof(guint32);
		/* sec_info method */
		slen += sizeof(guint32);

		if (&tmp[slen] < tmp || &tmp[slen] >= end)
		{
			break;
		}

		tmp += slen;
		/* address_len */
		slen = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
		tmp += sizeof(guint32);

		if (&tmp[slen] < tmp || &tmp[slen] >= end)
		{
			break;
		}

		/* address */
		tmp += slen;

		if (version == 4)
		{
			/* post_data_len */
			slen = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
			tmp += sizeof(guint32);

			if (&tmp[slen] < tmp || &tmp[slen] >= end)
			{
				break;
			}

			/* post_data */
			tmp  += slen;
			/* post_headers_len */
			slen  = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
			tmp  += sizeof(guint32);
			/* post_headers unknown */
			slen += sizeof(guint32);

			if (&tmp[slen] < tmp || &tmp[slen] >= end)
			{
				break;
			}

			tmp += slen;
		}

		/* content_type_len */
		slen = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
		tmp += sizeof(guint32);

		if (slen)
		{
			if (&tmp[slen] < tmp || &tmp[slen] >= end || tmp[slen - 1] != '\0')
			{
				break;
			}

			/* content_type */
			ret->record.content_type = content_type_into_glist(tmp);
			tmp += slen;
		}

		/* content_encoding_len */
		slen = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
		tmp += sizeof(guint32);

		if (slen)
		{
			if (&tmp[slen] < tmp || &tmp[slen] >= end || tmp[slen - 1] != '\0')
			{
				break;
			}

			/* content_encoding */
			ret->record.content_encoding = content_misc_into_gslist(tmp);
			tmp += slen;
		}

		/* charset_len */
		slen = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
		tmp += sizeof(guint32);

		if (slen)
		{
			if (&tmp[slen] < tmp || &tmp[slen] >= end || tmp[slen - 1] != '\0')
			{
				break;
			}

			ret->record.charset = content_misc_into_gslist(tmp);
		}
#if 0
		tmp += slen +				/* charset */
			sizeof(bool) +			/* incomplete_file */
				sizeof(guint32);	/* total_content_len */

		/* page_services_url_len */
		slen = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
		tmp += sizeof(guint32);

		if (&tmp[slen] >= end)
		{
			break
		}

		tmp += slen;				/* page_services_url */
#endif /* 0 */
		tmp = key->data;

		size = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
		tmp += sizeof(guint32);
		slen = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
		tmp += sizeof(guint32);

		if (key->size != size || slen >= size)
		{
			break;
		}

		if (tmp == NULL ||
			tmp[0] == '\0' || tmp[slen - 1] != '\0')
		{
			break;
		}

		ret->record.urlstr = g_strdup(tmp);

		return ret;
	}
	while (FALSE);

	nscache_record_free((nscache_record_t *) ret);
	nsc->error++;

	return NULL;

} /* static void *ns_dbt_to_record(DBT *key, DBT *data, DBnscache *nsc) */

static GSList *ns_read_db(char **dbname)
{
	return berkeley_read(dbname, (CacheEntryReadFunc) ns_dbt_to_record, NULL);

}

#ifndef CACHE_READONLY

static int ns_record_delete(nscache_record_t *nsc_rec)
{
	int	rv;
	gint32	length, size;
	char	*tmp;
	DBT	key;

	size   = sizeof(guint32);		/* check sum */
	size  += sizeof(guint32);		/* size of urlstr */
	length = strlen(nsc_rec->urlstr) + 1;	/* urlstr */
	size  += length;
	size  += sizeof(guint32);		/* post data */

	key.size = size;
	key.data = g_malloc(size);

	tmp = key.data;

	*(guint32 *) tmp = UINT32_TO_LITTLE_ENDIAN(key.size);
	tmp += sizeof(guint32);

	*(guint32 *) tmp = UINT32_TO_LITTLE_ENDIAN(length);
	tmp += sizeof(guint32);

	tmp  = strcpy(tmp, nsc_rec->urlstr);
	tmp += length;
	*(guint32 *) tmp = 0;

	rv = berkeley_delete(nscache_db.name, nsc_rec->filename, &key);

	g_free(key.data);

	return rv;

} /* static int ns_record_delete(nscache_record_t *nsc_rec) */

#endif /* ! CACHE_READONLY */

static int ns_cache_check(const char *dbname)
{
	DBT key;

	key.data = (void *)"INT_ExternalCacheNameString";
	key.size = 27;
	
	return berkeley_check(dbname, &key);

} /* static int ns_cache_check(const char *dbname) */

#endif /* CONFIG_BERKELEY_DB */

/* EOF */
