/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		modified 2005 ... 2008 by Harald Foerster		   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifdef CONFIG_BERKELEY_DB

#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>

#include "ns.h"
#include "berkeley.h"
#include "bswap32.h"
#include "file.h"
#include "nls.h"

/*
#include "nscache.h"
#include <gtk/gtk.h>
#include <time.h>
*/

static GSList*	ns6_read_db(char **dbname);
static int	ns6_cache_check(const char *dbname);

#ifndef CACHE_READONLY
static int	ns6_record_delete(nscache_record_t *);
#endif

NSC_BROWSER ns6_browser =
{
	ns6_read_db,

#ifndef CACHE_READONLY
	ns6_record_delete,
#endif
	ns6_cache_check,

	gettext_nop("Netscape 6.0")
};



static void *ns6_dbt_to_record(DBT *key, DBT *data, DBnscache *nsc)
{
	ns6_record_t	*ret;
	char		*tmp, *end;
	gint32		size;

	if(data->size < 20)
	{
		return NULL;
	}

	tmp = data->data;

	/* size */
	size = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);

	if (data->size != size)
	{
		return NULL;
	}

	end  = &tmp[size];
	tmp += sizeof(gint32);

	/* initialize to '\0' */
	ret = g_malloc0(sizeof(ns6_record_t));

	do
	{
		int	plen;
		guint32	slen;
		char	*p, *str;

		/* recordid */
		ret->recordid = *(guint32 *) tmp;
		tmp += sizeof(guint32);

		if (ret->recordid != *(guint32 *) key->data)
		{
			break;
		}

		/* key_len */
		slen = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
		tmp += sizeof(guint32);

		if (&tmp[slen] <= tmp ||&tmp[slen] >= end ||
					tmp == NULL || tmp[0] == '\0')
		{
			break;
		}

		ret->record.urlstr = g_strndup(tmp, slen);
		/* key */
		tmp += slen;

		/* metadata_len */
		slen = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
		tmp += sizeof(guint32);

		if (&tmp[slen] <= tmp || &tmp[slen] >= end)
		{
			break;
		}

		p = tl_mem_find_str(tmp, slen, "HTTP headers", strlen("HTTP headers"));

		if (p == NULL)
		{
			nscache_record_free((nscache_record_t *) ret);
			return NULL;
		}

		p += strlen("HTTP headers") + 1;
		p += sizeof(guint32);

		/* metadata */
		tmp += slen;
		plen = tmp - p;

		/* Content-Type: */
		str = tl_get_mime_value_str(p, plen, "content-type:",
							sizeof("content-type:") - 1);
		ret->record.content_type = content_type_into_glist(str);

		/* "charset" */
		str = tl_get_mime_value_str(p, plen, "charset",
							sizeof("charset") - 1);
		ret->record.charset = content_misc_into_gslist(str);

		/* Content-Encoding: */
		str = tl_get_mime_value_str(p, plen, "content-encoding:",
							sizeof("content-encoding:") - 1);
		ret->record.content_encoding = content_misc_into_gslist(str);

		/* Content-Length: */
		str = tl_get_mime_value_str(p, plen, "content-length:",
							sizeof("content-length:") - 1);
		if (str)
		{
			ret->record.content_length = atoi(str);
		}

		/* Date: */
		str = tl_get_mime_value_str(p, plen, "date:", sizeof("date:") - 1);
		ret->record.last_accessed = time_from_string(str);

		/* Last-Modified: */
		str = tl_get_mime_value_str(p, plen, "last-modified:",
							sizeof("last-modified:") - 1);
		ret->record.last_modified = time_from_string(str);

		/* Expires: */
		str = tl_get_mime_value_str(p, plen, "expires:", sizeof("expires:") - 1);
		ret->record.expires = time_from_string(str);

		/* filename_len */
		slen = UINT32_FROM_LITTLE_ENDIAN_PTR(tmp);
		tmp += sizeof(guint32);

		if (&tmp[slen] <= tmp || &tmp[slen] > end ||
			tmp == NULL || tmp[0] == '\0' || tmp[slen - 1] != '\0')
		{
			break;
		}

		tmp = tl_strnrsep(tmp, slen, nsc->userdata);
		ret->record.filename = g_strdup(tmp);

		if (ret->record.content_length == 0)
		{
			struct stat estat;

			if (file_status((nscache_record_t *) ret, &estat) == 0)
			{
				ret->record.content_length = estat.st_size;
			}
		}
#if 0
		ret->record.content_offset = 0;
#endif
		return ret;
	}
	while (FALSE);

	nscache_record_free((nscache_record_t *) ret);
	nsc->error++;

	return NULL;

} /* static void *ns6_dbt_to_record(DBT *key, DBT *data, DBnscache *nsc) */

static GSList *ns6_read_db(char **dbname)
{
	int sep = -1;

	return berkeley_read(dbname, (CacheEntryReadFunc) ns6_dbt_to_record, &sep);
}

#ifndef CACHE_READONLY

static int ns6_record_delete(nscache_record_t *nsc_rec)
{
	DBT key;

	key.size = sizeof(guint32);
	key.data = &(((ns6_record_t *) nsc_rec)->recordid);

	return berkeley_delete(nscache_db.name, nsc_rec->filename, &key);
}

#endif /* ! CACHE_READONLY */

static int ns6_cache_check(const char *dbname)
{
	return berkeley_check(dbname, NULL);
}

#endif /* CONFIG_BERKELEY_DB */

/* EOF */
