/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		modified 2005 ... 2008 by Harald Foerster		   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _nscache_h_
#define _nscache_h_

#include <glib.h>
#include <time.h>

#include "stringbuf.h"

#ifdef CONFIG_BERKELEY_DB
#define MULTI_DB_TYPES
#endif

#ifdef HAVE_MSIE
#define MSIE_CACHE	((size_t) -1)
#ifndef MULTI_DB_TYPES
#define MULTI_DB_TYPES
#endif
#endif

enum
{

#ifdef CONFIG_BERKELEY_DB
	NSCACHE_RT_NETSCAPE_4,
	NSCACHE_RT_NETSCAPE_6,
#endif

	NSCACHE_RT_MOZILLA,

#ifdef HAVE_MSIE
	NSCACHE_RT_MSIE,
#endif

	NSCACHE_RT_UNKNOWN,
	
	NSCACHE_RT_FIRST = 0,
	NSCACHE_RT_LAST  = NSCACHE_RT_UNKNOWN - 1
};


enum
{
	NSC_ERR_SILENT	= -1,
	NSC_ERR_ENTRY	= -2,
	NSC_ERR_FILE	= -3,
	NSC_ERR_HASHNR	= -4
};


typedef struct
{
	char	*urlstr;
	char	*filename;
	char	*content_type;
	char	*content_encoding;
	char	*charset;
	size_t	content_length;
	size_t	content_offset; /* moz or msie*/
	time_t	last_modified;
	time_t	last_accessed;
	time_t	expires;

} nscache_record_t;


typedef struct
{
	GSList	*content_type;
	GSList	*content_encoding;
	GSList	*charset;

} nscache_content_types_t;

typedef struct
{
	const char	*str;
	size_t		 num;

} nscache_typecount_t;


typedef struct
{
	StringBuf	path;
	char		*name;
	char		*version;
	unsigned int	type;

#ifndef CACHE_READONLY
	int		readonly;
#endif
	time_t		access_time;

} CacheDB;

extern CacheDB nscache_db;


typedef struct
{
	GSList*	(*read_db) (char **dbname);

#ifndef CACHE_READONLY
	int	(*record_delete) (nscache_record_t *);
#endif
	int	(*cache_check) (const char *dbname);

	char	*browser_name;

} NSC_BROWSER;

extern NSC_BROWSER *nsc_browser[NSCACHE_RT_LAST + 1];

#define NSC_GET_BROWSER_NAME(db_type)	\
		(nsc_browser[db_type]->browser_name)

extern const gchar yes_str[];
extern const gchar no_str[];
extern const gchar na_str[];

extern const gchar nscache_err_open_index_file[];

/* slist == FALSE => guess db type and return NULL */
extern GSList	*nscache_read_cache(const char *dbname, gboolean slist);

#ifndef CACHE_READONLY
extern int	nscache_record_delete(nscache_record_t *);
#endif

enum
{
	STYPE_URL,
	STYPE_FILE,
	STYPE_SIZE,
	STYPE_ATM,
	STYPE_MIME,
	STYPE_REVERS_MASK = 0x08

};

extern int nscache_sort_type;

extern void nscache_record_free(nscache_record_t *);
extern char *content_type_into_glist(const char *content_type);
extern char *content_misc_into_gslist(const char *encoding_or_charset);
extern gint  nscache_compare_func(const nscache_record_t*, const nscache_record_t*);
extern void nscache_content_types_add(nscache_record_t*, nscache_content_types_t**);
extern void nscache_content_types_free(nscache_content_types_t*);
extern int  nscache_dump(const char *dbname, int what, int sort_type);

extern const char *nscache_package_str;
extern const char *nscache_version_str;

extern GList 	*mime_types_available;


/*
	gui.c
*/

extern void gui_err(const gchar *errmsg);
extern void gui_errfmt(const gchar *format, ...);
extern void gui_strerror(const gchar *errmsg);
extern void gui_init(char *dbname);


/*
	main.c
*/

enum
{
	kNoStdOut,
	kOnlyStdOutSummary,
	kOnlyStdOutConentTypes,
	kOnlyStdOutList,
	kOnlyStdOutMultiLine
};

/* returns error message or NULL */
extern char *save_rc(void);


/*
	times.c
*/

/* 'timestr' will be modified */
extern time_t time_from_string(char* timestr);
extern char  *time_to_string(char* buf, size_t len, const time_t *ptime);


/*
	tools.c
*/

#ifdef HAVE_GLOB

typedef struct
{
	int	fnamec;
	char	**fnamev;
	char	*append;
	void	*globdata;

} CompletitonData;

extern CompletitonData	*tl_fname_completion(const gchar *fname);
extern void		 tl_completion_free(CompletitonData *ptr);

#endif /* HAVE_GLOB */

extern int   tl_is_ascii_str(const char *str);
extern int   tl_is_alnum_str(const char *beg, const char *str, int slen);
extern int   tl_count_lines(const char *p, const char *end);
extern char *tl_strndup_to_lower(const char *str, int slen);
extern char *tl_replace_non_ascii_chars_in_str(char *str);
extern char *tl_get_linestart(const char *beg, const char *p);
extern char *tl_get_linestop(const char *p, const char *end);
extern char *tl_mem_find_str(const char *mem, int mlen, const char *str, int slen);
/* letters in 'str' must be lower case */
extern char *tl_mem_find_str_igncase(const char *mem, int mlen, const char *str, int slen);
/* letters in 'mime_id' must be lower case */
extern char *tl_get_mime_value_str(char *mem, int mem_len, const char *mime_id, int mid_len);
extern char *tl_get_url_start(const char *urlstr);
extern char *tl_get_url_filename(const char *urlstr);
extern int   tl_str_escape_chars(char *buf, int len, const char *str, const char *esc_chars);
extern char *tl_get_1qstr(char *str);

#ifdef CONFIG_BERKELEY_DB
extern char *tl_strnrsep(char *str, int len, int *sep);
#endif

#if GLIB_MAJOR_VERSION == 1
extern char *tl_strchr_nth(const char *str, int chr, int n);
#endif

#endif /* _nscache_h_ */
