/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		modified 2005,2008 by Harald Foerster			   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _re_h_
#define _re_h_

#ifdef HAVE_REGEX

#ifdef HAVE_REGEX_H

#ifdef HAVE_BSD_REGEX
#ifndef _REGEX_RE_COMP
#define _REGEX_RE_COMP
#endif
#endif

#include <sys/types.h>
#include <regex.h>

#endif /* HAVE_REGEX_H */

typedef char* (*StrDupToLowerFunc) (const char *, int);

#if defined(HAVE_POSIX_REGEX)

#ifdef REG_ICASE
#define REGEX_SEARCH_IGNORE_CASE	REG_ICASE
#endif

#ifdef REG_EXTENDED
#define REGEX_SEARCH_EXTENDED		REG_EXTENDED
#endif

#ifdef REG_NEWLINE
#define REGEX_SEARCH_NEWLINE		REG_NEWLINE
#endif

typedef struct
{
	regex_t			preg;
	StrDupToLowerFunc	str_lower_func;

} re_entry;

#elif defined(HAVE_PCRE_REGEX)

#include <pcre.h>

#ifdef PCRE_CASELESS
#define REGEX_SEARCH_IGNORE_CASE	PCRE_CASELESS
#endif

#ifdef PCRE_MULTILINE
#define REGEX_SEARCH_NEWLINE		PCRE_MULTILINE
#endif

#if 0
#ifdef PCRE_UTF8
#define REGEX_SEARCH_UTF8		PCRE_UTF8
#endif
#endif /* 0 */

typedef struct
{
	pcre			*preg;
	pcre_extra		*preg_extra;
	StrDupToLowerFunc	str_lower_func;

} re_entry;

#elif defined(HAVE_GNU_REGEX)

#ifdef RE_SYNTAX_POSIX_EXTENDED
#define HAVE_GNU_REGEX_SYNTAX_OPTION	RE_SYNTAX_POSIX_EXTENDED
#endif

typedef struct
{
	struct re_pattern_buffer preg;
	struct re_registers	 regs;
	StrDupToLowerFunc	 str_lower_func;

} re_entry;

#elif defined(HAVE_V8_REGEX)

#ifndef NSUBEXP
#include <regexp.h>
#endif

typedef struct
{
	regexp			*preg;
	StrDupToLowerFunc	str_lower_func;

} re_entry;

#elif defined(HAVE_BSD_REGEX)

#ifdef RE_SYNTAX_POSIX_EXTENDED
#define HAVE_BSD_REGEX_SYNTAX_OPTION	RE_SYNTAX_POSIX_EXTENDED
#endif

typedef struct
{
	char			*pattern;
	StrDupToLowerFunc	str_lower_func;

} re_entry;

#endif /* #if defined(HAVE_POSIX_REGEX) .. #elif */

#if defined(REGEX_SEARCH_EXTENDED) && defined(REGEX_SEARCH_NEWLINE)
#define REGEX_SEARCH_OPTION	(REGEX_SEARCH_EXTENDED | REGEX_SEARCH_NEWLINE)
#elif defined(REGEX_SEARCH_EXTENDED)
#define REGEX_SEARCH_OPTION	REGEX_SEARCH_EXTENDED
#elif defined(REGEX_SEARCH_NEWLINE)
#define REGEX_SEARCH_OPTION	REGEX_SEARCH_NEWLINE
#else
#define REGEX_SEARCH_OPTION	0
#endif

/* 'error' only valid if 're_make' returns NULL (never V8), must be freed */
extern re_entry *re_make(const char *pattern, int option, char **error);
extern int re_pmatch(re_entry *ree, const char *str, int slen, int *end_offs);
extern void re_free(re_entry *ree);

#endif /* HAVE_REGEX */

#endif /* _re_h_ */
