/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 2001 Ondrejicka Stefan			   */
/*		(ondrej@idata.sk)					   */
/*		modified 2006,2008 by Harald Foerster			   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <ctype.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

typedef struct _dayn
{
	char *name;
	int  num;
} dayn;

static const dayn dnames[] =
{
	{"Sun" , 0} ,
	{"Mon" , 1} ,
	{"Tue" , 2} ,
	{"Wed" , 3} ,
	{"Thu" , 4} ,
	{"Fri" , 5} ,
	{"Sat" , 6} ,
	{"Sunday" , 0} ,
	{"Monday" , 1} ,
	{"Tuesday" , 2} ,
	{"Wednesday" , 3} ,
	{"Thursday" , 4} ,
	{"Friday" , 5} ,
	{"Saturday" , 6} ,
	{NULL , -1}
};

static const dayn mnames[] =
{
	{"Jan" , 0} ,
	{"Feb" , 1} ,
	{"Mar" , 2} ,
	{"Apr" , 3} ,
	{"May" , 4} ,
	{"Jun" , 5} ,
	{"Jul" , 6} ,
	{"Aug" , 7} ,
	{"Sep" , 8} ,
	{"Oct" , 9} ,
	{"Nov" , 10} ,
	{"Dec" , 11} ,
	{"January" , 0} ,
	{"February" , 1} ,
	{"March" , 2} ,
	{"April" , 3} ,
	{"May" , 4} ,
	{"Jun" , 5} ,
	{"July" , 6} ,
	{"August" , 7},
	{"September" , 8} ,
	{"October" , 9} ,
	{"November" , 10} ,
	{"December" , 11} ,
	{NULL , -1}
};

static char *next_token(char *token)
{
	/*
		Terminate this token and
		return pointer to the next
	*/

	unsigned int chr;

	if (token == NULL)
	{
		return NULL;
	}

	do
	{
		chr = *(token++);

		if (chr == '\0')
		{
			return NULL;
		}
	}
	while (isalnum(chr));

	token[-1] = '\0';

	do
	{
		chr = *(token++);
	}
	while (isalnum(chr) == FALSE);

	return token - 1;
}

static char* _atoi(char *token, int *result) 
{
	if (token)
	{
		int  temp;
		char *next, *eptr;

		/* terminate token */
		next = next_token(token);
		temp = strtol(token, (char **) &eptr, 10);

		if (*eptr == '\0')
		{
			*result	= temp;
			return next;
		}
	}

	return NULL;
}

static char *day_month_num(const dayn *dm, char *token, int *result)
{
	if (token)
	{
		char *next;

		/* terminate token */
		next = next_token(token);

		do
		{
			if (g_strcasecmp(dm->name, token) == 0)
			{
				*result = dm->num;
				return next;
			}
		}
		while ((++dm)->name != NULL);
	}

	return NULL;
}

time_t time_from_string(char *timestr)
{
	/*
		DAY MONTH dd yyyy hh:mm:ss [PM] [GMT]
		DAY dd MONTH yyyy hh:mm:ss [PM] [GMT]
		DAY MONTH dd hh:mm:ss [PM] yyyy [GMT]
	*/

	char		*token;
	struct tm	otm;

	token = timestr;

	if (token == NULL)
	{
		return 0;
	}

	token[strcspn(token, "\x0d\x0a")] = '\0';

	memset(&otm , '\0', sizeof(struct tm));
	otm.tm_sec = -1;

	/* DAY */
	token = day_month_num(dnames, token, &(otm.tm_wday));

	if (token == NULL)
	{
		return 0;
	}

	if (isalpha(token[0]))
	{
		/* MONTH */
		token = day_month_num(mnames, token, &(otm.tm_mon));

		/* dd */
		token = _atoi(token, &(otm.tm_mday));
	}

	else
	{
		/* dd */
		token = _atoi(token, &(otm.tm_mday));

		/* MONTH */
		token = day_month_num(mnames, token, &(otm.tm_mon));
	}

	if (token[2] != '\0')
	{
		/* yyyy */
		token = _atoi(token, &(otm.tm_year));
	}

	/* hh */
	token = _atoi(token, &(otm.tm_hour));

	/* mm */
	token = _atoi(token, &(otm.tm_min));

	/* ss */
	token = _atoi(token, &(otm.tm_sec));

	if (token == NULL)
	{
		if (otm.tm_sec == -1)
		{
			return 0;
		}
	}

	else
	{
		if (tolower(token[0]) == 'p' &&
				tolower(token[1]) == 'm' &&
					isalnum(token[2]) == FALSE)
		{
			otm.tm_hour += 12;
			token = next_token(token);
		}

		if (otm.tm_year == 0)
		{
			/* yyyy */
			token = _atoi(token, &(otm.tm_year));
		}
	}

	otm.tm_year -= 1900;

	if (otm.tm_year >= 0)
	{
		time_t rv;

#if defined(HAVE_TIMEGM)

		rv = timegm(&otm);

		if (rv != -1)
		{
			return rv;
		}

#elif defined(TM_GMTOFF)

		/* set tm_isdst only here */
		otm.tm_isdst = -1;
		rv = mktime(&otm);

		if (rv != -1)
		{
			return rv + (time_t) otm.TM_GMTOFF;
		}
#else
		rv = mktime(&otm);

		if (rv != -1)
		{
			time_t gmt, gmtoff;

			gmt = mktime(gmtime(&rv));
			gmtoff = rv - gmt;

			return rv + gmtoff;
		}

#endif /* #ifdef HAVE_TIMEGM .. #else */

	} /* if (otm.tm_year >= 0) */

	return 0;

} /* time_t time_from_string(char *) */

char *time_to_string(char *buf, size_t len, const time_t *ptime)
{
	if (*ptime)
	{
		struct tm *ptm;

		ptm = localtime(ptime); 
		strftime(buf, len, "%H:%M %d.%m.%Y", ptm);

		return buf;
	}

	*buf = '\0';

	return NULL;

} /* char *time_to_string(char*, size_t, const time_t*) */

/* EOF */
