/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		created and modified 2007,2008 by Harald Foerster	   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef UTF8_TOOLS_H
#define UTF8_TOOLS_H

#include "charconv.h"

/*
#include <glib.h>
#include "nls.h"
*/

#if GLIB_MAJOR_VERSION == 1

#ifdef HAVE_UNICODE

#include <unicode.h>

#define UTF8_TOOLS_PREV_CHAR(beg, p)		unicode_previous_utf8((beg), (p))
#define UTF8_TOOLS_NEXT_CHAR(p, end)		unicode_next_utf8(p)

#else

gchar *utf8tl_find_prev_char(const gchar *beg, const char *p);
gchar *utf8tl_find_next_char(const gchar *p, const gchar *end);

#define UTF8_TOOLS_PREV_CHAR(beg, p)		utf8tl_find_prev_char((beg), (p))
#define UTF8_TOOLS_NEXT_CHAR(p, end)		utf8tl_find_next_char((p), (end))

#endif /* #ifdef HAVE_UNICODE .. #else */

#define UTF8_TOOLS_OFFSET_TO_POINTER(str, i)	&(str)[i]
#define UTF8_TOOLS_STRLEN(str)			strlen(str)

#else /* GLIB_MAJOR_VERSION > 1 */

#define UTF8_TOOLS_PREV_CHAR(beg, p)		g_utf8_find_prev_char((beg), (p))
#define UTF8_TOOLS_NEXT_CHAR(p, end)		g_utf8_find_next_char((p), (end))
#define UTF8_TOOLS_OFFSET_TO_POINTER(str, i)	g_utf8_offset_to_pointer((str), (i))
#define UTF8_TOOLS_STRLEN(str)			g_utf8_strlen((str), -1)

#endif /* #if GLIB_MAJOR_VERSION == 1 .. #else */

gint   utf8tl_is_alnum_str(const gchar *beg, const gchar *str, gint slen);
gchar *utf8tl_get_linestart(const gchar *beg, const gchar *p);
gchar *utf8tl_get_linestop(const gchar *p, const gchar *end);
gchar *utf8tl_strndup_to_lower(const gchar *str, gint slen);
gchar *utf8tl_strstr_igncase(const gchar *str, gint slen,
					const gchar *pattern, gint plen);
#if defined(HAVE_UNICODE) || defined(PANGO_LOCALE)
gchar *utf8tl_replace_non_ascii_chars_in_str(gchar *str);
#endif

#endif /* UTF8_TOOLS_H */
