/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disk cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		created and modified 2005,2008 by Harald Foerster	   */
/*		(harald_foerster@users.sourceforge.net)			   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef VIEWER_H
#define VIEWER_H

#include "nscache.h"

enum
{
	VIEWER_URL,
	VIEWER_FILE
};

/* parameter is URL (%u) or file (%f) */
extern const char uof_param_str[2][3];

/* the viewer's return value */
extern volatile int viewer_status;

extern pid_t parent_pid;
extern pid_t parent_uid;

/* 'VIEWER_FILE' => url == NULL */
int viewer_start(const char* appassign, const char* url, const nscache_record_t* rec);

/* termination and signal SIGCHLD */
extern void viewer_atexit(void);
extern void viewer_sigchld(int signum);

#endif /* VIEWER_H */
