/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "emutest.h"

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kapplication.h>

#include "../../globalstuff.h" // include PACKAGE_VER string from PwManager


static const char *description = "PwManager KWallet emulation testing application";

static KCmdLineOptions options[] =
{
	{ 0, 0, 0 }
};

int main(int argc, char *argv[])
{
	KAboutData aboutData("pwmanageremutest", "PwManagerEmuTest",
			     PACKAGE_VER, description, KAboutData::License_GPL_V2,
			     "(c) 2004 Michael Buesch", 0, 0,
			     "mbuesch@freenet.de");
	aboutData.addAuthor("Michael Buesch",
			    "programmer and maintainer",
			    "mbuesch@freenet.de");

	KCmdLineArgs::init(argc, argv, &aboutData);
	KCmdLineArgs::addCmdLineOptions(options);

	KApplication a;
	EmuTest em(&a);
	em.init();
	return a.exec();
}
