/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004, 2005  by Michael Buesch                           *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "masterkey/masterkey.h"
#include "masterkey/newmasterkeywndimpl.h"
#include "pwmexception.h"

#ifdef CONFIG_PWMANAGER_SMARTCARD
# include "masterkey/smartkey/smartkey.h"
#endif

#include <kpassdlg.h>
#include <klocale.h>
#include <kmessagebox.h>


MasterKey::MasterKey(QWidget *_parent)
 : parent (_parent)
{
}

MasterKey::~MasterKey()
{
}

MasterKey::Type MasterKey::requestNewKey(QByteArray *key, Type type)
{
	Type ret = type_none;
	NewMasterKeyWndImpl wnd(parent);

	if (type != type_none)
		wnd.setAllowedType(type);
	if (!wnd.exec())
		goto out;
	ret = wnd.getLastKey(key);
	PWM_ASSERT(ret != type_none);
	PWM_ASSERT(ret != type_ok);
	PWM_ASSERT(ret != type_notimpl);
	if (type != type_none)
		PWM_ASSERT(ret == type);
out:
	return ret;
}

MasterKey::Type MasterKey::requestNewKey(QString *key, Type type)
{
	Type ret;
	QByteArray tmp;
	ret = requestNewKey(&tmp, type);
	*key = QString();
	key->append(tmp);
	return ret;
}

MasterKey::Type MasterKey::requestKey(QByteArray *key, Type type)
{
	switch (type) {
	case type_none:
	case type_ok:
	case type_notimpl:
	default:
		break;
	case type_password:
		return requestPassword(key);
	case type_keyfile:
		return requestKeyfile(key);
#ifdef CONFIG_PWMANAGER_SMARTCARD
	case type_smartcard:
		return requestSmartkey(key);
#endif // CONFIG_PWMANAGER_SMARTCARD
	}
	return type_notimpl;
}

MasterKey::Type MasterKey::requestKey(QString *key, Type type)
{
	Type ret;
	QByteArray tmp;
	ret = requestKey(&tmp, type);
	*key = QString();
	key->append(tmp);
	return ret;
}

#ifdef CONFIG_PWMANAGER_SMARTCARD
MasterKey::Type MasterKey::requestSmartkey(QByteArray *key)
{
	SmartKey sk(parent);
	if (!sk.requestKey(key))
		return type_none;
	return type_ok;
}
#endif

MasterKey::Type MasterKey::requestPassword(QByteArray *key)
{
	QCString password;
	int result;
	result = KPasswordDialog::getPassword(password, i18n("Please enter the Master Password."));
	if (result != KPasswordDialog::Accepted)
		return type_none;
	// make sure to strip the terminating NUL char.
	key->duplicate(password.data(), password.size() - 1);
	return type_ok;
}

MasterKey::Type MasterKey::requestKeyfile(QByteArray * /*key*/)
{//TODO
	return type_notimpl;
}

void MasterKey::wrongKeyMsg(Type type)
{
	QString caption;
	QString text;
	switch (type) {
	case type_password:
		caption = i18n("Wrong Password");
		text = i18n("Wrong Master Password.\n"
			    "Please try again with the correct Password.");
		break;
	case type_smartcard:
		caption = i18n("Wrong SmartKey");
		text = i18n("Wrong Master SmartKey.\n"
			    "Please try again with the correct SmartKey (SmartCard).");
		break;
	case type_keyfile:
		break;
	case type_none:
		PWM_ASSERT(false);
	case type_ok:
		PWM_ASSERT(false);
	case type_notimpl:
		PWM_ASSERT(false);
	}
	KMessageBox::error(parent, text, caption);
}
