## dialog.py
## 
## Copyright (C) 2005-2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import pygtk
pygtk.require('2.0')
import gtk

import pyNeighborhood
import threads

def dialog(text, parent):
    msg = gtk.MessageDialog(parent, gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT, 
                            gtk.MESSAGE_WARNING, gtk.BUTTONS_CLOSE, text)
    msg.connect("response", lambda d, r: d.destroy())
    msg.show()
    return
		
def about(parent):
    text= ("pyNeighborhood 0.4.1\n"
           "Copyright \302\251 2005-2006 Mykola Lynnyk\n"
           "Home: http://pyneighborhood.sourceforge.net\n" 
           "\n"
           "Patches by:\n"
           "Gregoire Gentil\n"
           "Betz Stefan\n"
           "\n"
           "Distributed under the terms of the GNU General Public License")
    msg = gtk.MessageDialog(parent, gtk.DIALOG_MODAL |gtk.DIALOG_DESTROY_WITH_PARENT, 
								gtk.MESSAGE_INFO, gtk.BUTTONS_CLOSE, text)

    msg.connect ("response", lambda d, r: d.destroy())
    msg.show()
    return

#
# User and password prompt dialog
#
def user_password(parent, label):
    msg = gtk.Dialog(label,
                     parent,
                     gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                     (gtk.STOCK_OK, gtk.RESPONSE_OK,
                     gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))

    vbox = gtk.VBox(True, 20)
    msg.set_resizable(False)

    #
    # Username
    #
    hbox = gtk.HBox(True, 10)
    hbox.set_border_width(5)
    lbl_user = gtk.Label("User:")
    lbl_user.show()
    lbl_user.set_alignment(0, 0.5)
    hbox.pack_start(lbl_user, True, True, 0)

    entry_user = gtk.Entry()
    entry_user.set_max_length(50)
    entry_user.select_region(0, len(entry_user.get_text()))
    hbox.pack_start(entry_user, True, True, 0)
    entry_user.show()
    msg.vbox.pack_start(hbox, True, True, 0)

    #
    # Password
    #
    hbox = gtk.HBox(True, 10)
    hbox.set_border_width(5)
    lbl_password = gtk.Label("Password:")
    lbl_password.show()
    lbl_password.set_alignment(0, 0.5)
    hbox.pack_start(lbl_password, True, True, 0)

    entry_password = gtk.Entry()
    entry_password.set_max_length(50)
    entry_password.select_region(0, len(entry_password.get_text()))
    entry_password.set_visibility(False)
    hbox.pack_start(entry_password, True, True, 0)
    entry_password.show()
    msg.vbox.pack_start(hbox, True, True, 0)
    
    user_text = pyNeighborhood.user
    if user_text == "":
        user_text = pyNeighborhood.parser.get_value("user")
    if user_text == None:
        user_text = ""

    password_text = pyNeighborhood.password
    if password_text == "":
        password_text = pyNeighborhood.parser.get_value("password")
    if password_text == None:
        password_text = ""
    
    entry_user.set_text(user_text)
    entry_password.set_text(password_text)

    msg.show_all()
    response = msg.run()
    if response == gtk.RESPONSE_OK:
        pyNeighborhood.user = entry_user.get_text()
        pyNeighborhood.password = entry_password.get_text()
        msg.destroy()
        return True
       
    if response == gtk.RESPONSE_CANCEL: 
        msg.destroy()
        return False
    msg.destroy()
    return False

#
# Class handling adding and editing host in bookmarks
#
class EditMachine:
    #
    #
    #
    def retrieve_callback(self, button):
        button.set_sensitive(False)
        self.entry_name.set_sensitive(False)
        self.entry_ip.set_sensitive(False)
        self.entry_display.set_sensitive(False)
        thr = threads.RetrieveData_Thread(button, self.entry_name, self.entry_ip, self.entry_display)
        thr.start()

    #
    # Describes main GUI
    #
    def machine_gui(self, label):
        msg = gtk.Dialog(label,
                         self.parent,
                         gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                         (gtk.STOCK_OK, gtk.RESPONSE_OK,
                         gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))
        
        vbox = gtk.VBox(True, 20)
        msg.set_resizable(False)

        #
        # Netbios name
        #
        hbox = gtk.HBox(True, 10)
        hbox.set_border_width(5)
        lbl_name = gtk.Label("Network name:")
        lbl_name.show()
        lbl_name.set_alignment(1.0, 0.5)
        hbox.pack_start(lbl_name, True, True, 0)

        entry_name = gtk.Entry()
        entry_name.set_max_length(50)
        entry_name.select_region(0, len(entry_name.get_text()))
        hbox.pack_start(entry_name, True, True, 0)
        entry_name.show()
        msg.vbox.pack_start(hbox, True, True, 0)
        self.entry_name = entry_name

        #
        # IP
        #
        hbox = gtk.HBox(True, 10)
        hbox.set_border_width(5)
        lbl_ip = gtk.Label("IP address:")
        lbl_ip.show()
        lbl_ip.set_alignment(1.0, 0.5)
        hbox.pack_start(lbl_ip, True, True, 0)

        entry_ip = gtk.Entry()
        entry_ip.set_max_length(50)
        entry_ip.select_region(0, len(entry_ip.get_text()))
        hbox.pack_start(entry_ip, True, True, 0)
        entry_name.show()
        msg.vbox.pack_start(hbox, True, True, 0)
        self.entry_ip = entry_ip

        #
        # Display entry
        #
        hbox = gtk.HBox(True, 10)
        hbox.set_border_width(5)
        lbl_display = gtk.Label("Display in a list as:")
        lbl_display.show()
        lbl_display.set_alignment(1.0, 0.5)
        hbox.pack_start(lbl_display, True, True, 0)

        entry_display = gtk.Entry()
        entry_display.set_max_length(50)
        entry_display.select_region(0, len(entry_display.get_text()))
        hbox.pack_start(entry_display, True, True, 0)
        entry_display.show()
        msg.vbox.pack_start(hbox, True, True, 0)
        self.entry_display = entry_display

        #
        # Query button
        #
        hbox = gtk.HBox(True, 10)
        hbox.set_border_width(5)
        button = gtk.Button("Try to retrieve missing data")
        button.connect("pressed",self.retrieve_callback)
        hbox.pack_start(button, True, True, 0)

        msg.vbox.pack_start(hbox, True, True, 0)
        #
        # Button object for retrieve_callback
        #
        self.pressbutton = button
        return msg, entry_name, entry_ip, entry_display


    #
    # Handles host editing
    #
    def editmachine(self,parentwidget):
        msg, entry_name, entry_ip, entry_display = self.machine_gui("Edit Machine")
    
        treeselection = parentwidget.treeview.get_selection()
        (model, iter) = treeselection.get_selected()
        path = model.get_path(iter)
        model = parentwidget.treeview.get_model()
        iter = model.get_iter(path)
        current_host = model.get_value(iter, 0)
        item = pyNeighborhood.hosts.find(current_host)
        
        #
        # Set existing values
        #
        entry_display.set_text(current_host)
        entry_ip.set_text(item["ip"])
        entry_name.set_text(item["netbios"])

        msg.show_all()
        response = msg.run()
        if response == gtk.RESPONSE_OK: 
            name = entry_name.get_text()
            ip = entry_ip.get_text()
            display = entry_display.get_text()
            
            if not pyNeighborhood.ip_validator(ip) and ip!= '':
                dialog("Invalid IP has been entered, restoring", self.parent)
                ip = item["ip"]
                
            if name == '' and ip == '':
                dialog("IP and Name fields can not leave empty both", self.parent)
                msg.destroy()
                return None, None, None
            else:
                if display == '' and name != '':
                    display = name
                else:
                    if display == '' and ip != '':
                        display = ip
            
            msg.destroy()
            return display, name, ip 
        if response == gtk.RESPONSE_CANCEL: 
            msg.destroy()
            return None, None, None
        msg.destroy()
    
    #
    # Handles host adding
    #
    def addmachine(self):
        msg, entry_name, entry_ip, entry_display = self.machine_gui("Add Machine")
    
        msg.show_all()
        response = msg.run()
        if response == gtk.RESPONSE_OK: 
            name = entry_name.get_text()
            ip = entry_ip.get_text()
            display = entry_display.get_text()

            if not pyNeighborhood.ip_validator(ip) and ip!= '':
                dialog("Invalid IP has been entered, clearing", self.parent)
                ip = ''

            if name == '' and ip == '':
                dialog("IP and Name fields can not leave empty both", self.parent)
                msg.destroy()
                return None, None, None
            else:
                if display == '' and name != '':
                    display = name
                else:
                    if display == '' and ip != '':
                        display = ip
            
            msg.destroy()
            return display, name, ip 
        if response == gtk.RESPONSE_CANCEL: 
            msg.destroy()
            return None, None, None
        msg.destroy()
        return None, None, None
    #
    # Handles host adding from group
    #
    def addmachine_group(self,parentwidget):
        msg, entry_name, entry_ip, entry_display = self.machine_gui("Add Machine")
    
        treeselection = parentwidget.treeview.get_selection()
        (model, iter) = treeselection.get_selected()
        path = model.get_path(iter)
        model = parentwidget.treeview.get_model()
        iter = model.get_iter(path)
        current_host = model.get_value(iter, 0)
        
        #
        # Set existing values
        #
        entry_name.set_text(current_host)

        #
        # Try to retrieve IP instantly
        #
        if pyNeighborhood.parser.get_value("autoretrieve_ip") == "True":
            self.retrieve_callback(self.pressbutton)

        msg.show_all()
        response = msg.run()
        if response == gtk.RESPONSE_OK: 
            name = entry_name.get_text()
            ip = entry_ip.get_text()
            display = entry_display.get_text()

            if name == '' and ip == '':
                dialog("IP and Name fields can not leave empty both", parent)
                msg.destroy()
                return None, None, None
            else:
                if display == '' and name != '':
                    display = name
                else:
                    if display == '' and ip != '':
                        display = ip
            
            msg.destroy()
            return display, name, ip 
        if response == gtk.RESPONSE_CANCEL: 
            msg.destroy()
            return None, None, None
        msg.destroy()
    
    #
    # Constructor
    #
    def __init__(self, parent):
        self.parent = parent

