"""
Q7Z: P7Zip GUI
Designed by Chris Giles

File:		Display.py
Purpose:	Display handler
"""


### Imports

# Q7Z 1
import	Import

# Python
try :
	import	sys
except :
	Import.slException( "Python" )

# PyQt4
try :
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException( "PyQt4" )

# Q7Z 2
import	Main, Settings
"""
try :
	from	Main_ui			import Ui_Main
	from	Main_rc			import *
	from	Settings_ui		import Ui_Settings
	from	Settings_rc		import *
except :
	Import.slException( Settings.Application.sName )
"""

### Slots

# Display init
def slInit() :

	# Visible?
	if not Import.Init.bInvisible :

		# Show the GUI?
		if not Settings.Setting.Geometry.bPosition :
			Main.mwMain.move( QtGui.QApplication.desktop().screen().rect().center() - Main.mwMain.rect().center() )
		
		Main.mwMain.show()


# Choose the source creation directory
def slCGetSDir() :
	Main.uiMain.leSDir.setText( QtGui.QFileDialog.getExistingDirectory( None , "" , Main.uiMain.leSDir.displayText() ) )

# Choose the source extraction archive
def slEGetSArc() :
	dOutput = QtCore.QDir()
	dOutput.setPath( Main.uiMain.leArchive.displayText() )
	Main.uiMain.leArchive.setText( QtGui.QFileDialog.getOpenFileName( None , "" , dOutput.path() ,
		"Archives (*.exe *.7z *.bz2 *.zip *.rpm *.deb *.gz *.tar *.cab *.msi *.wim *.arj *.cpio *.rar *.chm *.iso *.lzh *.lha *.nsi *.z *.001)" ) )

# Choose the destination creation directory
def slCGetDDir() :
	Main.uiMain.leCDDir.setText( QtGui.QFileDialog.getExistingDirectory( None , "" , Main.uiMain.leCDDir.displayText() ) )

# Choose the destination extraction directory
def slEGetDDir() :
	Main.uiMain.leEDDir.setText( QtGui.QFileDialog.getExistingDirectory( None , "" , Main.uiMain.leEDDir.displayText() ) )


# Enable or disable items
def slToggles() :

	# Check boxes
	# Destinations
	if not Main.uiMain.gbCDestination.isChecked() :
		Main.uiMain.cbStructured.setCheckState( QtCore.Qt.Unchecked )
		Main.uiMain.cbSeparate.setCheckState( QtCore.Qt.Unchecked )
	Main.uiMain.cbCName.setEnabled( not Main.uiMain.cbSeparate.isChecked() )
	Main.uiMain.cbCTest.setEnabled( not Main.uiMain.cbSeparate.isChecked() )
	# Separate
	if Main.uiMain.cbSeparate.isChecked() :
		Main.uiMain.cbCName.setCheckState( QtCore.Qt.Unchecked )
		Main.uiMain.cbCTest.setCheckState( QtCore.Qt.Unchecked )
	if not Main.uiMain.gbEDestination.isChecked() :
		Main.uiMain.cbBeneath.setCheckState( QtCore.Qt.Unchecked )

	# Line edits
	Main.uiMain.leCName.setEnabled( Main.uiMain.cbCName.isChecked() )
	Main.uiMain.leCPassword.setEnabled( Main.uiMain.cbCPassword.isChecked() )
	Main.uiMain.leEName.setEnabled( Main.uiMain.cbEName.isChecked() )
	Main.uiMain.leEPassword.setEnabled( Main.uiMain.cbEPassword.isChecked() )


# GUI Profile Get Create
def slGuiProfileGetCreate( oPI ) :

	# Source
	oPI.Source.slFiles.clear()
	if not Import.Init.bInvisible and Settings.Input.iNumArgs < 3 :
		if not Main.uiMain.leSDir.displayText().isEmpty() :
			oPI.Source.slFiles.append( Main.uiMain.leSDir.displayText() )
	else :
		oPI.Source.slFiles << Settings.List.slFiles
	oPI.Source.iNext		= 0

	# Misc
	oPI.bTest				= False
	oPI.bSuccess			= True
	oPI.iProgress			= 0

	# Visible?
	if not Import.Init.bInvisible :

		# Type
		oPI.Type.sAlgorithm 	= Main.uiMain.cbAlgorithm.currentText()
		oPI.Type.sMethod		= Main.uiMain.cbMethod.currentText()
		oPI.Type.sComp			= Main.uiMain.cbComp.currentText()
		oPI.Type.sVolume		= Main.uiMain.cbVolume.currentText()
		oPI.Type.bSFX			= Main.uiMain.cbSFX.isChecked()
		oPI.Type.bSolid			= Main.uiMain.cbSolid.isChecked()
		oPI.Type.bTarball		= Main.uiMain.cbTarball.isChecked()

		# Security
		oPI.Security.bScramble	= Main.uiMain.cbScramble.isChecked()
		oPI.Security.bPassword	= Main.uiMain.cbCPassword.isChecked()
		oPI.Security.sPassword	= Main.uiMain.leCPassword.displayText()

		# Destination
		oPI.Dest.bDest			= Main.uiMain.gbCDestination.isChecked()
		oPI.Dest.bStructured	= Main.uiMain.cbStructured.isChecked()
		oPI.Dest.bSeparate	= Main.uiMain.cbSeparate.isChecked()
		oPI.Dest.sDir			= Main.uiMain.leCDDir.displayText()
		oPI.Dest.bName			= Main.uiMain.cbCName.isChecked()
		oPI.Dest.sName			= Main.uiMain.leCName.displayText()
		oPI.Dest.bBeneath		= False

		# Misc
		oPI.bTest				= Main.uiMain.cbCTest.isChecked()


# GUI Profile Set Create
def slGuiProfileSetCreate( oPI ) :

	# Visible?
	if not Import.Init.bInvisible :

		# Type
		Main.uiMain.cbAlgorithm.setCurrentIndex( Main.uiMain.cbAlgorithm.findText( oPI.Type.sAlgorithm ) )
		Main.uiMain.cbMethod.setCurrentIndex( Main.uiMain.cbMethod.findText( oPI.Type.sMethod ) )
		Main.uiMain.cbComp.setCurrentIndex( Main.uiMain.cbComp.findText( oPI.Type.sComp ) )
		Main.uiMain.cbVolume.setCurrentIndex( Main.uiMain.cbVolume.findText( oPI.Type.sVolume ) )
		if not oPI.Type.bSFX :
			Main.uiMain.cbSFX.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbSFX.setCheckState( QtCore.Qt.Checked )
		if not oPI.Type.bSolid :
			Main.uiMain.cbSolid.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbSolid.setCheckState( QtCore.Qt.Checked )
		if not oPI.Type.bTarball :
			Main.uiMain.cbTarball.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbTarball.setCheckState( QtCore.Qt.Checked )
		# Security
		if not oPI.Security.bScramble :
			Main.uiMain.cbScramble.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbScramble.setCheckState( QtCore.Qt.Checked )
		if not oPI.Security.bPassword :
			Main.uiMain.cbCPassword.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbCPassword.setCheckState( QtCore.Qt.Checked )
		# Destination
		if not oPI.Dest.bDest :
			Main.uiMain.gbCDestination.setChecked( False )
		else :
			Main.uiMain.gbCDestination.setChecked( True )
		if not oPI.Dest.bStructured :
			Main.uiMain.cbStructured.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbStructured.setCheckState( QtCore.Qt.Checked )
		if not oPI.Dest.bSeparate :
			Main.uiMain.cbSeparate.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbSeparate.setCheckState( QtCore.Qt.Checked )
		Main.uiMain.leCDDir.setText( oPI.Dest.sDir )
		if not oPI.Dest.bName :
			Main.uiMain.cbCName.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbCName.setCheckState( QtCore.Qt.Checked )

# GUI Profile Get Extract
def slGuiProfileGetExtract( oPI ) :

	# Source operation
	if oPI.iSource == Settings.Operation.iCreate :

		# Security
		oPI.Security.bPassword	= Main.uiMain.cbCPassword.isChecked()
		oPI.Security.sPassword	= Main.uiMain.leCPassword.displayText()

	else :

		# Source
		oPI.Source.slFiles.clear()
		if not Import.Init.bInvisible and Settings.Input.iNumArgs < 3 :
			#if not Main.uiMain.leArchive.displayText().isEmpty() :
			oPI.Source.slFiles.append( Main.uiMain.leArchive.displayText() )
		else :
			oPI.Source.slFiles << Settings.List.slFiles
		oPI.Source.iNext		= 0

		# Destination
		oPI.Dest.bBeneath		= False

		# Misc
		oPI.bTest				= False
		oPI.bSuccess			= True
		oPI.iProgress			= 0

		# Visible?
		if not Import.Init.bInvisible :

			# Security
			oPI.Security.bPassword	= Main.uiMain.cbEPassword.isChecked()
			oPI.Security.sPassword	= Main.uiMain.leEPassword.displayText()

			# Destination
			oPI.Dest.bDest			= Main.uiMain.gbEDestination.isChecked()
			oPI.Dest.bBeneath		= Main.uiMain.cbBeneath.isChecked()
			oPI.Dest.sDir			= Main.uiMain.leEDDir.displayText()
			oPI.Dest.bName			= Main.uiMain.cbEName.isChecked()
			oPI.Dest.sName			= Main.uiMain.leEName.displayText()

			# Misc
			oPI.bTest				= Main.uiMain.cbETest.isChecked()


# Progress
def slProgress( iRetVal ) :

	# Visible?
	if not Import.Init.bInvisible :

		# Update
		Main.uiMain.pbComplete.setValue( iRetVal )

# Enable GUI
def slEnableGUI() :

	# Visible?
	if not Import.Init.bInvisible :

		Main.uiMain.aStaStop.setEnabled( False )
		Main.uiMain.pbStop.setEnabled( False )
		Main.uiMain.pbComplete.setEnabled( False )
		Main.uiMain.twOperations.setEnabled( True )

		slOperation( Settings.Operation.iClear )

# Disable GUI
def slDisableGUI() :

	# Visible?
	if not Import.Init.bInvisible :
	
		# Reset or disable items
		Main.uiMain.twOperations.setEnabled( False )
		Main.uiMain.aStaStop.setEnabled( True )
		Main.uiMain.pbComplete.setEnabled( True )
		Main.uiMain.pbStop.setEnabled( True )
		Main.uiMain.pbComplete.setValue( 0 )

# External files
def slGUIExternal( iOperation ) :

	# Visible?
	if not Import.Init.bInvisible :
	
		# Create
		Main.uiMain.leSDir.setText( "External File(s)" )
		Main.uiMain.leSDir.setEnabled( False )
		Main.uiMain.pbSDir.setEnabled( False )

		# Extract
		Main.uiMain.leArchive.setText( "External File(s)" )
		Main.uiMain.leArchive.setEnabled( False )
		Main.uiMain.pbSArc.setEnabled( False )

		# FIXME: These lines are minor hacks
		Settings.Input.iNumArgs = 3

		# Operation
		if iOperation == Settings.Operation.iCreate :
			Main.uiMain.twOperations.setCurrentIndex( 0 )
			Main.uiMain.twOperations.setTabEnabled( 1 , False )
			Main.uiMain.pbCreate.setDefault( True )
		elif iOperation == Settings.Operation.iExtract :
			Main.uiMain.twOperations.setCurrentIndex( 1 )
			Main.uiMain.twOperations.setTabEnabled( 0 , False )
			Main.uiMain.pbExtract.setDefault( True )
		elif iOperation == Settings.Operation.iTest :
			Main.uiMain.twOperations.setCurrentIndex( 1 )
			Main.uiMain.twOperations.setTabEnabled( 0 , False )
			Main.uiMain.pbExtract.setDefault( True )
			Main.uiMain.cbETest.setChecked( True )

# Beneath
def slGUIBeneath() :

	# Visible?
	if not Import.Init.bInvisible :
		Main.uiMain.gbEDestination.setChecked( True )
		Main.uiMain.cbBeneath.setCheckState( QtCore.Qt.Checked )

# Operation
def slOperation( iOperation ) :

	if iOperation == Settings.Operation.iClear :
		slStatus( "" )
		slTitle( Settings.Application.sName )
	elif iOperation == Settings.Operation.iCheck :
		slStatus( Settings.Message.sChecking )
		slTitle( Settings.Application.sName + " - " + Settings.Message.sChecking )
	elif iOperation == Settings.Operation.iLaunch :
		slStatus( Settings.Message.sLaunching )
		#slTitle( Settings.Application.sName + " - " + Settings.Message.sLaunching )
	elif iOperation == Settings.Operation.iCreate :
		# TODO: Do I still need these?
		#Main.uiMain.leArchive.setText( "" )
		slStatus( Settings.Message.sCreating )
		slTitle( Settings.Application.sName + " - " + Settings.Message.sCreating )
	elif iOperation == Settings.Operation.iExtract :
		#Main.uiMain.leSDir.setText( "" )
		slStatus( Settings.Message.sExtracting )
		slTitle( Settings.Application.sName + " - " + Settings.Message.sExtracting )
	elif iOperation == Settings.Operation.iTest :
		#Main.uiMain.leSDir.setText( "" )
		slStatus( Settings.Message.sTesting )
		slTitle( Settings.Application.sName + " - " + Settings.Message.sTesting )

# Title
def slTitle( sMessage ) :

	# Visible?
	if not Import.Init.bInvisible :
		Main.mwMain.setWindowTitle( sMessage )

# Status
def slStatus( sMessage ) :

	# Visible?
	if not Import.Init.bInvisible :
		Main.uiMain.sbMain.showMessage( sMessage )

# Message
def slMessage( sMessage ) :

	# Is main window visible?
	if sMessage != "" and not Import.Init.bInvisible :
	#if sMessage != "" and Main.mwMain.isVisible() :
		return QtGui.QMessageBox.information( QtGui.QWidget(), Settings.Application.sName + " - Message", sMessage, QtGui.QMessageBox.Ok )

# Question
def slQuestion( sMessage ) :

	# Is main window visible?
	#if sMessage != "" and Main.mwMain.isVisible() :
	if sMessage != "" and not Import.Init.bInvisible :
		return QtGui.QMessageBox.question( QtGui.QWidget(), Settings.Application.sName + " - Question", sMessage, QtGui.QMessageBox.Yes | QtGui.QMessageBox.No )

# Error
def slError( sMessage ) :

	if sMessage != "" :
		# Visible?
		if not Import.Init.bInvisible :
			QtGui.QErrorMessage.showMessage( QtGui.QErrorMessage.qtHandler() , sMessage )
		else :
			print sMessage
			slExit()


# No binaries
def slNoBin( sApp ) :

	sMessage = "Error: The required '" + sApp + "' executable file could not be found.  See 'Doc/INSTALL.txt' for more info."

	# Visible?
	if not Import.Init.bInvisible :
		QtGui.QErrorMessage.showMessage( QtGui.QErrorMessage.qtHandler() , sMessage )
	else :
		print "\n" + sMessage + "\n"


# Exit
def slExit() :

	# Visible?
	if not Import.Init.bInvisible :

		# Save
		Settings.slSave()

		# Close main window
		Main.mwMain.close()
	
	else :
		
		# Shell exit
		sys.exit()
