"""
Q7Z: P7Zip GUI
Designed by Chris Giles

File:		Event.py
Purpose:	Event handler
"""


### Imports

# Q7Z 1
import	Import

# Python
try :
	import	sys
except :
	Import.slException( "Python" )

# PyQt4
try :
	from	PyQt4	import QtCore
except :
	Import.slException( "PyQt4" )

# Q7Z 2
import	Display, Help, List, Main, Profile, Settings, Thread


### Slots

def slConnections():

	# Processes
	Thread.tiCreate.connect( Thread.tiCreate, QtCore.SIGNAL( "done(int)" ), Thread.slArcDone )
	Thread.tiCreate.connect( Thread.tiCreate, QtCore.SIGNAL( "error(QString)" ), Thread.slError )
	Thread.tiCreate.connect( Thread.tiCreate, QtCore.SIGNAL( "operation(int)" ), Display.slOperation )
	Thread.tiExtract.connect( Thread.tiExtract, QtCore.SIGNAL( "done(int)" ), Thread.slArcDone )
	Thread.tiExtract.connect( Thread.tiExtract, QtCore.SIGNAL( "error(QString)" ), Thread.slError )
	Thread.tiExtract.connect( Thread.tiExtract, QtCore.SIGNAL( "operation(int)" ), Display.slOperation )

	# Visible?
	if not Import.Init.bInvisible :

		# Actions
		Main.uiMain.aSettings.connect( Main.uiMain.aSettings, QtCore.SIGNAL( "triggered()" ), Settings.slDialog )
		Main.uiMain.aStaStop.connect( Main.uiMain.aStaStop, QtCore.SIGNAL( "triggered()" ), Thread.slArcStop )
		Main.uiMain.aStaExit.connect( Main.uiMain.aStaExit, QtCore.SIGNAL( "triggered()" ), Display.slExit )

		# Profiles
		Main.uiMain.aLOther.connect( Main.uiMain.aLOther, QtCore.SIGNAL( "triggered()" ), Profile.slLoadOther )
		Main.uiMain.aLDefault.connect( Main.uiMain.aLDefault, QtCore.SIGNAL( "triggered()" ), Profile.slLoadDefault )
		Main.uiMain.aLFlash.connect( Main.uiMain.aLFlash, QtCore.SIGNAL( "triggered()" ), Profile.slLoadFlash )
		Main.uiMain.aLLocal.connect( Main.uiMain.aLLocal, QtCore.SIGNAL( "triggered()" ), Profile.slLoadLocal )
		Main.uiMain.aLRemote.connect( Main.uiMain.aLRemote, QtCore.SIGNAL( "triggered()" ), Profile.slLoadRemote )
		Main.uiMain.aLSecure.connect( Main.uiMain.aLSecure, QtCore.SIGNAL( "triggered()" ), Profile.slLoadSecure )
		Main.uiMain.aLStorage.connect( Main.uiMain.aLStorage, QtCore.SIGNAL( "triggered()" ), Profile.slLoadStorage )
		Main.uiMain.aSOther.connect( Main.uiMain.aSOther, QtCore.SIGNAL( "triggered()" ), Profile.slSaveOther )
		Main.uiMain.aSDefault.connect( Main.uiMain.aSDefault, QtCore.SIGNAL( "triggered()" ), Profile.slSaveDefault )
		Main.uiMain.aSFlash.connect( Main.uiMain.aSFlash, QtCore.SIGNAL( "triggered()" ), Profile.slSaveFlash )
		Main.uiMain.aSLocal.connect( Main.uiMain.aSLocal, QtCore.SIGNAL( "triggered()" ), Profile.slSaveLocal )
		Main.uiMain.aSRemote.connect( Main.uiMain.aSRemote, QtCore.SIGNAL( "triggered()" ), Profile.slSaveRemote )
		Main.uiMain.aSSecure.connect( Main.uiMain.aSSecure, QtCore.SIGNAL( "triggered()" ), Profile.slSaveSecure )
		Main.uiMain.aSStorage.connect( Main.uiMain.aSStorage, QtCore.SIGNAL( "triggered()" ), Profile.slSaveStorage )
		Main.uiMain.aRDefault.connect( Main.uiMain.aRDefault, QtCore.SIGNAL( "triggered()" ), Profile.slResetDefault )
		Main.uiMain.aRFlash.connect( Main.uiMain.aRFlash, QtCore.SIGNAL( "triggered()" ), Profile.slResetFlash )
		Main.uiMain.aRLocal.connect( Main.uiMain.aRLocal, QtCore.SIGNAL( "triggered()" ), Profile.slResetLocal )
		Main.uiMain.aRRemote.connect( Main.uiMain.aRRemote, QtCore.SIGNAL( "triggered()" ), Profile.slResetRemote )
		Main.uiMain.aRSecure.connect( Main.uiMain.aRSecure, QtCore.SIGNAL( "triggered()" ), Profile.slResetSecure )
		Main.uiMain.aRStorage.connect( Main.uiMain.aRStorage, QtCore.SIGNAL( "triggered()" ), Profile.slResetStorage )

		# Lists
		Main.uiMain.aLLoad.connect( Main.uiMain.aLLoad, QtCore.SIGNAL( "triggered()" ), List.slLoadOther )
		Main.uiMain.aLEdit.connect( Main.uiMain.aLEdit, QtCore.SIGNAL( "triggered()" ), List.slEditOther )
		Main.uiMain.aLSave.connect( Main.uiMain.aLSave, QtCore.SIGNAL( "triggered()" ), List.slSaveOther )

		# About
		Main.uiMain.aAQ7Z.connect( Main.uiMain.aAQ7Z, QtCore.SIGNAL( "triggered()" ), Help.slAboutQ7Z )
		Main.uiMain.aAQt4.connect( Main.uiMain.aAQt4, QtCore.SIGNAL( "triggered()" ), Help.slAboutQt4 )

		# URLs
		Main.uiMain.aUQ7Z.connect( Main.uiMain.aUQ7Z, QtCore.SIGNAL( "triggered()" ), Help.slUQ7Z )
		Main.uiMain.aUP7Zip.connect( Main.uiMain.aUP7Zip, QtCore.SIGNAL( "triggered()" ), Help.slUP7Zip )
		Main.uiMain.aU7_Zip.connect( Main.uiMain.aU7_Zip, QtCore.SIGNAL( "triggered()" ), Help.slU7_Zip )
		Main.uiMain.aUMake.connect( Main.uiMain.aUMake, QtCore.SIGNAL( "triggered()" ), Help.slUMake )
		Main.uiMain.aUQt4.connect( Main.uiMain.aUQt4, QtCore.SIGNAL( "triggered()" ), Help.slUQt4 )
		Main.uiMain.aUTar.connect( Main.uiMain.aUTar, QtCore.SIGNAL( "triggered()" ), Help.slUTar )
		Main.uiMain.aUPyQt4.connect( Main.uiMain.aUPyQt4, QtCore.SIGNAL( "triggered()" ), Help.slUPyQt4 )
		Main.uiMain.aUPython.connect( Main.uiMain.aUPython, QtCore.SIGNAL( "triggered()" ), Help.slUPython )
		Main.uiMain.aUCheckInstall.connect( Main.uiMain.aUCheckInstall, QtCore.SIGNAL( "triggered()" ), Help.slUCheckInstall )
		Main.uiMain.aUEric.connect( Main.uiMain.aUEric, QtCore.SIGNAL( "triggered()" ), Help.slUEric )

		# Update
		Main.uiMain.aUpdate.connect( Main.uiMain.aUpdate, QtCore.SIGNAL( "triggered()" ), Help.slUBegin )

		# Feedback
		Main.uiMain.aFBGood.connect( Main.uiMain.aFBGood, QtCore.SIGNAL( "triggered()" ), Help.slFBGood )
		Main.uiMain.aFBBad.connect( Main.uiMain.aFBBad, QtCore.SIGNAL( "triggered()" ), Help.slFBBad )
		Main.uiMain.aFBIdea.connect( Main.uiMain.aFBIdea, QtCore.SIGNAL( "triggered()" ), Help.slFBIdea )

		# Documents
		Main.uiMain.aDAuthors.connect( Main.uiMain.aDAuthors, QtCore.SIGNAL( "triggered()" ), Help.slDocAuthors )
		Main.uiMain.aDChanges.connect( Main.uiMain.aDChanges, QtCore.SIGNAL( "triggered()" ), Help.slDocChanges )
		Main.uiMain.aDCopying.connect( Main.uiMain.aDCopying, QtCore.SIGNAL( "triggered()" ), Help.slDocCopying )
		Main.uiMain.aDInstall.connect( Main.uiMain.aDInstall, QtCore.SIGNAL( "triggered()" ), Help.slDocInstall )
		Main.uiMain.aDIssues.connect( Main.uiMain.aDIssues, QtCore.SIGNAL( "triggered()" ), Help.slDocIssues )
		Main.uiMain.aDLicence.connect( Main.uiMain.aDLicence, QtCore.SIGNAL( "triggered()" ), Help.slDocLicence )
		Main.uiMain.aDNews.connect( Main.uiMain.aDNews, QtCore.SIGNAL( "triggered()" ), Help.slDocNews )
		Main.uiMain.aDIntroduction.connect( Main.uiMain.aDIntroduction, QtCore.SIGNAL( "triggered()" ), Help.slDocIntroduction )
		Main.uiMain.aDRequests.connect( Main.uiMain.aDRequests, QtCore.SIGNAL( "triggered()" ), Help.slDocRequests )

		# Group Boxes
		Main.uiMain.gbCDestination.connect( Main.uiMain.gbCDestination, QtCore.SIGNAL( "toggled(bool)" ), Display.slToggles )
		Main.uiMain.gbEDestination.connect( Main.uiMain.gbEDestination, QtCore.SIGNAL( "toggled(bool)" ), Display.slToggles )

		# Check Boxes
		Main.uiMain.cbSeparate.connect( Main.uiMain.cbSeparate, QtCore.SIGNAL( "stateChanged(int)" ), Display.slToggles )
		Main.uiMain.cbCName.connect( Main.uiMain.cbCName, QtCore.SIGNAL( "stateChanged(int)" ), Display.slToggles )
		Main.uiMain.cbCPassword.connect( Main.uiMain.cbCPassword, QtCore.SIGNAL( "stateChanged(int)" ), Display.slToggles )
		Main.uiMain.cbEName.connect( Main.uiMain.cbEName, QtCore.SIGNAL( "stateChanged(int)" ), Display.slToggles )
		Main.uiMain.cbEPassword.connect( Main.uiMain.cbEPassword, QtCore.SIGNAL( "stateChanged(int)" ), Display.slToggles )

		# Push Buttons
		Main.uiMain.pbCreate.connect( Main.uiMain.pbCreate, QtCore.SIGNAL( "clicked()" ), Thread.slCreate )
		Main.uiMain.pbExtract.connect( Main.uiMain.pbExtract, QtCore.SIGNAL( "clicked()" ), Thread.slExtract )
		Main.uiMain.pbStop.connect( Main.uiMain.pbStop, QtCore.SIGNAL( "clicked()" ), Thread.slArcStop )

		Main.uiMain.pbSDir.connect( Main.uiMain.pbSDir, QtCore.SIGNAL( "clicked()" ), Display.slCGetSDir )
		Main.uiMain.pbSArc.connect( Main.uiMain.pbSArc, QtCore.SIGNAL( "clicked()" ), Display.slEGetSArc )
		Main.uiMain.pbCDDir.connect( Main.uiMain.pbCDDir, QtCore.SIGNAL( "clicked()" ), Display.slCGetDDir )
		Main.uiMain.pbEDDir.connect( Main.uiMain.pbEDDir, QtCore.SIGNAL( "clicked()" ), Display.slEGetDDir )

		Main.uiSettings.pbAccept.connect( Main.uiSettings.pbAccept, QtCore.SIGNAL( "clicked()" ), Settings.slAccept )
