"""
Q7Z: P7Zip GUI
Designed by Chris Giles

File:		Help.py
Purpose:	Help menu handler
"""


### Imports

# Q7Z 1
import	Import

# Python
try :
	import	random
except :
	Import.slException( "Python" )

# PyQt4
try :
	from	PyQt4	import QtCore, QtNetwork
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException( "PyQt4" )

# Q7Z 2
import	Display, Main, Settings


### Slots

# About Qt4
def slAboutQt4() :
	QtGui.QApplication.aboutQt()


# About Q7Z
def slAboutQ7Z() :
	QtGui.QMessageBox.about( Main.uiMain.centralwidget, "About " + Settings.Application.sName,
		"<b>" + Settings.Application.sName + "</b> " + Settings.Application.sVersion +
		"<br>Designed by " + Settings.Author.sName + "<br>"
		"<br>" + Settings.Application.sName + " is a P7Zip GUI for Linux, which attempts to simplify data compression and backup.<br>"
		"<br>Use " + Settings.Application.sName + " if you want to:<br>"
		"* Update existing archives quickly<br>"
		"* Backup folders to a storage location<br>"
		"* Create or extract protected archives<br>"
		"* Lessen effort by using archiving profiles<br>"
		"<br>Seek further information or send feedback via the 'Help' menu." )

# Open URL
def slUOpen( uURL ) :

	Display.slOperation( Settings.Operation.iLaunch )

	QtGui.QDesktopServices.openUrl( uURL )


# UIsNewer
def slUIsNewer( sLocal , sRemote ) :

	bNewer = False

	# Compare
	if not sLocal.isEmpty() and not sRemote.isEmpty() :

		# Major
		if sLocal[0].toInt() < sRemote[0].toInt() :
			bNewer = True
		elif sLocal[0].toInt() == sRemote[0].toInt() :
			# Minor
			if sLocal[2].toInt() < sRemote[2].toInt() :
				bNewer = True
			elif sLocal[2].toInt() == sRemote[2].toInt() :
				# Point
				if sLocal[4].toInt() < sRemote[4].toInt() :
					bNewer = True

	return bNewer


# Variables
Update = QtCore.QObject()
Update.bAuto = False
Update.hCurrent = QtNetwork.QHttp()

# Done
def slUDone( bError ) :
#def slUDone( iID , bError ) :

	"""
	# Verbose
	if Settings.Init.bVerbose is True :
		print "Update: slUDone"
	"""

	# Prevent recalls
	Update.hCurrent.disconnect( Update.hCurrent , QtCore.SIGNAL("done(bool)") , slUDone )

	if not bError :

		bGet = False
		bFound = False

		sData = QtCore.QString( Update.hCurrent.readAll() )
		#print sData

		if sData.isEmpty() :

			# Verbose
			if Settings.Init.bVerbose is True :
				print "Update: slUDone: Empty"

			slUBegin()

		elif sData.contains( "<HTML>" ) :

			# Verbose
			if Settings.Init.bVerbose is True :
				print "Update: slUDone: HTML"

			Display.slError( Settings.Message.Error.Network )

		else :

			slLines = QtCore.QStringList( sData.split( '\n' ) )
			sReqVer = QtCore.QString()
			sRecVer = QtCore.QString()

			while not slLines.isEmpty() :

				sLine = QtCore.QString( slLines.takeFirst() )
				slElems = QtCore.QStringList( sLine.split( ' ' ) )

				if slElems.count() == 3 :

					if slElems.first() == "Required" :
						sReqVer = str( slElems.last() )
						bFound = True ;
					elif slElems.first() == "Recommended" :
						sRecVer = str( slElems.last() )
						bFound = True ;

		if bFound :

			# Major
			if slUIsNewer( Settings.Application.sVersion , QtCore.QString(sReqVer) ) :

				bGet = Display.slQuestion( Settings.Application.sName + " " + sReqVer + " is now available.<br><br>Would you like to download this stable release now?" )

				# Verbose
				if Settings.Init.bVerbose is True :
					print "Update: slUDone: Major: " + sReqVer

			# Minor
			elif slUIsNewer( Settings.Application.sVersion , QtCore.QString(sRecVer) ) and not Update.bAuto :

				bGet = Display.slQuestion( Settings.Application.sName + " " + sRecVer + " is now available.<br><br>Would you like to download this beta release now?" )

				# Verbose
				if Settings.Init.bVerbose is True :
					print "Update: slUDone: Minor: " + sRecVer

			# None
			else :

				if not Update.bAuto :
					Display.slMessage( "You're already using the latest release." )

				# Verbose
				if Settings.Init.bVerbose is True :
					print "Update: slUDone: Current"

			# Get
			if bGet == QtGui.QMessageBox.Yes :

				# Launch
				slUOpen( QtCore.QUrl( Settings.Application.sDownload ) )

				# Exit
				#Main.uiMain.aStaExit.trigger()
				Display.slExit()

	else :

		# Verbose
		if Settings.Init.bVerbose is True :
			print "Update: slUDone: Error: " + Update.hCurrent.errorString()

		if not Update.bAuto :
			Display.slError( Settings.Message.Error.Network )

	Update.bAuto = False

	# Clear
	Display.slOperation( Settings.Operation.iClear )

# Begin
def slUBegin() :

	# Check
	Display.slOperation( Settings.Operation.iCheck )

	Update.hCurrent = QtNetwork.QHttp()
	Update.hCurrent.setHost( Settings.Application.sDomain )
	if not Settings.Path.Proxy.hostName().isEmpty() :
		Update.hCurrent.setProxy( Settings.Path.Proxy )
	Update.hCurrent.connect( Update.hCurrent , QtCore.SIGNAL("done(bool)") , slUDone )
	#Update.hCurrent.connect( Update.hCurrent , QtCore.SIGNAL("requestFinished(int,bool)") , slUDone )

	if not Update.hCurrent.get( Settings.Application.sCurrent ) and not Update.bAuto :
		Display.slError( Settings.Message.Error.Network )

# Begin
def slUCheck() :

	# Auto-Update
	if Settings.Init.bAutoUpdate and not Import.Init.bInvisible and not Settings.Init.bAutoExit :

		if random.randint( 0 , 25 ) == 20 :
		#if random.randint( 0 , 0 ) == 0 :

			# Silent
			Update.bAuto = True

			slUBegin()


# Feedback: Bad
def slFBBad() :

	# Set URL
	uURL = QtCore.QUrl( "mailto:" + Settings.Author.Email.sUser + Settings.Author.Email.sDomain + "?subject=" + Settings.Application.sName + " " + Settings.Application.sVersion + ": Feedback: Bad" )

	slUOpen( uURL )

# Feedback: Good
def slFBGood() :

	# Set URL
	uURL = QtCore.QUrl( "mailto:" + Settings.Author.Email.sUser + Settings.Author.Email.sDomain + "?subject=" + Settings.Application.sName + " " + Settings.Application.sVersion + ": Feedback: Good" )

	slUOpen( uURL )

# Feedback: Idea
def slFBIdea() :

	# Set URL
	uURL = QtCore.QUrl( "mailto:" + Settings.Author.Email.sUser + Settings.Author.Email.sDomain + "?subject=" + Settings.Application.sName + " " + Settings.Application.sVersion + ": Feedback: Idea" )

	slUOpen( uURL )


# URL: Q7Z
def slUQ7Z() :

	# Set URL
	uURL = QtCore.QUrl( "http://k7z.sourceforge.net/" )

	slUOpen( uURL )

# URL: Qt4
def slUQt4() :

	# Set URL
	uURL = QtCore.QUrl( "http://www.trolltech.com/products/qt" )

	slUOpen( uURL )

# URL: PyQt4
def slUPyQt4() :

	# Set URL
	uURL = QtCore.QUrl( "http://www.riverbankcomputing.co.uk/pyqt/" )

	slUOpen( uURL )

# URL: Python
def slUPython() :

	# Set URL
	uURL = QtCore.QUrl( "http://www.python.org/" )

	slUOpen( uURL )

# URL: 7-Zip
def slU7_Zip() :

	# Set URL
	uURL = QtCore.QUrl( "http://www.7-zip.org/" )

	slUOpen( uURL )

# URL: P7Zip
def slUP7Zip() :

	# Set URL
	uURL = QtCore.QUrl( "http://p7zip.sourceforge.net/" )

	slUOpen( uURL )

# URL: Tar
def slUTar() :

	# Set URL
	uURL = QtCore.QUrl( "http://www.gnu.org/software/tar/" )

	slUOpen( uURL )

# URL: Make
def slUMake() :

	# Set URL
	uURL = QtCore.QUrl( "http://www.gnu.org/software/make/" )

	slUOpen( uURL )

# URL: CheckInstall
def slUCheckInstall() :

	# Set URL
	uURL = QtCore.QUrl( "http://asic-linux.com.mx/~izto/checkinstall/" )

	slUOpen( uURL )

# URL: Eric
def slUEric() :

	# Set URL
	uURL = QtCore.QUrl( "http://www.die-offenbachs.de/eric/index.html" )

	slUOpen( uURL )


# Doc: Authors
def slDocAuthors() :

	# Set URL
	uURL = QtCore.QUrl( "file:" + Settings.Path.sQ7Z + Settings.Path.sSep + "Doc" + Settings.Path.sSep + "AUTHORS.txt" )

	slUOpen( uURL )

# Doc: Changes
def slDocChanges() :

	# Set URL
	uURL = QtCore.QUrl( "file:" + Settings.Path.sQ7Z + Settings.Path.sSep + "Doc" + Settings.Path.sSep + "ChangeLog.txt" )

	slUOpen( uURL )

# Doc: Copying
def slDocCopying() :

	# Set URL
	uURL = QtCore.QUrl( "file:" + Settings.Path.sQ7Z + Settings.Path.sSep + "Doc" + Settings.Path.sSep + "COPYING.txt" )

	slUOpen( uURL )

# Doc: Install
def slDocInstall() :

	# Set URL
	uURL = QtCore.QUrl( "file:" + Settings.Path.sQ7Z + Settings.Path.sSep + "Doc" + Settings.Path.sSep + "INSTALL.txt" )

	slUOpen( uURL )

# Doc: Issues
def slDocIssues() :

	# Set URL
	uURL = QtCore.QUrl( "file:" + Settings.Path.sQ7Z + Settings.Path.sSep + "Doc" + Settings.Path.sSep + "ISSUES.txt" )

	slUOpen( uURL )

# Doc: Licence
def slDocLicence() :

	# Set URL
	uURL = QtCore.QUrl( "file:" + Settings.Path.sQ7Z + Settings.Path.sSep + "Doc" + Settings.Path.sSep + "LICENCE.txt" )

	slUOpen( uURL )

# Doc: News
def slDocNews() :

	# Set URL
	uURL = QtCore.QUrl( "file:" + Settings.Path.sQ7Z + Settings.Path.sSep + "Doc" + Settings.Path.sSep + "NEWS.txt" )

	slUOpen( uURL )

# Doc: Introduction
def slDocIntroduction() :

	# Set URL
	uURL = QtCore.QUrl( "file:" + Settings.Path.sQ7Z + Settings.Path.sSep + "Doc" + Settings.Path.sSep + "README.txt" )

	slUOpen( uURL )

# Doc: Requests
def slDocRequests() :

	# Set URL
	uURL = QtCore.QUrl( "file:" + Settings.Path.sQ7Z + Settings.Path.sSep + "Doc" + Settings.Path.sSep + "TODO.txt" )

	slUOpen( uURL )
