"""
Q7Z: P7Zip GUI
Designed by Chris Giles

File:		Input.py
Purpose:	Input arguments handler
"""


### Imports

# Q7Z 1
import	Import

# Python
try :
	import	sys
except :
	Import.slException( "Python" )

# PyQt4
try :
	from	PyQt4	import QtCore
except :
	Import.slException( "PyQt4" )

# Q7Z 2
import	Display, Import, List, Main, Profile, Settings, Thread


### Slots

# Print Q7Z info
def slPQ7ZInfo() :
	print ""
	print Settings.Application.sName + " " + Settings.Application.sVersion + ""
	print "Designed by " + Settings.Author.sName
	print ""
	print Settings.Application.sName + " is a P7Zip GUI for Linux, which attempts to simplify data compression and backup."
	print ""

# Print Usage
def slPUsage() :

	print "Usage: " + Settings.Application.sName + " [commands] [files]"
	print ""
	print "commands"
	print ""
	print "	c: Create archive"
	print "	e: Extract archive"
	print "	t: Test archive"
	print ""
	print "	Create using:"
	print "	d: 'Default' profile"
	print "	f: 'Flash' profile"
	print "	l: 'Local' profile"
	print "	r: 'Remote' profile"
	print "	s: 'Storage' profile"
	print "	L: List file"
	print ""
	print "	Extract:"
	print "	b: Beneath"
	print ""
	print "	i: Invisible"
	print "	p: Prevent auto update checking"
	print "	v: Verbose"
	print "	h: Help"
	print ""


# Input arguments
def slArgTest() :

	# Supplied arguments
	if Settings.Input.iNumArgs >= 2 :

		# Help
		if "h" in sys.argv[1] :

			# Q7Z
			slPQ7ZInfo()

			# Usage
			slPUsage()

			# Exit
			sys.exit()

		# Verbose
		if "v" in sys.argv[1] :

			Settings.Init.bVerbose = True

			slPQ7ZInfo()

			print "OS = " + Settings.sOS
			print "$KDEDIR = " + Settings.Path.sKDE
			print "$HOME = " + Settings.Path.sUser

			print "Proxy = " + Settings.Path.Proxy.user() + " : " + Settings.Path.Proxy.password() + " @ " + Settings.Path.Proxy.hostName() + " : " + str( Settings.Path.Proxy.port() )
			print ""

		# Profile
		if "f" in sys.argv[1] :
			Profile.slLoadFlash()
		elif "l" in sys.argv[1] :
			Profile.slLoadLocal()
		elif "r" in sys.argv[1] :
			Profile.slLoadRemote()
		elif "s" in sys.argv[1] :
			Profile.slLoadStorage()
		else :
			Profile.slLoadDefault()

		# Auto-Updates
		if "p" in sys.argv[1] :
			Settings.Init.bAutoUpdate = False

		# Supplied arguments
		if Settings.Input.iNumArgs >= 3 :

			# Visibility
			"""
			if "i" in sys.argv[1] :
				Settings.Init.bInvisible = True
			"""
			#Settings.Init.bInvisible = Import.Init.bInvisible

			if "L" in sys.argv[1] :
				# Use a list file
				List.slLoad( sys.argv[2] )
			else :
				# List of files to archive
				for iEntry in range(2,Settings.Input.iNumArgs) :
					Settings.List.slFiles.append( sys.argv[iEntry] )

			# Create Archive
			if "c" in sys.argv[1] :

				# Arrange the interface
				Display.slGUIExternal( Settings.Operation.iCreate )
				
				# Auto-exit
				if "d" in sys.argv[1] or "f" in sys.argv[1] or "l" in sys.argv[1] or "r" in sys.argv[1] or "s" in sys.argv[1] :
					Settings.Init.bAutoExit = True
					Thread.slCreate()

			# Extract Archive
			elif "e" in sys.argv[1] :

				# Arrange the interface
				Display.slGUIExternal( Settings.Operation.iExtract )
				
				# Beneath
				if "b" in sys.argv[1] :
					Display.slGUIBeneath()

				# Profile
				if "d" in sys.argv[1] :
					Settings.Init.bAutoExit = True
					Thread.slExtract()

			# Extract Archive
			elif "t" in sys.argv[1] :

				# Arrange the interface
				Display.slGUIExternal( Settings.Operation.iTest )

				# Default
				if "d" in sys.argv[1] :
					Settings.Init.bAutoExit = True
					Thread.slExtract()

	else :

		# Load 'Default' profile
		Profile.slLoadDefault()
