"""
Q7Z: P7Zip GUI
Designed by Chris Giles

File:		List.py
Purpose:	List handler
"""


### Imports

# Q7Z 1
import	Import

# PyQt4
try :
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException( "PyQt4" )

# Q7Z 2
import	Display, Help, Main, Settings


### Variables

"""
# List
oInfo			= QtCore.QObject()
oInfo.sName		= QtCore.QString()
"""

### Slots

# Load list
def slLoad( sName ) :

	sName = QtCore.QString( sName )
	sPath = QtCore.QString( Settings.Path.sUser + "/.kde/share/apps/Q7Z/Lists/" )

	# Choose file
	if not sName.isEmpty() :
		sPath += sName + ".txt"
	else :
		sPath = QtGui.QFileDialog.getOpenFileName( None , "" , sPath , "Lists (*.txt)" )

	if not sPath.isEmpty() :

		# Forget current files
		Settings.List.slFiles.clear()

		if not sPath.endsWith( ".txt" , QtCore.Qt.CaseInsensitive ) :
			sPath += ".txt"

		# Read list file
		fList = QtCore.QFile( sPath )

		if not fList.open( QtCore.QIODevice.ReadOnly | QtCore.QIODevice.Text ) :

			# Verbose
			if Settings.Init.bVerbose is True :
				print "List: slLoad: Error"
				print ""

			Display.slError( "Error: Could not load the desired list." )

		else :

			# Prepare text stream
			tsList = QtCore.QTextStream( fList )
			sLine = QtCore.QString( "" )

			while not tsList.atEnd() :

				sLine = tsList.readLine()

				# Test the path validity
				if QtCore.QFile.exists( sLine ) :
					Settings.List.slFiles.append( sLine )

			sName = fList.fileName().section( Settings.Path.sSep , -1 , -1 )
			sName = sName.left( sName.lastIndexOf( '.' ) )
			Display.slStatus( "Loaded '" + sName + "' list" )

			fList.close()

			# Verbose
			if Settings.Init.bVerbose is True :
				print "List: slLoad: Success: " + sName
				print ""

			Display.slGUIExternal( Settings.Operation.iClear )

# Load 'Other' list
def slLoadOther() :
	slLoad( "" )


# Edit list
def slEdit( sName ) :

	sName = QtCore.QString( sName )
	sPath = QtCore.QString( Settings.Path.sUser + "/.kde/share/apps/Q7Z/Lists/" )

	# Choose file
	if not sName.isEmpty() :
		sPath += sName + ".txt"
	else :
		sPath = QtGui.QFileDialog.getOpenFileName( None , "" , sPath , "Lists (*.txt)" )

	if not sPath.isEmpty() :

		if not sPath.endsWith( ".txt" , QtCore.Qt.CaseInsensitive ) :
			sPath += ".txt"

		# Set URL
		uURL = QtCore.QUrl( "file:" + sPath )

		Help.slUOpen( uURL )

# Edit 'Other' list
def slEditOther() :
	slEdit( "" )


# Save list
def slSave( sName ) :

	sName = QtCore.QString( sName )
	sPath = QtCore.QString( Settings.Path.sUser + "/.kde/share/apps/Q7Z/Lists/" )

	# Choose file
	if not sName.isEmpty() :
		sPath += sName + ".txt"
	else :
		sPath = QtGui.QFileDialog.getSaveFileName( None , "" , sPath ,
			"Lists (*.txt)" , "" , QtGui.QFileDialog.DontConfirmOverwrite )

	if not sPath.isEmpty() :

		if not sPath.endsWith( ".txt" , QtCore.Qt.CaseInsensitive ) :
			sPath += ".txt"

		# Read list file
		fList = QtCore.QFile( sPath )

		if not fList.open( QtCore.QIODevice.WriteOnly | QtCore.QIODevice.Text ) :

			# Verbose
			if Settings.Init.bVerbose is True :
				print "List: slSave: Error"
				print ""

			Display.slError( "Error: Could not save the desired list." )

		else :

			# Prepare text stream
			tsList = QtCore.QTextStream( fList )

			# Header
			tsList << "### " + Settings.Application.sName + " " + Settings.Application.sVersion + ": List\n"
			tsList << "\n# Directories and/or files\n"

			# List of files to archive
			for iEntry in range(0,Settings.List.slFiles.count()) :
				tsList << Settings.List.slFiles.__getitem__(iEntry) + "\n"

			sName = fList.fileName().section( Settings.Path.sSep , -1 , -1 )
			sName = sName.left( sName.lastIndexOf( '.' ) )
			Display.slStatus( "Saved '" + sName + "' list" )

			fList.close()

			# Verbose
			if Settings.Init.bVerbose is True :
				print "List: slSave: Success: " + sName
				print ""

# Save 'Other' list
def slSaveOther() :
	slSave( "" )


# Test list directory
def slTestDir() :

	dPath = QtCore.QDir( Settings.Path.sUser + "/.kde/share/apps/Q7Z/Lists/" )

	# Create profile directory
	if not dPath.exists() :
		dPath.mkpath( dPath.path() )
