"""
Q7Z: P7Zip GUI
Designed by Chris Giles

File:		Main.py
Purpose:	Controller
"""


### Imports

# Q7Z 1
import	Import

# Python
try :
	import	sys
except :
	Import.slException( "Python" )

# PyQt4
try :
	
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui

except :
	Import.slException( "PyQt4" )

# Q7Z 2
import	Display, Event, Help, Input, List, Profile, Settings, Thread
try :
	from	Main_rc			import *
	from	Settings_rc		import *
	from	Ui_Main			import Ui_Main
	from	Ui_Settings		import Ui_Settings
except :
	Import.slException( Settings.Application.sName )


### Variables

# Visible?
if not Import.Init.bInvisible :

	# Main
	aMain			= QtGui.QApplication(sys.argv)
	mwMain			= QtGui.QMainWindow()
	uiMain			= Ui_Main()
	uiMain.setupUi(mwMain)

	# Settings
	dSettings		= QtGui.QDialog()
	uiSettings		= Ui_Settings()
	uiSettings.setupUi(dSettings)


### Slots


### Execution

# Binaries
Settings.slTestBinaries()

# Test profiles
Profile.slTestDir()
Profile.slTest( "Default" )
Profile.slTest( "Flash" )
Profile.slTest( "Local" )
Profile.slTest( "Remote" )
Profile.slTest( "Secure" )
Profile.slTest( "Storage" )

# Test lists
List.slTestDir()

# Settings
Settings.slInit()
Settings.slLoad()

# Events
Event.slConnections()

# Input arguments
Input.slArgTest()

# Display
Display.slInit()

# Update
Help.slUCheck()

# Visible?
if not Import.Init.bInvisible :
	# Event Loop
	aMain.exec_()

# Temporary
#print "Main: Finished"
