"""
Q7Z: P7Zip GUI
Designed by Chris Giles

File:		Profile.py
Purpose:	Profile handler
"""


### Imports

# Q7Z 1
import	Import

# PyQt4
try :
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException( "PyQt4" )

# Q7Z 2
import	Display, Main, Settings


### Variables

# Profile
oInfo						= QtCore.QObject()
oInfo.Type				= QtCore.QObject()
oInfo.Type.bSFX			= False
oInfo.Type.bSolid		= False
oInfo.Type.bTarball	= False
oInfo.Security					= QtCore.QObject()
oInfo.Security.bScramble = False
oInfo.Security.bPassword = False
oInfo.Source					= QtCore.QObject()
oInfo.Source.slFiles		= QtCore.QStringList()
oInfo.Dest						= QtCore.QObject()
oInfo.Dest.bDest			= False
oInfo.Dest.bStructured	= False
oInfo.Dest.bSeparate		= False
oInfo.Dest.bName			= False


### Slots

# Load profile
def slLoad( sName ) :

	sProPath = QtCore.QString( Settings.Path.sUser + "/.kde/share/apps/Q7Z/Profiles/" )

	# Choose file
	if sName != "" :
		sProPath += sName + ".txt"
	else :
		sProPath = QtGui.QFileDialog.getOpenFileName( None , "" , sProPath , "Profiles (*.txt)" )

	if not sProPath.isEmpty() :

		if not sProPath.endsWith( ".txt" , QtCore.Qt.CaseInsensitive ) :
			sProPath += ".txt"

		# Read profile
		fPro = QtCore.QFile( sProPath )

		if not fPro.open( QtCore.QIODevice.ReadOnly | QtCore.QIODevice.Text ) :

			# Verbose
			if Settings.Init.bVerbose is True :
				print "Profile: slLoad: Error"
				print ""

			Display.slError( "Error: Could not load the desired profile." )

		else :

			# Profile
			oPI = oInfo

			# Prepare text stream
			tsPro = QtCore.QTextStream( fPro )
			sLine = QtCore.QString( "" )

			while not tsPro.atEnd() :

				sLine = tsPro.readLine()

				# Recognised options

				# Type
				if sLine.startsWith( "Archive_Format " ) :
					oPI.Type.sAlgorithm = sLine.section( ' ', 2 )
				elif sLine.startsWith( "Creation_Method " ) :
					oPI.Type.sMethod = sLine.section( ' ', 2 )
				elif sLine.startsWith( "Compression_Level " ) :
					oPI.Type.sComp = sLine.section( ' ', 2 )
				elif sLine.startsWith( "Volume_Size " ) :
					oPI.Type.sVolume = sLine.section( ' ', 2 )
				elif sLine.startsWith( "SFX " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Type.bSFX = True
					else :
						oPI.Type.bSFX = False
				elif sLine.startsWith( "Solid " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Type.bSolid = True
					else :
						oPI.Type.bSolid = False
				elif sLine.startsWith( "Tarball " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Type.bTarball = True
					else :
						oPI.Type.bTarball = False
				# Security
				elif sLine.startsWith( "Scramble " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Security.bScramble = True
					else :
						oPI.Security.bScramble = False
				elif sLine.startsWith( "Password " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Security.bPassword = True
					else :
						oPI.Security.bPassword = False
				# Destination
				elif sLine.startsWith( "Destination " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Dest.bDest = True
					else :
						oPI.Dest.bDest = False
				elif sLine.startsWith( "Structured " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Dest.bStructured = True
					else :
						oPI.Dest.bStructured = False
				elif sLine.startsWith( "Separate " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Dest.bSeparate = True
					else :
						oPI.Dest.bSeparate = False
				elif sLine.startsWith( "Destination_Dir " ) :
					oPI.Dest.sDir = sLine.section( ' ', 2 )
				elif sLine.startsWith( "Archive_Name " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Dest.bName = True
					else :
						oPI.Dest.bName = False

			sName = fPro.fileName().section( Settings.Path.sSep , -1 , -1 )
			sName = sName.left( sName.lastIndexOf( '.' ) )

			Display.slStatus( "Loaded '" + sName + "' profile" )

			fPro.close()

			# Verbose
			if Settings.Init.bVerbose is True :
				print "Profile: slLoad: Success: " + sName
				print ""

			# Set GUI
			Display.slGuiProfileSetCreate( oPI )


# Load 'Other' profile
def slLoadOther() :
	slLoad( "" )

# Load 'Default' profile
def slLoadDefault() :
	slLoad( "Default" )

# Load 'Flash' profile
def slLoadFlash() :
	slLoad( "Flash" )

# Load 'Local' profile
def slLoadLocal() :
	slLoad( "Local" )

# Load 'Remote' profile
def slLoadRemote() :
	slLoad( "Remote" )

# Load 'Secure' profile
def slLoadSecure() :
	slLoad( "Secure" )

# Load 'Storage' profile
def slLoadStorage() :
	slLoad( "Storage" )


# Save profile
def slSave( sName ) :

	sProPath = QtCore.QString( Settings.Path.sUser + "/.kde/share/apps/Q7Z/Profiles/" )

	# Choose file
	if sName != "" :
		sProPath += sName + ".txt"
	else :
		sProPath = QtGui.QFileDialog.getSaveFileName( None , "" , sProPath ,
			"Profiles (*.txt)" , "" , QtGui.QFileDialog.DontConfirmOverwrite )

	if not sProPath.isEmpty() :

		if not sProPath.endsWith( ".txt" , QtCore.Qt.CaseInsensitive ) :
			sProPath += ".txt"

		# Write profile
		fPro = QtCore.QFile( sProPath )

		if not fPro.open( QtCore.QIODevice.WriteOnly | QtCore.QIODevice.Text ) :

			# Verbose
			if Settings.Init.bVerbose is True :
				print "Profile: slSave: Error"
				print ""

			Display.slError( "Error: Could not save the desired profile." )

		else :

			# Profile
			oPI = oInfo

			# Get GUI
			Display.slGuiProfileGetCreate( oPI )

			# Prepare text stream
			tsPro = QtCore.QTextStream( fPro )

			# Header
			tsPro << "### " + Settings.Application.sName + " " + Settings.Application.sVersion + ": Profile\n"

			# Recognised options

			# Type
			tsPro << "\n# Type\n"
			tsPro << "Archive_Format = " + oPI.Type.sAlgorithm + "\n"
			tsPro << "Creation_Method = " + oPI.Type.sMethod + "\n"
			tsPro << "Compression_Level = " + oPI.Type.sComp + "\n"
			tsPro << "Volume_Size = " + oPI.Type.sVolume + "\n"
			if not oPI.Type.bSFX :
				tsPro << "SFX = No\n"
			else :
				tsPro << "SFX = Yes\n"
			if not oPI.Type.bSolid :
				tsPro << "Solid = No\n"
			else :
				tsPro << "Solid = Yes\n"
			if not oPI.Type.bTarball :
				tsPro << "Tarball = No\n"
			else :
				tsPro << "Tarball = Yes\n"

			# Security
			tsPro << "\n# Security\n"
			if not oPI.Security.bScramble :
				tsPro << "Scramble = No\n"
			else :
				tsPro << "Scramble = Yes\n"
			if not oPI.Security.bPassword :
				tsPro << "Password = No\n"
			else :
				tsPro << "Password = Yes\n"

			# Destination
			tsPro << "\n# Destination\n"
			if not oPI.Dest.bDest :
				tsPro << "Destination = No\n"
			else :
				tsPro << "Destination = Yes\n"
			if not oPI.Dest.bStructured :
				tsPro << "Structured = No\n"
			else :
				tsPro << "Structured = Yes\n"
			if not oPI.Dest.bSeparate :
				tsPro << "Separate = No\n"
			else :
				tsPro << "Separate = Yes\n"
			tsPro << "Destination_Dir = " + oPI.Dest.sDir + "\n"
			if not oPI.Dest.bName :
				tsPro << "Archive_Name = No\n"
			else :
				tsPro << "Archive_Name = Yes\n"

			sName = fPro.fileName().section( Settings.Path.sSep , -1 , -1 )
			sName = sName.left( sName.lastIndexOf( '.' ) )
			Display.slStatus( "Saved '" + sName + "' profile" )

			fPro.close()

			# Verbose
			if Settings.Init.bVerbose is True :
				print "Profile: slSave: Success: " + sName
				print ""

# Save 'Other' profile
def slSaveOther() :
	slSave( "" )

# Save 'Default' profile
def slSaveDefault() :
	slSave( "Default" )

# Save 'Flash' profile
def slSaveFlash() :
	slSave( "Flash" )

# Save 'Local' profile
def slSaveLocal() :
	slSave( "Local" )

# Save 'Remote' profile
def slSaveRemote() :
	slSave( "Remote" )

# Save 'Secure' profile
def slSaveSecure() :
	slSave( "Secure" )

# Save 'Storage' profile
def slSaveStorage() :
	slSave( "Storage" )


# Reset profile
def slReset( sName ) :

	sBackupPath = Settings.Path.sQ7Z + "/Desktop/Profiles/"
	sBackupPath += sName + ".txt"
	sProPath = QtCore.QString( Settings.Path.sUser + "/.kde/share/apps/Q7Z/Profiles/" + sName + ".txt" )

	# Remove current
	QtCore.QFile.remove( sProPath )

	# Copy original
	QtCore.QFile.copy( sBackupPath , sProPath )

	Display.slStatus( "Reset '" + sName + "' profile" )


# Reset 'Default' profile
def slResetDefault() :
	slReset( "Default" )

# Reset 'Flash' profile
def slResetFlash() :
	slReset( "Flash" )

# Reset 'Local' profile
def slResetLocal() :
	slReset( "Local" )

# Reset 'Remote' profile
def slResetRemote() :
	slReset( "Remote" )

# Reset 'Secure' profile
def slResetSecure() :
	slReset( "Secure" )

# Reset 'Storage' profile
def slResetStorage() :
	slReset( "Storage" )


# Test profile directory
def slTestDir() :

	"""
	# TODO: Temporary; remove dir misplaced in an earlier release
	# Need to find a way to remove all files within the dir first; wildcards don't seem to work
	dPath = QtCore.QDir( )
	QtCore.QFile.remove( Settings.Path.sUser + "/Profiles/blah.txt" )
	dPath.rmdir( Settings.Path.sUser + "/Profiles/" )
	#QtCore.QDir.rmdir( Settings.Path.sUser + "/Profiles/" )
	"""

	dPath = QtCore.QDir( Settings.Path.sUser + "/.kde/share/apps/Q7Z/Profiles/" )

	# Create profile directory
	if not dPath.exists() :
		dPath.mkpath( dPath.path() )


# Test profile
def slTest( sName ) :

	if not QtCore.QFile.exists( Settings.Path.sUser + "/.kde/share/apps/Q7Z/Profiles/" + sName + ".txt" ) :
		slReset( sName )
