/***************************************************************************
                          cabout.cpp  -  description
                             -------------------
    begin                : Tue Sep 30 2003
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcursor.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qtabwidget.h>
#include <qtextedit.h>
#include "cabout.h"
#include "../config.h"

#include "pixmaps/about.img"
#include "pixmaps/bg.xpm"
#include "pixmaps/about_button_normal.xpm"
#include "pixmaps/about_button_over.xpm"
#include "pixmaps/about_button_down.xpm"
#include "pixmaps/about_button_close.xpm"
#include "pixmaps/about_button_close_over.xpm"

CAboutButtonClose::CAboutButtonClose(QWidget *parent) : QWidget(parent)
{
  setGeometry(parent->width() - 20, 4, 16, 16);
  setPaletteBackgroundPixmap(QPixmap((const char**)about_button_close_xpm));
}


void CAboutButtonClose::enterEvent(QEvent*)
{
  setPaletteBackgroundPixmap(QPixmap((const char**)about_button_close_over_xpm));
}


void CAboutButtonClose::leaveEvent(QEvent*)
{
  setPaletteBackgroundPixmap(QPixmap((const char**)about_button_close_xpm));
}


void CAboutButtonClose::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == LeftButton)
    ((QDialog*)parent())->close();
}


CAboutButton::CAboutButton(int x, int y, const char *label, QWidget *parent)
: QWidget(parent), status(0)
{
  setGeometry(x, y, 90, 30);
  this->label = label;
}

void CAboutButton::paintEvent(QPaintEvent*)
{
  QPixmap pix;
  switch(status)
    {
      case 0: pix = QPixmap((const char**)about_button_normal_xpm); break;
      case 1: pix = QPixmap((const char**)about_button_over_xpm); break;
      case 2: pix = QPixmap((const char**)about_button_down_xpm); break;
    }
  QPainter paint(this);
  paint.setPen(Qt::black);
  paint.drawPixmap(0, 0, pix);
  paint.drawText(rect(), AlignCenter, label);
}


void CAboutButton::enterEvent(QEvent*)
{
  if(status == 2) return;
  status = 1;
  repaint();
}


void CAboutButton::leaveEvent(QEvent*)
{
  if(status == 2) return;
  status = 0;
  repaint();
}

void CAboutButton::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == LeftButton)
    setOn();
}

void CAboutButton::setOn()
{
  if(status == 2) return;
  status = 2;
  repaint();
  emit signalOn();
}


void CAboutButton::setOff()
{
  if(status == 0) return;
  status = 0;
  repaint();
}


CAbout::CAbout(QWidget *parent) : QDialog(parent, "About", true, WStyle_Customize|WStyle_NoBorder)
{
  setFixedSize(330, 360);
  setPaletteBackgroundPixmap(QPixmap((const char**)bg1_xpm));

  new CAboutButtonClose(this);

  txt = new QTextEdit(this);
  txt->setFrameStyle(QFrame::Box | QFrame::Sunken);
  txt->setLineWidth(1);
  txt->setMargin(4);
  txt->setGeometry(15, 150, width() - 30, 170);
  txt->setReadOnly(true);
  //txt->setTextFormat(PlainText);
  txt->setPaletteBackgroundPixmap(QPixmap((const char**)bg1_xpm));

  prog = new CAboutButton(21, 117, tr("Program"), this);
  auth = new CAboutButton(21 + 90 + 8, 117, tr("Author"), this);
  cont = new CAboutButton(21 + 90 * 2 + 16, 117, tr("Contribs"), this);

  connect(prog, SIGNAL(signalOn()), this, SLOT(showProgram()));
  connect(auth, SIGNAL(signalOn()), this, SLOT(showAuthor()));
  connect(cont, SIGNAL(signalOn()), this, SLOT(showContribs()));

  prog->setOn();
  showProgram();
}


CAbout::~CAbout()
{
}


void CAbout::paintEvent(QPaintEvent *p)
{
  QPainter paint(this);
  QPixmap logo;
  logo.loadFromData(about_png, len_about_png, "PNG", QPixmap::Color);
  paint.drawPixmap(5, 6, logo);
  paint.setPen(QPen(Qt::black, 2));
  paint.drawRect(1, 1, width() - 1, height() - 1);
  paint.setPen(QPen(Qt::black, 1));
  paint.drawText(0, 320, width(), 40, AlignCenter, "(c) 2002-2006 " + tr("by") + " Serghei Amelian");
  QDialog::paintEvent(p);
}

void CAbout::showProgram()
{
  QString string = tr("Version") + ": " VERSION
    "\nhttp://qfaxreader.sourceforge.net\n\n" +
    tr("Written with QT, crossplatform toolkit from Trolltech.\n\n"
    "TIFF handler use libtiff and alias feature is written with GDBM/Berkeley DB.");

  auth->setOff();
  cont->setOff();
  txt->setText(string);
}


void CAbout::showAuthor()
{
  QString string = tr(
    "My name is Serghei Amelian.\n\n"
    "I'm from Romania and currently I living in Navodari (Constanta).\n\n"
    "If you want to contact me, send a mail to serghei.amelian@gmail.com");

  prog->setOff();
  cont->setOff();
  txt->setText(string);
}


void CAbout::showContribs()
{
  QString string =
    "Hans-Peter Jansen <hpj@urpla.net>\n" + tr("Initial smooth scaling and some other bits.") + "\n\n"
    "Aidan Van Dyk <aidan@highrise.ca>\n" + tr("Initial patch for CID support.") + "\n\n"
    "Grant Parnell <grant@everythinglinux.com.au>\nhttp://www.linuxhelp.com.au\n" + tr("Donate to me a Seagate 120GB harddisk") + "\n\n"
    "Ion-Mihai Tetcu <itetcu@people.tecnik93.com>\n" + tr("FreeBSD port maintainer") + "\n\n"
    "Stan Vasilyev <stan.vasilyev@csun.edu>\n" + tr("Debian package maintainer and initial SIGPIPE fix");

  prog->setOff();
  auth->setOff();
  txt->setText(string);
}

