/***************************************************************************
                          cabout.h  -  description
                             -------------------
    begin                : Tue Sep 30 2003
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CABOUT_H
#define CABOUT_H

#include <qdialog.h>

class QTextEdit;

class CAboutButtonClose : public QWidget {
Q_OBJECT
public:
  CAboutButtonClose(QWidget *parent);
protected:
  void enterEvent(QEvent *p);
  void leaveEvent(QEvent *p);
  void mousePressEvent(QMouseEvent *e);
};

class CAboutButton : public QWidget {
Q_OBJECT
public:
  CAboutButton(int x, int y, const char *label, QWidget *parent);
protected:
  void paintEvent(QPaintEvent *p);
  void enterEvent(QEvent *p);
  void leaveEvent(QEvent *p);
  void mousePressEvent(QMouseEvent *e);
public slots:
  void setOn();
  void setOff();
signals:
  void signalOn();
private:
  QString label;
  int status;
};

class CAbout : public QDialog  {
Q_OBJECT
public: 
  CAbout(QWidget *parent);
  ~CAbout();
protected:
  void paintEvent(QPaintEvent *p);
public slots:
  void showProgram();
  void showAuthor();
  void showContribs();
private:
  QTextEdit *txt;
  CAboutButton *prog, *auth, *cont;
};

#endif
