/***************************************************************************
                          caliasesdatabase.cpp  -  description
                             -------------------
    begin                : Thu Jan 2 2003
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "caliasesdatabase.h"

#if(defined BDB || defined GDBM)

CAliasesDatabase::CAliasesDatabase(const char *filename) : isOK(false)
{
  this->filename = filename;
#ifdef GDBM
  this->filename.append(".db"); // append extension
#endif
  db = 0;
}


bool CAliasesDatabase::open()
{
  isOK = (bool)(db = dbm_open(filename.utf8().data(), DBM_WRCREAT, 00664));
  return isOK;
}


bool CAliasesDatabase::close()
{
  if(db != 0)
    {
      dbm_close(db);
      db = 0;
      isOK = false;
    }
  return true;
}


bool CAliasesDatabase::store(const QString &key, const QString &data)
{
  QCString k = key.utf8();
  datum d_key;
  d_key.dptr = k.data();
  d_key.dsize = k.length() + 1;

  QCString d = data.utf8();
  datum d_data;
  d_data.dptr = d.data();
  d_data.dsize = d.length() + 1;

  return 0 == dbm_store(db, d_key, d_data, DBM_REPLACE);
}


bool CAliasesDatabase::drop(const QString &key)
{
  QCString k = key.utf8();
  datum d_key;
  d_key.dptr = k.data();
  d_key.dsize = k.length() + 1;

  return 0 == dbm_delete(db, d_key);
}


QString CAliasesDatabase::get(const QString &key)
{
  QCString k = key.utf8();

  datum d_key;
  d_key.dptr = k.data();
  d_key.dsize = k.length() + 1;

  datum d_data = dbm_fetch(db, d_key);
  QString res = QString::fromUtf8(d_data.dptr);

#ifndef BDB            // FIXME : without free, leak memory?
  if(NULL != d_data.dptr)
    free(d_data.dptr); // with Berkeley BD generate SEGFAULT
#endif

  return res;
}

#endif // (defined DBD || defined GDBM)
