/***************************************************************************
                          caliasesdatabase.h  -  description
                             -------------------
    begin                : Thu Jan 2 2003
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "../config.h"

#ifndef CALIASESDATABASE_H
#define CALIASESDATABASE_H

#if(defined BDB || defined GDBM)
#ifdef GDBM
  #include <gdbm.h>
  #define DBM GDBM_FILE
  #define DBM_WRCREAT GDBM_WRCREAT
  #define DBM_REPLACE GDBM_REPLACE
  #define dbm_open(a,b,c) gdbm_open(a,512,b,c,0)
  #define dbm_close(a) gdbm_close(a)
  #define dbm_store(a,b,c,d) gdbm_store(a,b,c,d)
  #define dbm_delete(a,b) gdbm_delete(a,b)
  #define dbm_fetch(a,b) gdbm_fetch(a,b)
#else
  #define DB_DBM_HSEARCH 1
  #include <db.h>
  #define DBM_WRCREAT O_CREAT|O_RDWR
  #define DBM DBM*
#endif
#include <fcntl.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include <qstring.h>
#undef store

class CAliasesDatabase {
public:
  CAliasesDatabase(const char *filename);
  ~CAliasesDatabase() { close(); }
  bool open();
  bool close();
  bool store(const QString &key, const QString &data);
  bool drop(const QString &key);
  QString get(const QString &key);
  bool isOK;
private:
  QString filename;
  DBM db;
};

#endif // (defined BDB || defined GDBM)
#endif // CALIASESDATABASE_H
