/***************************************************************************
                          cexportdialog.cpp  -  description
                             -------------------
    begin                : Sat Feb 8 2003
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cexportdialog.h"
#include "ctiffhandler.h"

#include <qimage.h>
#include <qpixmap.h>
#include <qregexp.h>
#include <qcheckbox.h>
#include <qmessagebox.h>
#include <errno.h>


CExportDialog::CExportDialog()
{
  QStringList list = QImage::outputFormatList();
  QStringList::Iterator it = list.begin();
  setFilter(*it + " (*." + (*it == "JPEG" ? QString("jpg") : (*it).lower()) + ")");
  ++it;
  while(it != list.end())
    {
      addFilter(*it + " (*." + (*it == "JPEG" ? QString("jpg") : (*it).lower()) + ")");
      ++it;
    }

  check = new QCheckBox(tr("Use scaled image"), this);
  addWidgets((QLabel*)check, 0, 0);

  setMode(QFileDialog::AnyFile);
}

bool CExportDialog::save(QString & lastExportFolder, QString & exportFormat, bool & exportScaledImage, CTIFFHandler *tiffHandler)
{
  CExportDialog *dlg = new CExportDialog;
  dlg->setCaption(tr("Export"));
  dlg->setDir(lastExportFolder);
  dlg->setSelectedFilter(exportFormat);
  dlg->check->setChecked(exportScaledImage);

  if(dlg->exec() == QDialog::Accepted)
    {
      // save variable for remember
      lastExportFolder = dlg->dir()->path();
      exportFormat = dlg->selectedFilter();
      exportScaledImage= dlg->check->isChecked();

      // extract format from filter
      QString format = exportFormat.left(exportFormat.find(' '));

      // processing selected filename - 0.2.6
      QString file = dlg->selectedFile();
      file.replace(QRegExp("\\.....?$"), "");
      file.replace(QRegExp("\\-\\d\\d\\d$"), "");
      
      // write parts to disk
      tiffHandler->save(file, format, exportScaledImage);
    }

  delete dlg;
  return true;
}



