 /***************************************************************************
                          cfileslist.h  -  description
                             -------------------
    begin                : Tue Sep 17 2002
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CFILESLIST_H
#define CFILESLIST_H

#include "../config.h"
#include <qlistview.h>
#include <qtimer.h>

enum FileType { Folder, File };
class QPainter;
class CFilesList;
class CMainWindow;

class CFileListItem : public QListViewItem {
friend class CFilesList;
friend class CFilesListView;
public:
  CFileListItem(const QString &file, FileType type, QListView *parent, bool recent = false);
  void showFields();
  void setRecent(bool recent);
#if(defined BDB || defined GDBM)
  void replaceIdWithRealName();
#endif // (defined BDB || defined GDBM)
protected:
  virtual QString key(int column, bool) const;
  void paintCell(QPainter *p, const QColorGroup &cg, int column, int width, int alignment);
private:
  CFilesList *p;
  FileType type;
  bool recent;
  bool isReadable;
  QString id, sender, cidName, cidNumber, time, size;
};

class CFilesList : public QListView  {
Q_OBJECT
friend class CFileListItem;
friend class CFilesListView;
public:
  CFilesList(QWidget *parent=0, const char *name=0);
  ~CFilesList();
  int autoRefreshTime;
  bool autoRefreshActive;
  void startTimer();
  void stopTimer();
  void applyColumnsOptions(bool sender, bool cidName, bool cidNumber, bool time, bool size);
protected:
  void keyPressEvent(QKeyEvent *e);
  void contentsMouseMoveEvent(QMouseEvent *e);
public slots:
  void action(QListViewItem *item);
  void refresh();
  void load();
  void up();
  void contextMenu(QListViewItem *item, const QPoint & pos, int);
  void deleteFacsimile();
  void renameFacsimile();
  void alias();
  void reReadAliases();
signals:
  void open(const QString &file);
  void changePath(const QString &path);
  void signalClose();
private:
  bool hand;
  QTimer timer;
  int colSender, colCidName, colCidNumber, colTime, colSize;
};

#endif
