/***************************************************************************
                          cfileslistview.cpp  -  description
                             -------------------
    begin                : Wed Sep 18 2002
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cfileslistview.h"
#include "refresh.h"
#include "home.h"
#include <qpixmap.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qcombobox.h>
#include <qstringlist.h>
#include <qdir.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlineedit.h>

#include "../pix/up.img"
#include "../pix/home.img"
#include "../pix/refresh.img"
#include "../pix/trash_22.img"
#include "../pix/close.img"

CToolButton::CToolButton(const char *tip, const uchar *img, int img_len, QWidget *parent) : QToolButton(parent)
{
  QPixmap pix;
  pix.loadFromData(img, img_len);
  setPixmap(pix);

  setAutoRaise(true);
  setFixedSize(32, 32);

  QToolTip::add(this, tip);
  setToggleButton(false);
}


CFilesListView::CFilesListView(QWidget *parent, const char *name) : QWidget(parent,name)
{
  QVBoxLayout *layout = new QVBoxLayout(this, 0, 0);

  toolbox = new QWidget(this);
  toolbox->setMinimumHeight(34);
  toolbox->setMaximumHeight(34);

  // tool box
  QPixmap pix;
  QHBoxLayout *layout2 = new QHBoxLayout(toolbox, 0, 0);

  CToolButton *up = new CToolButton(tr("Up directory level"), up_png, len_up_png, toolbox);
  CToolButton *home = new CToolButton(tr("Go to default directory"), home_png, len_home_png, toolbox);
  CToolButton *refresh = new CToolButton(tr("Refresh"), refresh_png, len_refresh_png, toolbox);
  CToolButton *trash = new CToolButton(tr("Delete"), trash_22_png, len_trash_22_png, toolbox);
  CToolButton *close = new CToolButton(tr("Close filelist view"), close_png, len_close_png, toolbox);

  layout2->addWidget(up);
  layout2->addWidget(home);
  layout2->addWidget(refresh);
  layout2->addWidget(trash);
  layout2->addItem(new QSpacerItem(0, 0));
  layout2->addWidget(close);

  // path
  path = new QComboBox(this);
  path->setInsertionPolicy(QComboBox::AtBottom);

  // files list
  filesList = new CFilesList(this);
  filesList->setFrameShape(QFrame::NoFrame);
  filesList->setFocus();

  // layout
  layout->addWidget(toolbox);
  layout->addWidget(path);
  layout->addWidget(filesList);

  connect(path, SIGNAL(activated(const QString&)), this, SLOT(changePath(const QString&)));
  connect(filesList, SIGNAL(changePath(const QString&)), this, SLOT(slotChangePath(const QString&)));
  connect(up, SIGNAL(clicked()), filesList, SLOT(up()));

  connect(home, SIGNAL(clicked()), this, SLOT(home()));
  connect(home, SIGNAL(rightClicked()), this, SLOT(homeSetupDialog()));

  connect(refresh, SIGNAL(clicked()), filesList, SLOT(refresh()));
  connect(refresh, SIGNAL(rightClicked()), this, SLOT(refreshSetupDialog()));
  connect(trash, SIGNAL(clicked()), filesList, SLOT(deleteFacsimile()));
  connect(close, SIGNAL(clicked()), this, SLOT(slotHide()));
  connect(filesList, SIGNAL(open(const QString&)), this, SLOT(slotOpen(const QString&)));
  connect(filesList, SIGNAL(signalClose()), this, SLOT(slotClose()));
}


CFilesListView::~CFilesListView()
{
}


void CFilesListView::load()
{
  filesList->load();
}


void CFilesListView::slotChangePath(const QString &path)
{
  this->path->clear();

  QStringList paths = QStringList::split("/", path);
  QString curPath;

  this->path->insertItem("/", 0);

  for(QStringList::Iterator it = paths.begin(); it != paths.end(); ++it )
    {
      curPath += QString("/") + *it;
      this->path->insertItem(curPath, 0);
    }
}


void CFilesListView::changePath(const QString &path)
{
  slotChangePath(path);
  QDir::setCurrent(path);
  filesList->load();
}


void CFilesListView::refreshSetupDialog()
{
  uiRefresh dialog(this, tr("Refresh Setup"), true, WStyle_Customize | WStyle_NormalBorder | WStyle_Title | WStyle_SysMenu);
  dialog.setFixedSize(dialog.size());
  dialog.autorefresh->setChecked(autoRefreshActive());
  dialog.time->setValue(autoRefreshTime());
  if(dialog.exec())
    refreshSetup(dialog.autorefresh->isChecked(), dialog.time->value());
}


void CFilesListView::refreshSetup(bool active, int time)
{
  filesList->stopTimer();

  filesList->autoRefreshActive = active;
  filesList->autoRefreshTime = time;

  filesList->startTimer();
}


void CFilesListView::home()
{
  QDir::setCurrent(homePath);
  filesList->load();
}


void CFilesListView::homeSetup(const QString &homePath)
{
  this->homePath = homePath;
}


void CFilesListView::homeSetupDialog()
{
  uiHome dialog(this, tr("Default directory setup"), true, WStyle_Customize | WStyle_NormalBorder | WStyle_Title | WStyle_SysMenu);
  dialog.setFixedSize(dialog.size());
  dialog.homePath->setText(homePath);
  if(dialog.exec())
    homeSetup(dialog.homePath->text());
}


void CFilesListView::next()
{
  CFileListItem *item = (CFileListItem*)filesList->currentItem()->itemBelow();

  while(item && item->type == Folder)
    item = (CFileListItem*)item->itemBelow();

  if(item && item->type == File)
    {
      filesList->setCurrentItem(item);
      filesList->ensureItemVisible(item);
      filesList->action(item);
    }
}


void CFilesListView::prev()
{
  CFileListItem *item = (CFileListItem*)filesList->currentItem()->itemAbove();

  while(item && item->type == Folder)
    item = (CFileListItem*)item->itemAbove();

  if(item && item->type == File)
    {
      filesList->setCurrentItem(item);
      filesList->ensureItemVisible(item);
      filesList->action(item);
    }
}


void CFilesListView::applyColumnsOptions(bool sender, bool cidName, bool cidNumber, bool time, bool size)
{
  filesList->applyColumnsOptions(sender, cidName, cidNumber, time, size);
}
