/***************************************************************************
                          cfilelistview.h  -  description
                             -------------------
    begin                : Wed Sep 18 2002
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CFILESLISTVIEW_H
#define CFILESLISTVIEW_H

#include "cfileslist.h"
#include <qwidget.h>
#include <qtoolbutton.h>

class CFilesList;
class QComboBox;

class CToolButton : public QToolButton {
Q_OBJECT
public:
  CToolButton(const char *tip, const uchar *img, int img_len, QWidget *parent);
signals:
  void rightClicked();
protected:
  void mouseReleaseEvent(QMouseEvent *e)
    {
      if(e->button() == Qt::RightButton)
        emit rightClicked();
      else
        QToolButton::mouseReleaseEvent(e);
    }
};

class CFilesListView : public QWidget  {
Q_OBJECT
friend class CMainWindow;
public:
  CFilesListView(QWidget *parent=0, const char *name=0);
  ~CFilesListView();
  void load();
  void applyColumnsOptions(bool sender, bool cidName, bool cidNumber, bool time, bool size);
  bool isShownSender() const { return filesList->colSender; }
  bool isShownCidName() const { return filesList->colCidName; }
  bool isShownCidNumber() const { return filesList->colCidNumber; }
  bool isShownTime() const { return filesList->colTime; }
  bool isShownSize() const { return filesList->colSize; }
  bool autoRefreshActive() { return filesList->autoRefreshActive; }
  int autoRefreshTime() { return filesList->autoRefreshTime; }
  QString homePath;
signals:
  void signalHide();
  void open(const QString &file);
  void signalClose();
private slots:
  void slotHide() { emit signalHide(); }
  void slotOpen(const QString &file) { emit open(file); }
  void slotClose() { emit signalClose(); }
  void slotChangePath(const QString &path);
  void changePath(const QString & path);
  void refreshSetupDialog();
  void home();
  void homeSetup(const QString &homePath);
public slots:
  void homeSetupDialog();
  void refreshSetup(bool active, int time);
  void next();
  void prev();
private:
  QWidget *toolbox;
  QComboBox *path;
  CFilesList *filesList;
};

#endif
