/***************************************************************************
                          clangdir.cpp  -  description
                             -------------------
    begin                : Sat Mar 06 2003
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <errno.h>
#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>
#include "../config.h"
#include "clangdir.h"


CLangDir::CLangDir()
{
  list.setAutoDelete(true);
  
  QDir path(DOCDIR "/i18n");   
  path.setFilter(QDir::Files);
  path.setNameFilter("*.info");
  const QFileInfoList *fList = path.entryInfoList();
  if(!fList) return;
  
  QFileInfoListIterator it(*fList);
  QFileInfo *fi;
  for(fi = it.current(); fi; ++it, fi = it.current())
    {
      QFile f(path.path() + '/' + fi->fileName());
      if(f.open(IO_ReadOnly))
        {
          QTextStream stream(&f);
          QString line, key, value, language, translator, email, lastupdate, file;
    
          while(!stream.atEnd())
            {
              line = stream.readLine();
              key = line.section('=', 0, 0).stripWhiteSpace().lower();
              value = line.section('=', 1, 1).stripWhiteSpace();
              if(key == "language")
                language = value;
              else if(key == "translator")
                translator = value;
              else if(key == "email")
                email = value;
              else if(key == "lastupdate")
                lastupdate = value;
              else if(key == "file")
                file = value;
            }
          f.close();
          
          QString err = tr("Error while loading info translation file");
          if(!language || !translator || !email || !lastupdate)
            {
              qWarning(err + " (" + fi->fileName() + "):");
              if(!language)   qWarning("==> " + tr("Missing section 'Language'") + '.');
              if(!translator) qWarning("==> " + tr("Missing section 'Translator'") + '.');
              if(!email) qWarning("==> " + tr("Missing section 'Email'") + '.');
              if(!lastupdate) qWarning("==> " + tr("Missing section 'LastUpdate'") + '.');
              continue;
            }
          if(!file)
            {
              file = fi->fileName().section('.', 0, 0) + ".qm";
              qWarning(tr("Warning while loading info translation file") + " (" + fi->fileName() + "):");
              qWarning("==> " + tr("Missing section 'File', assuming") + ' ' + file + '.');
            }
          if(getLangInfo(language))
            {
              qWarning(err + " (" + fi->fileName() + "):");
              qWarning("==> " + tr("This translation") + " (" + language + ") " + tr("already exists in list") + '.');
            }
          else
            {
              list.append(new CLangInfo(language, translator, email, lastupdate, file));
            }
        }
      else
        {
          qWarning(tr("Error while opening file") + ' ' + fi->fileName() + ':');
          qWarning("==> %s", strerror(errno));
        }
    }
}


CLangInfo *CLangDir::getLangInfo(const QString &lang)
{
  CLangInfo *langInfo;
  for(langInfo = list.first(); langInfo; langInfo = list.next())
    if(langInfo->language.lower() == lang.lower())
      return langInfo;
  return 0;
}
