/***************************************************************************
                          clangdlg.h  -  description
                             -------------------
    begin                : Sun Mar 07 2003
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qcombobox.h>
#include <qptrlist.h>
#include <qtextedit.h>
#include "clangdlg.h"
 
CLangDlg::CLangDlg(QWidget *parent, const char *name)
: uiLang(parent, name, true, WStyle_Customize | WStyle_NormalBorder | WStyle_Title | WStyle_SysMenu)
{
  setFixedSize(size());
  CLangInfo *langInfo;
  int idx = 0;
  for(langInfo = dir.list.first(); langInfo; langInfo = dir.list.next())
    {
      if(langInfo->language == name)
        idx = comboLang->count();
      comboLang->insertItem(langInfo->language);
    }
  comboLang->setCurrentItem(idx);
  slotInfo(name);
}


void CLangDlg::slotInfo(const QString &lang)
{
  CLangInfo *langInfo = dir.getLangInfo(lang);
  if(langInfo)
    info->setText("<b>" + tr("Translator") + ":</b> " + langInfo->translator + "<br>\n<b>" + 
            tr("Email") + ":</b> " + langInfo->email + "<br>\n<b>" + 
            tr("Last update") + ":</b> " + langInfo->lastupdate);
  else
    info->clear();
}
