/***************************************************************************
                          cmainwindow.cpp  -  description
                             -------------------
    begin                : Tue 27 Aug 2002
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "cmainwindow.h"
#include "cexportdialog.h"
#include "clangdir.h"
#include "csettings.h"
#include "help.h"
#include "interface.h"
#include "clangdlg.h"
#include "cabout.h"
#include "ctiffhandler.h"
#include "cprinter.h"
#include "cfileslistview.h"
#include "czoomcombobox.h"
#include "qfrviewer.h"

#include <qapplication.h>
#include <qmenubar.h>
#include <qstatusbar.h>
#include <qpopupmenu.h>
#include <qspinbox.h>
#include <qaction.h>
#include <qlabel.h>
#include <qiconset.h>
#include <qfiledialog.h>
#include <qtoolbar.h>
#include <qcombobox.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <qmessagebox.h>
#include <qsplitter.h>
#include <stdlib.h>

#include "qfrtiffio.h"

#include "../pix/open.img"
#include "../pix/open_small.img"
#include "../pix/export.img"
#include "../pix/export_small.img"
//#include "../pix/acroread.img"
//#include "../pix/acroread_small.img"
#include "../pix/close.img"
#include "../pix/close_small.img"
#include "../pix/print.img"
#include "../pix/print_small.img"
#include "../pix/exit.img"
#include "../pix/exit_small.img"
#include "../pix/tree.img"
#include "../pix/tree_small.img"
#include "../pix/prevp.img"
#include "../pix/prevp_small.img"
#include "../pix/nextp.img"
#include "../pix/nextp_small.img"
#include "../pix/zoomi.img"
#include "../pix/zoomi_small.img"
#include "../pix/zoomo.img"
#include "../pix/zoomo_small.img"
#include "../pix/fullscr.img"
#include "../pix/fullscr_small.img"
#include "../pix/nofullscr.img"
#include "../pix/nofullscr_small.img"
#include "../pix/rotatel.img"
#include "../pix/rotatel_small.img"
#include "../pix/rotater.img"
#include "../pix/rotater_small.img"
#include "../pix/flip.img"
#include "../pix/flip_small.img"
#include "../pix/up.img"
#include "../pix/up_small.img"
#include "../pix/down.img"
#include "../pix/down_small.img"
#include "../pix/lang_small.img"
#include "../pix/default_directory_16.img"
#include "../pix/auto_refresh.img"
#include "../pix/help_small.img"
#include "../pix/about_small.img"
#include "../pix/interface_small.img"
#include "../pix/fit_height_16.img"
#include "../pix/fit_height_22.img"
#include "../pix/fit_width_16.img"
#include "../pix/fit_width_22.img"

#include "../config.h"
#if(defined BDB || defined GDBM)
#include "caliasesdatabase.h"
CAliasesDatabase *db;
#endif

extern char *ver;
QLabel *sender, *cidName, *cidNumber, *resolution;


CMainWindow::CMainWindow(QWidget *parent, const char *name) : QMainWindow(parent,name)
{
  setIcon(QPixmap("pixmaps/icon-16.png"));

  initPref();
  initTranslation();

  initStatusBar();
  tiffHandler = new CTIFFHandler(filename, this);
  connect(tiffHandler, SIGNAL(update()), this, SLOT(updateGUI()));

  splitter = new QSplitter(Qt::Horizontal, this);
  filesListView = new CFilesListView(splitter);
  splitter->setResizeMode(filesListView, QSplitter::KeepSize);
  setCentralWidget(splitter);

  initActions();
  initMenu();
  initToolBar();

  connect(filesListView, SIGNAL(signalHide()), this, SLOT(slotFilesViewHide()));
  connect(filesListView, SIGNAL(open(const QString&)), this, SLOT(open(const QString&)));
  connect(filesListView, SIGNAL(signalClose()), this, SLOT(slotClose()));

  viewer = new QfrViewer(splitter);
  viewer->canvas()->setContextMenu(image);

  connect(comboPage, SIGNAL(activated(int)), this, SLOT(slotComboPage(int)));

  loadPref();
  updateGUI();
  filesListView->load();

  connect(comboZoom, SIGNAL(zoomChanged(float)), this, SLOT(slotZoom(float)));
  connect(actionZoomIn, SIGNAL(activated()), comboZoom, SLOT(zoomIn()));
  connect(actionZoomOut, SIGNAL(activated()), comboZoom, SLOT(zoomOut()));
}


CMainWindow::~CMainWindow()
{
  delete translator;
}

void CMainWindow::loadPref()
{
  CSettings s;

  s.beginGroup( "/mainwindow" );
  setGeometry
    (
      s.readNumEntry("x", 10),
      s.readNumEntry("y", 10),
      s.readNumEntry("width", 750),
      s.readNumEntry("height", 550)
    );
  if(s.readBoolEntry("maximized", true))
    showMaximized();
  else
    showNormal();
  QString str = s.readEntry("dock");
  QTextStream ts(&str, IO_ReadOnly);
  ts >> *this;
  s.endGroup();

  s.beginGroup("/export");
  exportFormat = s.readEntry("format", "PNG");
  exportScaledImage = s.readBoolEntry("scaled", false);
  s.endGroup();

  s.beginGroup("/statusbar");
  ::sender->setShown(s.readBoolEntry("sender", true));
  ::cidName->setShown(s.readBoolEntry("cidname", true));
  ::cidNumber->setShown(s.readBoolEntry("cidnumber", true));
  time->setShown(s.readBoolEntry("time", true));
  ::resolution->setShown(s.readBoolEntry("resolution", true));
  page->setShown(s.readBoolEntry("pages", true));
  bool vis = s.readBoolEntry("visible", true);
  status->setShown(vis);
  actionStatusBar->setOn(vis);
  s.endGroup();

  s.beginGroup("/toolbar");
  setUsesBigPixmaps(s.readBoolEntry("uses_big_pixmaps", true));
  sbToolBarHideFullScr = s.readBoolEntry("hide_at_fullscr", true);
  s.endGroup();

  s.beginGroup("/sidebar");
  filesListView->applyColumnsOptions(
    s.readBoolEntry("sender", true),
    s.readBoolEntry("cidame", true),
    s.readBoolEntry("cidnumber", true),
    s.readBoolEntry("time", true),
    s.readBoolEntry("size", true));
  QValueList<int> sizes;
  sizes.append(s.readNumEntry("width", 286));
  splitter->setSizes(sizes);
  filesListView->homePath = s.readEntry("path", getenv("HOME"));
  QDir::setCurrent(s.readEntry("lastpath"));
  filesListView->refreshSetup(
    s.readBoolEntry("refresh", true),
    s.readNumEntry("interval", 10));
  vis = s.readBoolEntry("visible", true);
  actionFilesView->setOn(vis);
  filesListView->setShown(vis);
  s.endGroup();

  s.beginGroup( "/image" );
  comboZoom->setValue(s.readDoubleEntry("zoom", 0.5));
  actionSmoothScale->setOn(s.readBoolEntry("smooth", true));
  s.endGroup();
}


void CMainWindow::savePref()
{
  CSettings s;

  s.beginGroup( "/mainwindow" );
  s.writeEntry("maximized", isMaximized());
  if(!isMaximized())
    {
      s.writeEntry("x", x());
      s.writeEntry("y", y());
      s.writeEntry("width", width());
      s.writeEntry("height", height());
    }
  QString str;
  QTextStream ts(&str, IO_WriteOnly);
  ts << *this;
  s.writeEntry("dock", str);
  s.endGroup();

  s.beginGroup("/export");
  s.writeEntry("format", exportFormat);
  s.writeEntry("scaled", exportScaledImage);
  s.endGroup();

  s.beginGroup("/statusbar");
  s.writeEntry("sender", ::sender->isShown());
  s.writeEntry("cidname", ::cidName->isShown());
  s.writeEntry("cidnumber", ::cidNumber->isShown());
  s.writeEntry("time", time->isShown());
  s.writeEntry("resolution", ::resolution->isShown());
  s.writeEntry("pages", page->isShown());
  s.writeEntry("visible", status->isVisible());
  s.endGroup();

  s.beginGroup("/toolbar");
  s.writeEntry("uses_big_pixmaps", usesBigPixmaps());
  s.writeEntry("hide_at_fullscr", sbToolBarHideFullScr);
  s.endGroup();

  s.beginGroup("/sidebar");
  s.writeEntry("sender", filesListView->isShownSender());
  s.writeEntry("cidame", filesListView->isShownCidName());
  s.writeEntry("cidnumber", filesListView->isShownCidNumber());
  s.writeEntry("time", filesListView->isShownTime());
  s.writeEntry("size", filesListView->isShownSize());
  s.writeEntry("lastpath", QDir::current().path());
  s.writeEntry("path", filesListView->homePath);
  s.writeEntry("refresh", filesListView->autoRefreshActive());
  s.writeEntry("interval", filesListView->autoRefreshTime());

  s.writeEntry("visible", filesListView->isVisible());
  if(filesListView->isVisible())
    s.writeEntry("width", splitter->sizes().first());
  s.endGroup();

  s.beginGroup( "/image" );
  s.writeEntry("zoom", comboZoom->value());
  s.writeEntry("smooth", actionSmoothScale->isOn());
  s.endGroup();

  s.beginGroup( "/internationalization" );
  language = s.writeEntry("language", language);

  s.endGroup();
}


int CMainWindow::open(const QString &fileName)
{
  QFileInfo fileInfo(fileName);

  // load tiff image
  if(-1 == tiffHandler->load(fileName, comboZoom->value()))
    {
      filename->setText(tr("No file."));
      return -1;
    }

  filename->setText(fileInfo.fileName());
  return 0;
}


void CMainWindow::initMenu()
{
  // FILE
  file = new QPopupMenu(this);
  actionOpen->addTo(file);
  actionExport->addTo(file);
  //actionExportToPdf->addTo(file);
  actionClose->addTo(file);
  file->insertSeparator();
  actionPrint->addTo(file);
  file->insertSeparator();
  actionExit->addTo(file);

  // VIEW
  view = new QPopupMenu(this);
  actionPrevFax->addTo(view);
  actionNextFax->addTo(view);
  view->insertSeparator();
  actionPrevPage->addTo(view);
  actionNextPage->addTo(view);
  //actionPage->addTo(view);
  view->insertSeparator();
  actionZoomIn->addTo(view);
  actionZoomOut->addTo(view);
  actionZoomWidth->addTo(view);
  actionZoomHeight->addTo(view);
  view->insertSeparator();

  actionStatusBar->addTo(view);

  view->insertSeparator();
  actionFilesView->addTo(view);

  view->insertSeparator();
  actionFullScreen->addTo(view);

  // IMAGE
  image = new QPopupMenu(this);
  actionFlipVertically->addTo(image);
  image->insertSeparator();
  actionRotateLeft->addTo(image);
  actionRotateRight->addTo(image);
  image->insertSeparator();
  actionSmoothScale->addTo(image);

  // OPTIONS
  options = new QPopupMenu(this);
  actionInterface->addTo(options);
  actionAutoRefresh->addTo(options);
  actionDefaultDirectory->addTo(options);
  actionLanguage->addTo(options);

  // HELP
  help = new QPopupMenu(this);
  actionHelp->addTo(help);
  actionAbout->addTo(help);

  // MENU BAR
  menuBar()->insertItem(tr("&File"), file);
  menuBar()->insertItem(tr("&View"), view);
  menuBar()->insertItem(tr("&Image"), image);
  menuBar()->insertItem(tr("&Options"), options);
  menuBar()->insertItem(tr("&Help"), help);
}


QAction *CMainWindow::newAction(
  const char *text, const char *menuText,
  QKeySequence accel,
  const unsigned char *small, int small_len,
  const unsigned char *large, int large_len)
{
  QIconSet set;
  QPixmap pSmall, pLarge;

  pLarge.loadFromData(large, large_len);
  pSmall.loadFromData(small, small_len);
  set.setPixmap(pLarge, QIconSet::Large, QIconSet::Active);
  set.setPixmap(pSmall, QIconSet::Small, QIconSet::Active);
  return new QAction(text, set, menuText, accel, this);
}


void CMainWindow::initActions()
{
  actionOpen = newAction(tr("Open TIFF file"), tr("&Open"), CTRL+Key_O, open_small_png, len_open_small_png, open_png, len_open_png);
  actionExport = newAction(tr("Export current file"), tr("&Export"), CTRL+Key_O, export_small_png, len_export_small_png, export_png, len_export_png);
  //actionExportToPdf = newAction(tr("Export current file to Adobe Portable Document Format"), tr("E&xport to PDF"), CTRL+Key_X, acroread_small_png, len_acroread_small_png, acroread_png, len_acroread_png);
  actionClose = newAction(tr("Close file"), tr("&Close"), CTRL+Key_W, close_small_png, len_close_small_png, close_png, len_close_png);
  actionPrint = newAction(trUtf8("Print"), trUtf8("&Print"), CTRL+Key_P, print_small_png, len_print_small_png, print_png, len_print_png);
  actionExit = newAction(tr("Exit"), tr("E&xit"), ALT+Key_X, exit_small_png, len_exit_small_png, exit_png, len_exit_png);

  actionFilesView = newAction(tr("Files List"), tr("Files &List"), Key_L, tree_small_png, len_tree_small_png, tree_png, len_tree_png);
  actionFilesView->setToggleAction(true);

  actionNextFax = newAction(tr("Next Fax"), tr("N&ext fax"), CTRL+Key_PageDown, down_small_png, len_down_small_png, down_png, len_down_png);
  actionPrevFax = newAction(tr("Previous Fax"), tr("P&revious fax"), CTRL+Key_PageUp, up_small_png, len_up_small_png, up_png, len_up_png);
  actionNextPage = newAction(tr("Next Page"), tr("&Next page"), Key_PageDown, nextp_small_png, len_nextp_small_png, nextp_png, len_nextp_png);
  actionPrevPage = newAction(tr("Previous Page"), tr("&Previous page"), Key_PageUp, prevp_small_png, len_prevp_small_png, prevp_png, len_prevp_png);

  actionPage = new QAction(tr("Page..."), tr("&Page..."), 0, this, "page");

  actionZoomIn = newAction(tr("Zoom In"), tr("Zoom &in"), Key_Plus, zoomi_small_png, len_zoomi_small_png, zoomi_png, len_zoomi_png);
  actionZoomOut = newAction(tr("Zoom Out"), tr("Zoom &out"), Key_Minus, zoomo_small_png, len_zoomo_small_png, zoomo_png, len_zoomo_png);
  actionZoomWidth = newAction(tr("Fit Width"), tr("Fit &Width"), 0, fit_width_16_png, len_fit_width_16_png, fit_width_22_png, len_fit_width_22_png);
  actionZoomHeight = newAction(tr("Fit Height"), tr("Fit &Height"), 0, fit_height_16_png, len_fit_height_16_png, fit_height_22_png, len_fit_height_22_png);

  actionZoom = new QAction(tr("Zoom..."), tr("&Zoom..."), 0, this, "zoom");


  {
    QIconSet set;
    QPixmap pix;

    pix.loadFromData(fullscr_png, len_fullscr_png);
    set.setPixmap(pix, QIconSet::Large, QIconSet::Normal);
    pix.loadFromData(fullscr_small_png, len_fullscr_small_png);
    set.setPixmap(pix, QIconSet::Small, QIconSet::Normal);

    pix.loadFromData(nofullscr_png, len_nofullscr_png);
    set.setPixmap(pix, QIconSet::Large, QIconSet::Normal, QIconSet::On);
    pix.loadFromData(nofullscr_small_png, len_nofullscr_small_png);
    set.setPixmap(pix, QIconSet::Small, QIconSet::Normal, QIconSet::On);

    actionFullScreen = new QAction(tr("Full Screen"), set, tr("&Full Screen"), Key_F, this);
    actionFullScreen->setToggleAction(true);
  }

  actionSmoothScale = new QAction(tr("Smooth Scale"), tr("&Smooth Scale"), 0, this, "smoothscale", true);
  actionStatusBar = new QAction(tr("Status Bar"), tr("&Status Bar"), 0, this, "statusbar", true);

  actionFlipVertically = newAction(tr("Flip Vertically"), tr("Flip &vertically"), 0, flip_small_png, len_flip_small_png, flip_png, len_flip_png);
  actionRotateLeft = newAction(tr("Rotate Left"), tr("Rotate &left"), 0, rotatel_small_png, len_rotatel_small_png, rotatel_png, len_rotatel_png);
  actionRotateRight = newAction(tr("Rotate Right"), tr("Rotate &right"), 0, rotater_small_png, len_rotater_small_png, rotater_png, len_rotater_png);

  actionInterface = newAction(tr("Interface"), tr("&Interface"), 0, interface_small_png, len_interface_small_png, 0, 0);
  actionAutoRefresh  = newAction(tr("Auto Refresh"), tr("&Auto refresh"), 0, auto_refresh_png, len_auto_refresh_png, 0, 0);
  actionDefaultDirectory  = newAction(tr("Default Directory"), tr("&Default directory"), 0, default_directory_16_png, len_default_directory_16_png, 0, 0);
  actionLanguage = newAction(tr("Language"), tr("&Language"), 0, lang_small_png, len_lang_small_png, 0, 0);
  actionHelp = newAction(tr("Help"), tr("&Help"), 0, help_small_png, len_help_small_png, 0, 0);
  actionAbout = newAction(tr("About"), tr("&About"), 0, about_small_png, len_about_small_png, 0, 0);

  connect(actionOpen, SIGNAL(activated()), this, SLOT(slotOpen()));
  connect(actionExport, SIGNAL(activated()), this, SLOT(slotExport()));
  //connect(actionExportToPdf, SIGNAL(activated()), this, SLOT(slotExportToPdf()));
  connect(actionClose, SIGNAL(activated()), this, SLOT(slotClose()));
  connect(actionPrint, SIGNAL(activated()), this, SLOT(slotPrint()));
  connect(actionExit, SIGNAL(activated()), this, SLOT(slotExit()));
  connect(actionFilesView, SIGNAL(toggled(bool)), this, SLOT(slotFilesView(bool)));
  connect(actionNextFax, SIGNAL(activated()), this, SLOT(slotNextFax()));
  connect(actionPrevFax, SIGNAL(activated()), this, SLOT(slotPrevFax()));
  connect(actionNextPage, SIGNAL(activated()), this, SLOT(slotNextPage()));
  connect(actionPrevPage, SIGNAL(activated()), this, SLOT(slotPrevPage()));
  connect(actionPage, SIGNAL(activated()), this, SLOT(slotPage()));
  connect(actionZoomWidth, SIGNAL(activated()), this, SLOT(slotZoomWidth()));
  connect(actionZoomHeight, SIGNAL(activated()), this, SLOT(slotZoomHeight()));
  connect(actionFullScreen, SIGNAL(toggled(bool)), this, SLOT(slotFullScreen(bool)));
  connect(actionSmoothScale, SIGNAL(toggled(bool)), this, SLOT(slotSmoothScale(bool)));
  connect(actionStatusBar, SIGNAL(toggled(bool)), this, SLOT(slotStatusBar(bool)));
  connect(actionFlipVertically, SIGNAL(activated()), this, SLOT(slotFlipVertically()));
  connect(actionRotateLeft, SIGNAL(activated()), this, SLOT(slotRotateLeft()));
  connect(actionRotateRight, SIGNAL(activated()), this, SLOT(slotRotateRight()));
  connect(actionInterface, SIGNAL(activated()), this, SLOT(slotInterface()));
  connect(actionAutoRefresh, SIGNAL(activated()), filesListView, SLOT(refreshSetupDialog()));
  connect(actionDefaultDirectory, SIGNAL(activated()), filesListView, SLOT(homeSetupDialog()));
  connect(actionLanguage, SIGNAL(activated()), this, SLOT(slotLanguage()));
  connect(actionHelp, SIGNAL(activated()), this, SLOT(slotHelp()));
  connect(actionAbout, SIGNAL(activated()), this, SLOT(slotAbout()));
}


void CMainWindow::initStatusBar()
{
  status = new QStatusBar(this);
  status->setSizeGripEnabled(false);

  filename = new QLabel(tr("No file."), statusBar());
  filename->setIndent(3);

  ::sender = new QLabel(statusBar());
  ::sender->setIndent(3);
  ::cidName = new QLabel(statusBar());
  ::cidName->setIndent(3);
  ::cidNumber = new QLabel(statusBar());
  ::cidNumber->setIndent(3);

  time = new QLabel(statusBar());
  time->setIndent(3);

  ::resolution = new QLabel(statusBar());
  ::resolution->setIndent(3);

  page = new QLabel(statusBar());
  page->setIndent(3);

  status->addWidget(filename, 1, true);
  status->addWidget(::sender, 0, true);
  status->addWidget(::cidName, 0, true);
  status->addWidget(::cidNumber, 0, true);
  status->addWidget(time, 0, true);
  status->addWidget(::resolution, 0, true);
  status->addWidget(page, 0, true);
}


void CMainWindow::initToolBar()
{
  tbFile = new QToolBar(tr("File"), this);
  tbFile->setVerticallyStretchable(true);
  actionOpen->addTo(tbFile);
  actionExport->addTo(tbFile);
  //actionExportToPdf->addTo(tbFile);
  actionClose->addTo(tbFile);
  tbFile->addSeparator();
  actionPrint->addTo(tbFile);
  tbFile->addSeparator();
  actionExit->addTo(tbFile);

  tbView = new QToolBar(tr("View"), this);
  actionFilesView->addTo(tbView);
  tbView->addSeparator();
  actionPrevFax->addTo(tbView);
  actionNextFax->addTo(tbView);
  tbView->addSeparator();
  actionPrevPage->addTo(tbView);
  comboPage = new QComboBox(tbView);
  comboPage->setMaximumWidth(60);
  actionNextPage->addTo(tbView);
  tbView->addSeparator();

  actionZoomOut->addTo(tbView);
  comboZoom = new CZoomComboBox(tbView);
  actionZoomIn->addTo(tbView);
  comboZoom->setZoomInAction(actionZoomIn);
  comboZoom->setZoomOutAction(actionZoomOut);
  actionZoomWidth->addTo(tbView);
  actionZoomHeight->addTo(tbView);

  tbView->addSeparator();
  actionFullScreen->addTo(tbView);

  tbImage = new QToolBar(tr("Image"), this);
  actionFlipVertically->addTo(tbImage);
  tbImage->addSeparator();
  actionRotateLeft->addTo(tbImage);
  actionRotateRight->addTo(tbImage);
}


void CMainWindow::slotOpen()
{
  // choose a file
  QString fileName = QFileDialog::getOpenFileName(0, tr("TIFF Files (*.tif *.tiff);;All Files (*)"), this, tr("open file dialog"), tr("Choose a file"));
  if(!fileName)
    return;

  open(fileName);
}


void CMainWindow::slotExport()
{
  CExportDialog::save(lastExportFolder, exportFormat, exportScaledImage, tiffHandler);
}


void CMainWindow::slotExportToPdf()
{
}


void CMainWindow::slotClose()
{
  tiffHandler->close();
}


void CMainWindow::slotPrint()
{
  QfrTiffIO tif;
  //tif.Open(tiffHandler->handler());
  tif.Open(tiffHandler->filename(), "r");
  tif.SetDirectory(tiffHandler->page());

  // photometric interpretation
  short pmi = 0;
  tif.GetField(TIFFTAG_PHOTOMETRIC, &pmi);
  // samples per pixel
  short samples = 1;
  tif.GetField(TIFFTAG_SAMPLESPERPIXEL, &samples);

  //if(3 > pmi && 1 == samples)
    CPrinter::start(tif);
  //else
  //  QMessageBox::warning(0, tr("Print"), tr("Sorry, printing color images is not yet finished."));
}


void CMainWindow::slotExit()
{
  close();
}


void CMainWindow::slotFilesView(bool toggled)
{
  filesListView->setShown(toggled);
}


void CMainWindow::slotFilesViewHide()
{
  actionFilesView->setOn(false);
  filesListView->hide();
}


void CMainWindow::slotNextFax()
{
  filesListView->next();
}

void CMainWindow::slotPrevFax()
{
  filesListView->prev();
}


void CMainWindow::slotNextPage()
{
  tiffHandler->setPage(tiffHandler->page() + 1);
}


void CMainWindow::slotPrevPage()
{
  tiffHandler->setPage(tiffHandler->page() - 1);
}


void CMainWindow::slotPage()
{
}


void CMainWindow::slotZoomWidth()
{
  if(tiffHandler->currentPage().isNull()) return;
  int width = tiffHandler->image(tiffHandler->page() - 1).width();
  comboZoom->setValue((viewer->width() - 20) / (float)width);
}


void CMainWindow::slotZoomHeight()
{
  if(tiffHandler->currentPage().isNull()) return;
  int height = tiffHandler->currentImageRealHeight();
  comboZoom->setValue((viewer->height() - 20) / (float)height);
}


void CMainWindow::slotFullScreen(bool toggled)
{
  menuBar()->setShown(!toggled);

  if(toggled)
    {
      max = isMaximized();
      sbFile = tbFile->isShown();
      sbView = tbView->isShown();
      sbImage = tbImage->isShown();
      if(sbToolBarHideFullScr)
        {
          tbFile->hide();
          tbView->hide();
          tbImage->hide();
        }
      showFullScreen();
    }
  else
    {
      tbFile->setShown(sbFile);
      tbView->setShown(sbView);
      tbImage->setShown(sbImage);
      showNormal();
      if(max)
        showMaximized();
    }
}


void CMainWindow::slotSmoothScale(bool toggled)
{
  tiffHandler->setSmoothScale(toggled);
}


void CMainWindow::slotToolBarFile(bool toggled)
{
  tbFile->setShown(toggled);
}

void CMainWindow::slotToolBarView(bool toggled)
{
  tbView->setShown(toggled);
}


void CMainWindow::slotToolBarImage(bool toggled)
{
  tbImage->setShown(toggled);
}


void CMainWindow::slotStatusBar(bool toggled)
{
  status->setShown(toggled);
}


void CMainWindow::slotFlipVertically()
{
  tiffHandler->rotate(180);
}


void CMainWindow::slotRotateLeft()
{
  tiffHandler->rotate(-90);
}

void CMainWindow::slotRotateRight()
{
  tiffHandler->rotate(90);
}


void CMainWindow::slotInterface()
{
  uiInterface interface(this, "Interface", true, WStyle_Customize | WStyle_NormalBorder | WStyle_Title | WStyle_SysMenu);
  interface.exec();
}


void CMainWindow::slotLanguage()
{
  CLangDlg lang(this, language);
  if(lang.exec())
     {
       language = lang.comboLang->currentText();
       QMessageBox::information(this, tr("Internationalization"), tr("To change the language, QFaxReader must be restarted."));
     }
}


void CMainWindow::slotAbout()
{
  CAbout about(this);
  about.exec();
}


void CMainWindow::slotHelp()
{
  uiHelp help(this, "Help", true, WStyle_Customize | WStyle_NormalBorder | WStyle_Title | WStyle_SysMenu);
  help.exec();
}



/***************************************************************************
 *                                                                         *
 *   Update GUI                                                            *
 *                                                                         *
 ***************************************************************************/
void CMainWindow::updateGUI()
{
  if(!tiffHandler->pages())
    {
      filename->setText(tr("No file."));
      ::sender->setText("");
      ::cidName->setText("");
      ::cidNumber->setText("");

      time->setText("");
      ::resolution->setText("");
      page->setText("");
      actionExport->setEnabled(false);
      actionClose->setEnabled(false);
      actionPrint->setEnabled(false);
      actionNextPage->setEnabled(false);
      actionPrevPage->setEnabled(false);
      actionPage->setEnabled(false);
      comboPage->setEnabled(false);
      actionFlipVertically->setEnabled(false);
      actionRotateLeft->setEnabled(false);
      actionRotateRight->setEnabled(false);

      comboPage->clear();
      viewer->setPixmap(QPixmap());
      return;
    }

   //filename->setText(tiffHandler->filename());

#if(defined BDB || defined GDBM)
   QString id = tiffHandler->sender();
   QString realName = 0;
   if(db->isOK && !id.isNull())
     realName = db->get(id);
   ::sender->setText(tr("Sender") + ": " + (realName ? realName : id));
#else
   ::sender->setText(tr("Sender") + ": " + QString(tiffHandler->sender()));
#endif // (defined BDB || defined GDBM)

   cidName->setText(tr("CID Name") + ": " + QString(tiffHandler->cidName()));
   cidNumber->setText(tr("CID Number") + ": " + QString(tiffHandler->cidNumber()));

   time->setText(tr("Time") + ": " + QString(tiffHandler->time()));
   page->setText(tr("Page") + ' ' + QString::number(tiffHandler->page()) + ' ' + tr("of") + ' ' + QString::number(tiffHandler->pages()));

   actionExport->setEnabled(true);
   actionClose->setEnabled(true);
   actionPrint->setEnabled(true);

   actionNextPage->setEnabled(tiffHandler->page() < tiffHandler->pages() ? true : false);
   actionPrevPage->setEnabled(tiffHandler->page() > 1 ? true : false);
   actionPage->setEnabled(tiffHandler->pages() > 1 ? true : false);

   // combo pages
   comboPage->setEnabled(tiffHandler->pages() > 1 ? true : false);
   if(comboPage->count() != tiffHandler->pages())
     {
       comboPage->clear();
       for(int i = 1; i <= tiffHandler->pages(); i++)
         comboPage->insertItem(QString::number(i));
     }
   else
     {
       comboPage->setCurrentItem(tiffHandler->page() - 1);
     }

   actionFlipVertically->setEnabled(true);
   actionRotateLeft->setEnabled(true);
   actionRotateRight->setEnabled(true);

   viewer->setPixmap(tiffHandler->currentPage());
}


void CMainWindow::closeEvent(QCloseEvent *e)
{
#if(defined BDB || defined GDBM)
  delete db;
#endif
  savePref();
  e->accept();
}


void CMainWindow::initPref()
{
  QDir dir;
  dir.setPath(QDir::homeDirPath() + "/.qfaxreader");
  if(!dir.exists())
    dir.mkdir(dir.path());

#if(defined BDB || defined GDBM)
  QString aliases_path = QDir::homeDirPath() + "/.qfaxreader/aliases";
  db = new CAliasesDatabase(aliases_path);
  if(!QFile::exists(aliases_path + ".db"))
    QMessageBox::information(0, tr("Information"), tr("Database for aliases does not yet exist.\nQFaxReader will create it now."));
  if(!db->open())
    QMessageBox::warning(0, tr("Warning"), tr("Error at opening or creating database for aliases.\nDetails: ") + QString(strerror(errno)));
#endif
}

void CMainWindow::initTranslation()
{
  CSettings s;
  s.beginGroup( "/internationalization" );
  language = s.readEntry("language", "Standard");

  CLangDir dir;
  CLangInfo *info = dir.getLangInfo(language);
  if(!info) return;

  translator = new QTranslator(0);
  translator->load(info->file, DOCDIR "/i18n");
  qApp->installTranslator(translator);
}

