/***************************************************************************
                          cmainwindow.h  -  description
                             -------------------
    begin                : Tue 27 Aug 2002
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CMAINWINDOW_H
#define CMAINWINDOW_H

#include "ctiffhandler.h"
#include <qkeysequence.h>
#include <qwidget.h>
#include <qmainwindow.h>
#include <qtranslator.h>

class QPopupMenu;
class QAction;
class QLabel;
class QStatusBar;
class QComboBox;
class QSplitter;
class CFilesListView;
class CZoomComboBox;
class QfrViewer;

extern float zooms[];
extern QLabel *sender, *cidName, *cidNumber, *resolution;

class CMainWindow : public QMainWindow  {
Q_OBJECT
friend class uiInterface;
public:
  CMainWindow(QWidget *parent=0, const char *name=0);
  ~CMainWindow();

private:
  void loadPref();
  void savePref();
  void initTranslation();
  void initMenu();
  void initActions();
  void initStatusBar();
  void initToolBar();
  void initPref();
  QAction *newAction(const char *text, const char *menuText, QKeySequence accel, const unsigned char *small, int small_len, const unsigned char *large, int large_len);

private:
  QTranslator *translator;
  QSplitter *splitter;
  CFilesListView *filesListView;
  QPopupMenu *file, *view, *image, *options, *help;
  QAction *actionOpen, *actionExport, /*actionExportToPdf,*/ *actionClose, *actionPrint, *actionExit,
          *actionFilesView, *actionNextFax, *actionPrevFax, *actionNextPage, *actionPrevPage, *actionPage,
          *actionZoomIn, *actionZoomOut, *actionZoom, *actionZoomWidth, *actionZoomHeight, *actionFullScreen, *actionSmoothScale, *actionStatusBar,
          *actionFlipVertically, *actionRotateLeft, *actionRotateRight,
          *actionInterface, *actionAutoRefresh, *actionDefaultDirectory, *actionLanguage,
          *actionHelp, *actionAbout;
  QComboBox *comboPage;
  CZoomComboBox *comboZoom;
  QfrViewer *viewer;
  CTIFFHandler *tiffHandler;
  QStatusBar *status;
  QLabel *filename, *time, *page;
  float zoomFactorStep;
  QString language, defaultPrinter, defaultPageSize;
  QString lastExportFolder, exportFormat;
  bool exportScaledImage;
  bool sbToolBarHideFullScr;
  QToolBar *tbFile, *tbView, *tbImage;
  bool max, sbFile, sbView, sbImage;

public slots:
  int open(const QString &fileName);
  void slotOpen();
  void slotExport();
  void slotExportToPdf();
  void slotClose();
  void slotPrint();
  void slotExit();
  void slotFilesView(bool toggled);
  void slotFilesViewHide();
  void slotNextFax();
  void slotPrevFax();
  void slotNextPage();
  void slotPrevPage();
  void slotPage();
  void slotComboPage(int index) { tiffHandler->setPage(index + 1); }
  void slotZoom(float zoom) { tiffHandler->scale(zoom); }
  void slotZoomWidth();
  void slotZoomHeight();
  void slotFullScreen(bool);
  void slotSmoothScale(bool);
  void slotToolBarFile(bool);
  void slotToolBarView(bool);
  void slotToolBarImage(bool);
  void slotStatusBar(bool);
  void slotFlipVertically();
  void slotRotateLeft();
  void slotRotateRight();
  void slotInterface();
  void slotLanguage();
  void slotAbout();
  void slotHelp();
  void updateGUI();

protected:
  void closeEvent(QCloseEvent *e);
};

#endif
