/***************************************************************************
                          cprinter.h  -  description
                             -------------------
    begin                : Fri Aug 30 2002
    reworked             : Sun Jul 27 2003
    reworked             : Thu Mar 27 2005
    copyright            : (C) 2002-2005 by Serghei Amelian
    email                : serghei.amelian@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CPRINTER_H
#define CPRINTER_H

#include "dlgprinterprop.h"
#include <qregexp.h>
#include <qstring.h>

class QButtonGroup;
class QCheckBox;
class QComboBox;
class QProcess;
class QSpinBox;
class QfrTiffIO;

class QfrPrinterProp : public DlgPrinterProp {
Q_OBJECT
public:
  QfrPrinterProp(QWidget *parent = 0);

private slots:
  void changeUnit(const QString&);
  void changeLevel(const QString&);

public:
  QString currentUnit;
};

class QfrPrinterDlg : public QDialog {
Q_OBJECT
public:
  QfrPrinterDlg();
  void setNumberOfDirectories(int dirs);

private slots:
  void pages(int);
  void properties();
  void fromChanged(int);
  void toChanged(int);
  void readStdout();
  void readStderr();
  void donelpc();
  void loadPrinterSettings(const QString &string);
  QString lpcpath() const;

private:
  QProcess *lpc;
  QPushButton *pb_properties;
  QGroupBox *gb1, *gb4;
  QPushButton *pb_print;
  QLabel *l1;
  QRegExp rx;
  bool firstLine;
  bool tryBsdStyle;

public:
  QComboBox *cb_printers;
  QSpinBox *sbFrom, *sbTo;
  QButtonGroup *gb2, *gb3;
  QCheckBox *cb1, *cb2;
  QString cmd, paper, unit;
  int pslevel;
  float top, bottom, left, right;
};

class CPrinter {
public:
  CPrinter();
  static void start(QfrTiffIO &tif);
};

#endif
